/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Message;
import com.google.protobuf.ServiceException;
import com.google.protobuf.TextFormat;
import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.exceptions.DoNotRetryIOException;
import org.apache.hadoop.hbase.exceptions.NotServingRegionException;
import org.apache.hadoop.hbase.exceptions.RegionServerStoppedException;
import org.apache.hadoop.hbase.exceptions.UnknownScannerException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.DNS;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ScannerCallable
extends ServerCallable<Result[]> {
    public static final String LOG_SCANNER_LATENCY_CUTOFF = "hbase.client.log.scanner.latency.cutoff";
    public static final String LOG_SCANNER_ACTIVITY = "hbase.client.log.scanner.activity";
    public static final Log LOG = LogFactory.getLog(ScannerCallable.class);
    private long scannerId = -1L;
    private boolean instantiated = false;
    private boolean closed = false;
    private Scan scan;
    private int caching = 1;
    private ScanMetrics scanMetrics;
    private boolean logScannerActivity = false;
    private int logCutOffLatency = 1000;
    private boolean isRegionServerRemote = true;
    private long nextCallSeq = 0L;

    public ScannerCallable(HConnection connection, byte[] tableName, Scan scan, ScanMetrics scanMetrics) {
        super(connection, tableName, scan.getStartRow());
        this.scan = scan;
        this.scanMetrics = scanMetrics;
        Configuration conf = connection.getConfiguration();
        this.logScannerActivity = conf.getBoolean(LOG_SCANNER_ACTIVITY, false);
        this.logCutOffLatency = conf.getInt(LOG_SCANNER_LATENCY_CUTOFF, 1000);
    }

    @Override
    public void connect(boolean reload) throws IOException {
        if (!this.instantiated || reload) {
            super.connect(reload);
            this.checkIfRegionServerIsRemote();
            this.instantiated = true;
        }
        if (reload && this.scanMetrics != null) {
            this.scanMetrics.countOfRPCRetries.incrementAndGet();
            if (this.isRegionServerRemote) {
                this.scanMetrics.countOfRemoteRPCRetries.incrementAndGet();
            }
        }
    }

    private void checkIfRegionServerIsRemote() throws UnknownHostException {
        String myAddress = DNS.getDefaultHost((String)"default", (String)"default");
        this.isRegionServerRemote = !this.location.getHostname().equalsIgnoreCase(myAddress);
    }

    @Override
    public Result[] call() throws IOException {
        if (this.closed) {
            if (this.scannerId != -1L) {
                this.close();
            }
        } else if (this.scannerId == -1L) {
            this.scannerId = this.openScanner();
        } else {
            Result[] rrs = null;
            ClientProtos.ScanRequest request = null;
            try {
                this.incRPCcallsMetrics();
                request = RequestConverter.buildScanRequest(this.scannerId, this.caching, false, this.nextCallSeq);
                ClientProtos.ScanResponse response = null;
                try {
                    long now;
                    response = this.server.scan(null, request);
                    ++this.nextCallSeq;
                    long timestamp = System.currentTimeMillis();
                    rrs = ResponseConverter.getResults(response);
                    if (this.logScannerActivity && (now = System.currentTimeMillis()) - timestamp > (long)this.logCutOffLatency) {
                        int rows = rrs == null ? 0 : rrs.length;
                        LOG.info((Object)("Took " + (now - timestamp) + "ms to fetch " + rows + " rows from scanner=" + this.scannerId));
                    }
                    if (response.hasMoreResults() && !response.getMoreResults()) {
                        this.scannerId = -1L;
                        this.closed = true;
                        return null;
                    }
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
                this.updateResultsMetrics(response);
            }
            catch (IOException e) {
                if (this.logScannerActivity) {
                    LOG.info((Object)("Got exception making request " + TextFormat.shortDebugString((Message)request)), (Throwable)e);
                }
                IOException ioe = e;
                if (e instanceof RemoteException) {
                    ioe = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e));
                }
                if (this.logScannerActivity && ioe instanceof UnknownScannerException) {
                    try {
                        HRegionLocation location = this.connection.relocateRegion(this.tableName, this.scan.getStartRow());
                        LOG.info((Object)("Scanner=" + this.scannerId + " expired, current region location is " + location.toString() + " ip:" + location.getHostnamePort()));
                    }
                    catch (Throwable t) {
                        LOG.info((Object)"Failed to relocate region", t);
                    }
                }
                if (ioe instanceof NotServingRegionException) {
                    if (this.scanMetrics != null) {
                        this.scanMetrics.countOfNSRE.incrementAndGet();
                    }
                    throw new DoNotRetryIOException("Reset scanner", ioe);
                }
                if (ioe instanceof RegionServerStoppedException) {
                    throw new DoNotRetryIOException("Reset scanner", ioe);
                }
                throw ioe;
            }
            return rrs;
        }
        return null;
    }

    private void incRPCcallsMetrics() {
        if (this.scanMetrics == null) {
            return;
        }
        this.scanMetrics.countOfRPCcalls.incrementAndGet();
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfRemoteRPCcalls.incrementAndGet();
        }
    }

    private void updateResultsMetrics(ClientProtos.ScanResponse response) {
        if (this.scanMetrics == null || !response.hasResultSizeBytes()) {
            return;
        }
        long value = response.getResultSizeBytes();
        this.scanMetrics.countOfBytesInResults.addAndGet(value);
        if (this.isRegionServerRemote) {
            this.scanMetrics.countOfBytesInRemoteResults.addAndGet(value);
        }
    }

    private void close() {
        if (this.scannerId == -1L) {
            return;
        }
        try {
            this.incRPCcallsMetrics();
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.scannerId, 0, true);
            try {
                this.server.scan(null, request);
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Ignore, probably already closed", (Throwable)e);
        }
        this.scannerId = -1L;
    }

    protected long openScanner() throws IOException {
        this.incRPCcallsMetrics();
        ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.location.getRegionInfo().getRegionName(), this.scan, 0, false);
        try {
            ClientProtos.ScanResponse response = this.server.scan(null, request);
            long id = response.getScannerId();
            if (this.logScannerActivity) {
                LOG.info((Object)("Open scanner=" + id + " for scan=" + this.scan.toString() + " on region " + this.location.toString() + " ip:" + this.location.getHostnamePort()));
            }
            return id;
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    protected Scan getScan() {
        return this.scan;
    }

    public void setClose() {
        this.closed = true;
    }

    public HRegionInfo getHRegionInfo() {
        if (!this.instantiated) {
            return null;
        }
        return this.location.getRegionInfo();
    }

    public int getCaching() {
        return this.caching;
    }

    public void setCaching(int caching) {
        this.caching = caching;
    }
}

