/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ColumnPaginationFilter
extends FilterBase {
    private int limit = 0;
    private int offset = 0;
    private int count = 0;

    public ColumnPaginationFilter(int limit, int offset) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (String)"limit must be positive %s", (Object[])new Object[]{limit});
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"offset must be positive %s", (Object[])new Object[]{offset});
        this.limit = limit;
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.count >= this.offset + this.limit) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        Filter.ReturnCode code = this.count < this.offset ? Filter.ReturnCode.NEXT_COL : Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
        ++this.count;
        return code;
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 2 ? 1 : 0) != 0, (String)"Expected 2 but got: %s", (Object[])new Object[]{filterArguments.size()});
        int limit = ParseFilter.convertByteArrayToInt(filterArguments.get(0));
        int offset = ParseFilter.convertByteArrayToInt(filterArguments.get(1));
        return new ColumnPaginationFilter(limit, offset);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.ColumnPaginationFilter.Builder builder = FilterProtos.ColumnPaginationFilter.newBuilder();
        builder.setLimit(this.limit);
        builder.setOffset(this.offset);
        return builder.build().toByteArray();
    }

    public static ColumnPaginationFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.ColumnPaginationFilter proto;
        try {
            proto = FilterProtos.ColumnPaginationFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new ColumnPaginationFilter(proto.getLimit(), proto.getOffset());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnPaginationFilter)) {
            return false;
        }
        ColumnPaginationFilter other = (ColumnPaginationFilter)o;
        return this.getLimit() == other.getLimit() && this.getOffset() == other.getOffset();
    }

    @Override
    public String toString() {
        return String.format("%s (%d, %d)", this.getClass().getSimpleName(), this.limit, this.offset);
    }
}

