/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.SocketFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.IpcProtocol;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.ProtobufRpcClientEngine;
import org.apache.hadoop.hbase.ipc.ReflectionCache;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.protobuf.generated.Tracing;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.KerberosInfo;
import org.apache.hadoop.hbase.security.TokenInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.cloudera.htrace.Span;
import org.cloudera.htrace.Trace;

@InterfaceAudience.Private
public class HBaseClient {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseClient");
    protected final PoolMap<ConnectionId, Connection> connections;
    private ReflectionCache reflectionCache = new ReflectionCache();
    protected int counter;
    protected final AtomicBoolean running = new AtomicBoolean(true);
    protected final Configuration conf;
    protected final int maxIdleTime;
    protected final int maxRetries;
    protected final long failureSleep;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected int pingInterval;
    protected int socketTimeout;
    protected FailedServers failedServers;
    private final Codec codec;
    private final CompressionCodec compressor;
    private final IPCUtil ipcUtil;
    protected final SocketFactory socketFactory;
    protected String clusterId;
    private static final String PING_INTERVAL_NAME = "ipc.ping.interval";
    private static final String SOCKET_TIMEOUT = "ipc.socket.timeout";
    static final int DEFAULT_PING_INTERVAL = 60000;
    static final int DEFAULT_SOCKET_TIMEOUT = 20000;
    static final int PING_CALL_ID = -1;
    public static final String FAILED_SERVER_EXPIRY_KEY = "hbase.ipc.client.failed.servers.expiry";
    public static final int FAILED_SERVER_EXPIRY_DEFAULT = 2000;
    protected static final Map<String, TokenSelector<? extends TokenIdentifier>> tokenHandlers = new HashMap<String, TokenSelector<? extends TokenIdentifier>>();

    public static void setPingInterval(Configuration conf, int pingInterval) {
        conf.setInt(PING_INTERVAL_NAME, pingInterval);
    }

    static int getPingInterval(Configuration conf) {
        return conf.getInt(PING_INTERVAL_NAME, 60000);
    }

    public static void setSocketTimeout(Configuration conf, int socketTimeout) {
        conf.setInt(SOCKET_TIMEOUT, socketTimeout);
    }

    static int getSocketTimeout(Configuration conf) {
        return conf.getInt(SOCKET_TIMEOUT, 20000);
    }

    protected Connection createConnection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
        return new Connection(remoteId, codec, compressor);
    }

    public HBaseClient(Configuration conf, String clusterId, SocketFactory factory) {
        this.maxIdleTime = conf.getInt("hbase.ipc.client.connection.maxidletime", 10000);
        this.maxRetries = conf.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.failureSleep = conf.getInt("hbase.client.pause", 1000);
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.client.tcpnodelay", true);
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        this.pingInterval = HBaseClient.getPingInterval(conf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Ping interval: " + this.pingInterval + "ms."));
        }
        this.ipcUtil = new IPCUtil(conf);
        this.conf = conf;
        this.codec = HBaseClient.getCodec(conf);
        this.compressor = HBaseClient.getCompressor(conf);
        this.socketFactory = factory;
        this.clusterId = clusterId != null ? clusterId : "default-cluster";
        this.connections = new PoolMap(HBaseClient.getPoolType(conf), HBaseClient.getPoolSize(conf));
        this.failedServers = new FailedServers(conf);
    }

    private static Codec getCodec(Configuration conf) {
        String className = conf.get("hbase.client.rpc.codec", KeyValueCodec.class.getCanonicalName());
        try {
            return (Codec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting codec " + className, e);
        }
    }

    private static CompressionCodec getCompressor(Configuration conf) {
        String className = conf.get("hbase.client.rpc.compressor", null);
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            return (CompressionCodec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting compressor " + className, e);
        }
    }

    public HBaseClient(Configuration conf, String clusterId) {
        this(conf, clusterId, NetUtils.getDefaultSocketFactory((Configuration)conf));
    }

    protected static PoolMap.PoolType getPoolType(Configuration config) {
        return PoolMap.PoolType.valueOf(config.get("hbase.client.ipc.pool.type"), PoolMap.PoolType.RoundRobin, PoolMap.PoolType.ThreadLocal);
    }

    protected static int getPoolSize(Configuration config) {
        return config.getInt("hbase.client.ipc.pool.size", 1);
    }

    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stopping client");
        }
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection conn : this.connections.values()) {
                conn.interrupt();
            }
        }
        while (!this.connections.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Message, CellScanner> call(Method method, Message param, CellScanner cells, InetSocketAddress addr, Class<? extends IpcProtocol> protocol, User ticket, int rpcTimeout) throws InterruptedException, IOException {
        Call call = new Call(method, param, cells);
        Connection connection = this.getConnection(addr, protocol, ticket, rpcTimeout, call, this.codec, this.compressor);
        connection.writeRequest(call);
        boolean interrupted = false;
        Call call2 = call;
        synchronized (call2) {
            while (!call.done) {
                try {
                    call.wait();
                }
                catch (InterruptedException ignored) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            if (call.error != null) {
                if (call.error instanceof RemoteException) {
                    call.error.fillInStackTrace();
                    throw call.error;
                }
                throw this.wrapException(addr, call.error);
            }
            return new Pair((Object)call.response, (Object)call.cells);
        }
    }

    protected IOException wrapException(InetSocketAddress addr, IOException exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed on socket timeout exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelConnections(String hostname, int port, IOException ioe) {
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            for (Connection connection : this.connections.values()) {
                if (!connection.isAlive() || connection.getRemoteAddress().getPort() != port || !connection.getRemoteAddress().getHostName().equals(hostname)) continue;
                LOG.info((Object)("The server on " + hostname + ":" + port + " is dead - stopping the connection " + connection.remoteId));
                connection.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(InetSocketAddress addr, Class<? extends IpcProtocol> protocol, User ticket, int rpcTimeout, Call call, Codec codec, CompressionCodec compressor) throws IOException, InterruptedException {
        Connection connection;
        if (!this.running.get()) {
            throw new IOException("The client is stopped");
        }
        ConnectionId remoteId = new ConnectionId(addr, protocol, ticket, rpcTimeout);
        PoolMap<ConnectionId, Connection> poolMap = this.connections;
        synchronized (poolMap) {
            connection = this.connections.get(remoteId);
            if (connection == null) {
                connection = this.createConnection(remoteId, this.codec, this.compressor);
                this.connections.put(remoteId, connection);
            }
        }
        connection.addCall(call);
        connection.setupIOstreams();
        return connection;
    }

    static {
        tokenHandlers.put(AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE.toString(), new AuthenticationTokenSelector());
    }

    protected static class ConnectionId {
        final InetSocketAddress address;
        final User ticket;
        final int rpcTimeout;
        Class<? extends IpcProtocol> protocol;
        private static final int PRIME = 16777619;

        ConnectionId(InetSocketAddress address, Class<? extends IpcProtocol> protocol, User ticket, int rpcTimeout) {
            this.protocol = protocol;
            this.address = address;
            this.ticket = ticket;
            this.rpcTimeout = rpcTimeout;
        }

        InetSocketAddress getAddress() {
            return this.address;
        }

        Class<? extends IpcProtocol> getProtocol() {
            return this.protocol;
        }

        User getTicket() {
            return this.ticket;
        }

        public String toString() {
            return this.address.toString() + "/" + this.protocol + "/" + this.ticket + "/" + this.rpcTimeout;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionId) {
                ConnectionId id = (ConnectionId)obj;
                return this.address.equals(id.address) && this.protocol == id.protocol && (this.ticket != null && this.ticket.equals(id.ticket) || this.ticket == id.ticket) && this.rpcTimeout == id.rpcTimeout;
            }
            return false;
        }

        public int hashCode() {
            int hashcode = this.address.hashCode() + 16777619 * (16777619 * System.identityHashCode(this.protocol) ^ (this.ticket == null ? 0 : this.ticket.hashCode())) ^ this.rpcTimeout;
            return hashcode;
        }
    }

    public static class CallTimeoutException
    extends IOException {
        public CallTimeoutException(String msg) {
            super(msg);
        }
    }

    protected class Connection
    extends Thread {
        private RPCProtos.ConnectionHeader header;
        protected ConnectionId remoteId;
        protected Socket socket = null;
        protected DataInputStream in;
        protected DataOutputStream out;
        private InetSocketAddress server;
        private String serverPrincipal;
        private AuthMethod authMethod;
        private boolean useSasl;
        private Token<? extends TokenIdentifier> token;
        private HBaseSaslRpcClient saslRpcClient;
        private int reloginMaxBackoff;
        private final Codec codec;
        private final CompressionCodec compressor;
        protected final ConcurrentSkipListMap<Integer, Call> calls = new ConcurrentSkipListMap();
        protected final AtomicLong lastActivity = new AtomicLong();
        protected final AtomicBoolean shouldCloseConnection = new AtomicBoolean();
        protected IOException closeException;

        Connection(ConnectionId remoteId, Codec codec, CompressionCodec compressor) throws IOException {
            if (remoteId.getAddress().isUnresolved()) {
                throw new UnknownHostException("unknown host: " + remoteId.getAddress().getHostName());
            }
            this.server = remoteId.getAddress();
            this.codec = codec;
            this.compressor = compressor;
            UserGroupInformation ticket = remoteId.getTicket().getUGI();
            Class<? extends IpcProtocol> protocol = remoteId.getProtocol();
            this.useSasl = User.isHBaseSecurityEnabled(HBaseClient.this.conf);
            if (this.useSasl && protocol != null) {
                KerberosInfo krbInfo;
                TokenInfo tokenInfo = protocol.getAnnotation(TokenInfo.class);
                if (tokenInfo != null) {
                    TokenSelector<? extends TokenIdentifier> tokenSelector = tokenHandlers.get(tokenInfo.value());
                    if (tokenSelector != null) {
                        this.token = tokenSelector.selectToken(new Text(HBaseClient.this.clusterId), ticket.getTokens());
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("No token selector found for type " + tokenInfo.value()));
                    }
                }
                if ((krbInfo = protocol.getAnnotation(KerberosInfo.class)) != null) {
                    String serverKey = krbInfo.serverPrincipal();
                    if (serverKey == null) {
                        throw new IOException("Can't obtain server Kerberos config key from KerberosInfo");
                    }
                    this.serverPrincipal = SecurityUtil.getServerPrincipal((String)HBaseClient.this.conf.get(serverKey), (String)this.server.getAddress().getCanonicalHostName().toLowerCase());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RPC Server Kerberos principal name for protocol=" + protocol.getCanonicalName() + " is " + this.serverPrincipal));
                    }
                }
            }
            this.authMethod = !this.useSasl ? AuthMethod.SIMPLE : (this.token != null ? AuthMethod.DIGEST : AuthMethod.KERBEROS);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Use " + (Object)((Object)this.authMethod) + " authentication for protocol " + protocol.getSimpleName()));
            }
            this.reloginMaxBackoff = HBaseClient.this.conf.getInt("hbase.security.relogin.maxbackoff", 5000);
            this.remoteId = remoteId;
            RPCProtos.ConnectionHeader.Builder builder = RPCProtos.ConnectionHeader.newBuilder();
            builder.setProtocol(protocol == null ? "" : protocol.getName());
            RPCProtos.UserInformation userInfoPB = this.getUserInfo(ticket);
            if (userInfoPB != null) {
                builder.setUserInfo(userInfoPB);
            }
            builder.setCellBlockCodecClass(this.codec.getClass().getCanonicalName());
            if (this.compressor != null) {
                builder.setCellBlockCompressorClass(this.compressor.getClass().getCanonicalName());
            }
            this.header = builder.build();
            this.setName("IPC Client (" + HBaseClient.this.socketFactory.hashCode() + ") connection to " + remoteId.getAddress().toString() + (ticket == null ? " from an unknown user" : " from " + ticket.getUserName()));
            this.setDaemon(true);
        }

        private RPCProtos.UserInformation getUserInfo(UserGroupInformation ugi) {
            if (ugi == null || this.authMethod == AuthMethod.DIGEST) {
                return null;
            }
            RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
            if (this.authMethod == AuthMethod.KERBEROS) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
            } else if (this.authMethod == AuthMethod.SIMPLE) {
                userInfoPB.setEffectiveUser(ugi.getUserName());
                if (ugi.getRealUser() != null) {
                    userInfoPB.setRealUser(ugi.getRealUser().getUserName());
                }
            }
            return userInfoPB.build();
        }

        protected void touch() {
            this.lastActivity.set(System.currentTimeMillis());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void addCall(Call call) {
            if (this.shouldCloseConnection.get()) {
                if (this.closeException == null) {
                    call.setException(new IOException("Call " + call.id + " not added as the connection " + this.remoteId + " is closing"));
                } else {
                    call.setException(this.closeException);
                }
                Call call2 = call;
                synchronized (call2) {
                    call.notifyAll();
                }
            } else {
                this.calls.put(call.id, call);
                this.notify();
            }
        }

        protected synchronized void setupConnection() throws IOException {
            int ioFailures = 0;
            int timeoutFailures = 0;
            while (true) {
                try {
                    this.socket = HBaseClient.this.socketFactory.createSocket();
                    this.socket.setTcpNoDelay(HBaseClient.this.tcpNoDelay);
                    this.socket.setKeepAlive(HBaseClient.this.tcpKeepAlive);
                    NetUtils.connect((Socket)this.socket, (SocketAddress)this.remoteId.getAddress(), (int)HBaseClient.getSocketTimeout(HBaseClient.this.conf));
                    if (this.remoteId.rpcTimeout > 0) {
                        HBaseClient.this.pingInterval = this.remoteId.rpcTimeout;
                    }
                    this.socket.setSoTimeout(HBaseClient.this.pingInterval);
                    return;
                }
                catch (SocketTimeoutException toe) {
                    int n = timeoutFailures;
                    timeoutFailures = (short)(timeoutFailures + 1);
                    this.handleConnectionFailure(n, HBaseClient.this.maxRetries, toe);
                    continue;
                }
                catch (IOException ie) {
                    int n = ioFailures;
                    ioFailures = (short)(ioFailures + 1);
                    this.handleConnectionFailure(n, HBaseClient.this.maxRetries, ie);
                    continue;
                }
                break;
            }
        }

        protected void closeConnection() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Not able to close a socket", (Throwable)e);
                }
            }
            this.socket = null;
        }

        private void handleConnectionFailure(int curRetries, int maxRetries, IOException ioe) throws IOException {
            this.closeConnection();
            if (curRetries >= maxRetries) {
                throw ioe;
            }
            try {
                Thread.sleep(HBaseClient.this.failureSleep);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            LOG.info((Object)("Retrying connect to server: " + this.remoteId.getAddress() + " after sleeping " + HBaseClient.this.failureSleep + "ms. Already tried " + curRetries + " time(s)."));
        }

        protected synchronized boolean waitForWork() {
            long timeout;
            if (this.calls.isEmpty() && !this.shouldCloseConnection.get() && HBaseClient.this.running.get() && (timeout = (long)HBaseClient.this.maxIdleTime - (System.currentTimeMillis() - this.lastActivity.get())) > 0L) {
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!this.calls.isEmpty() && !this.shouldCloseConnection.get() && HBaseClient.this.running.get()) {
                return true;
            }
            if (this.shouldCloseConnection.get()) {
                return false;
            }
            if (this.calls.isEmpty()) {
                this.markClosed(null);
                return false;
            }
            this.markClosed((IOException)new IOException().initCause(new InterruptedException()));
            return false;
        }

        public InetSocketAddress getRemoteAddress() {
            return this.remoteId.getAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void sendPing() throws IOException {
            long curTime = System.currentTimeMillis();
            if (curTime - this.lastActivity.get() >= (long)HBaseClient.this.pingInterval) {
                this.lastActivity.set(curTime);
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    this.out.writeInt(-1);
                    this.out.flush();
                }
            }
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": starting, connections " + HBaseClient.this.connections.size()));
            }
            try {
                while (this.waitForWork()) {
                    this.readResponse();
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)(this.getName() + ": unexpected exception receiving call responses"), t);
                this.markClosed(new IOException("Unexpected exception receiving call responses", t));
            }
            this.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": stopped, connections " + HBaseClient.this.connections.size()));
            }
        }

        private synchronized void disposeSasl() {
            if (this.saslRpcClient != null) {
                try {
                    this.saslRpcClient.dispose();
                    this.saslRpcClient = null;
                }
                catch (IOException ioe) {
                    LOG.error((Object)"Error disposing of SASL client", (Throwable)ioe);
                }
            }
        }

        private synchronized boolean shouldAuthenticateOverKrb() throws IOException {
            UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            UserGroupInformation realUser = currentUser.getRealUser();
            return this.authMethod == AuthMethod.KERBEROS && loginUser != null && loginUser.hasKerberosCredentials() && (loginUser.equals((Object)currentUser) || loginUser.equals((Object)realUser));
        }

        private synchronized boolean setupSaslConnection(InputStream in2, OutputStream out2) throws IOException {
            this.saslRpcClient = new HBaseSaslRpcClient(this.authMethod, this.token, this.serverPrincipal);
            return this.saslRpcClient.saslConnect(in2, out2);
        }

        private synchronized void handleSaslConnectionFailure(final int currRetries, final int maxRetries, final Exception ex, final Random rand, UserGroupInformation user) throws IOException, InterruptedException {
            user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException, InterruptedException {
                    Connection.this.closeConnection();
                    if (Connection.this.shouldAuthenticateOverKrb()) {
                        if (currRetries < maxRetries) {
                            LOG.debug((Object)("Exception encountered while connecting to the server : " + ex));
                            if (UserGroupInformation.isLoginKeytabBased()) {
                                UserGroupInformation.getLoginUser().reloginFromKeytab();
                            } else {
                                UserGroupInformation.getLoginUser().reloginFromTicketCache();
                            }
                            Connection.this.disposeSasl();
                            Thread.sleep(rand.nextInt(Connection.this.reloginMaxBackoff) + 1);
                            return null;
                        }
                        String msg = "Couldn't setup connection for " + UserGroupInformation.getLoginUser().getUserName() + " to " + Connection.this.serverPrincipal;
                        LOG.warn((Object)msg);
                        throw (IOException)new IOException(msg).initCause(ex);
                    }
                    LOG.warn((Object)("Exception encountered while connecting to the server : " + ex));
                    if (ex instanceof RemoteException) {
                        throw (RemoteException)((Object)ex);
                    }
                    if (ex instanceof SaslException) {
                        String msg = "SASL authentication failed. The most likely cause is missing or invalid credentials. Consider 'kinit'.";
                        LOG.fatal((Object)msg, (Throwable)ex);
                        throw new RuntimeException(msg, ex);
                    }
                    throw new IOException(ex);
                }
            });
        }

        protected synchronized void setupIOstreams() throws IOException, InterruptedException {
            if (this.socket != null || this.shouldCloseConnection.get()) {
                return;
            }
            if (HBaseClient.this.failedServers.isFailedServer(this.remoteId.getAddress())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Not trying to connect to " + this.server + " this server is in the failed servers list"));
                }
                FailedServerException e = new FailedServerException("This server is in the failed servers list: " + this.server);
                this.markClosed(e);
                this.close();
                throw e;
            }
            try {
                OutputStream outStream;
                InputStream inStream;
                block16: {
                    boolean continueSasl;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connecting to " + this.server));
                    }
                    int numRetries = 0;
                    int MAX_RETRIES = 5;
                    Random rand = null;
                    while (true) {
                        this.setupConnection();
                        inStream = NetUtils.getInputStream((Socket)this.socket);
                        outStream = NetUtils.getOutputStream((Socket)this.socket);
                        this.writeConnectionHeaderPreamble(outStream);
                        if (!this.useSasl) break block16;
                        final InputStream in2 = inStream;
                        final OutputStream out2 = outStream;
                        UserGroupInformation ticket = this.remoteId.getTicket().getUGI();
                        if (this.authMethod == AuthMethod.KERBEROS && ticket != null && ticket.getRealUser() != null) {
                            ticket = ticket.getRealUser();
                        }
                        continueSasl = false;
                        try {
                            if (ticket == null) {
                                throw new NullPointerException("ticket is null");
                            }
                            continueSasl = (Boolean)ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                                @Override
                                public Boolean run() throws IOException {
                                    return Connection.this.setupSaslConnection(in2, out2);
                                }
                            });
                        }
                        catch (Exception ex) {
                            if (rand == null) {
                                rand = new Random();
                            }
                            int n = numRetries;
                            numRetries = (short)(numRetries + 1);
                            this.handleSaslConnectionFailure(n, 5, ex, rand, ticket);
                            continue;
                        }
                        break;
                    }
                    if (continueSasl) {
                        inStream = this.saslRpcClient.getInputStream(inStream);
                        outStream = this.saslRpcClient.getOutputStream(outStream);
                    } else {
                        this.authMethod = AuthMethod.SIMPLE;
                        this.useSasl = false;
                    }
                }
                this.in = new DataInputStream(new BufferedInputStream(new PingInputStream(inStream)));
                this.out = new DataOutputStream(new BufferedOutputStream(outStream));
                this.writeConnectionHeader();
                this.touch();
                this.start();
                return;
            }
            catch (Throwable t) {
                HBaseClient.this.failedServers.addToFailedServers(this.remoteId.address);
                IOException e = null;
                if (t instanceof IOException) {
                    e = (IOException)t;
                    this.markClosed(e);
                } else {
                    e = new IOException("Coundn't set up IO Streams", t);
                    this.markClosed(e);
                }
                this.close();
                throw e;
            }
        }

        private void writeConnectionHeaderPreamble(OutputStream outStream) throws IOException {
            int rpcHeaderLen = HConstants.RPC_HEADER.array().length;
            byte[] preamble = new byte[rpcHeaderLen + 2];
            System.arraycopy(HConstants.RPC_HEADER.array(), 0, preamble, 0, rpcHeaderLen);
            preamble[rpcHeaderLen] = 0;
            preamble[rpcHeaderLen + 1] = this.authMethod.code;
            outStream.write(preamble);
            outStream.flush();
        }

        private void writeConnectionHeader() throws IOException {
            this.out.writeInt(this.header.getSerializedSize());
            this.header.writeTo((OutputStream)this.out);
            this.out.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void close() {
            if (!this.shouldCloseConnection.get()) {
                LOG.error((Object)(this.getName() + ": the connection is not in the closed state"));
                return;
            }
            PoolMap<ConnectionId, Connection> poolMap = HBaseClient.this.connections;
            synchronized (poolMap) {
                if (HBaseClient.this.connections.get(this.remoteId) == this) {
                    HBaseClient.this.connections.remove(this.remoteId);
                }
            }
            IOUtils.closeStream((Closeable)this.out);
            IOUtils.closeStream((Closeable)this.in);
            this.disposeSasl();
            if (this.closeException == null) {
                if (!this.calls.isEmpty()) {
                    LOG.warn((Object)(this.getName() + ": connection is closed for no cause and calls are not empty. " + "#Calls: " + this.calls.size()));
                    this.closeException = new IOException("Unexpected closed connection");
                    this.cleanupCalls();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": closing ipc connection to " + this.server + ": " + this.closeException.getMessage()), (Throwable)this.closeException);
                }
                this.cleanupCalls();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getName() + ": closed"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeRequest(Call call) {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            try {
                RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
                builder.setCallId(call.id);
                if (Trace.isTracing()) {
                    Span s = Trace.currentTrace();
                    builder.setTraceInfo(Tracing.RPCTInfo.newBuilder().setParentId(s.getSpanId()).setTraceId(s.getTraceId()));
                }
                builder.setMethodName(call.method.getName());
                builder.setRequestParam(call.param != null);
                ByteBuffer cellBlock = HBaseClient.this.ipcUtil.buildCellBlock(this.codec, this.compressor, call.cells);
                if (cellBlock != null) {
                    RPCProtos.CellBlockMeta.Builder cellBlockBuilder = RPCProtos.CellBlockMeta.newBuilder();
                    cellBlockBuilder.setLength(cellBlock.limit());
                    builder.setCellBlockMeta(cellBlockBuilder.build());
                }
                RPCProtos.RequestHeader header = builder.build();
                DataOutputStream dataOutputStream = this.out;
                synchronized (dataOutputStream) {
                    IPCUtil.write(this.out, (Message)header, call.param, cellBlock);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": wrote request header " + TextFormat.shortDebugString((Message)header)));
                }
            }
            catch (IOException e) {
                this.markClosed(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readResponse() {
            if (this.shouldCloseConnection.get()) {
                return;
            }
            this.touch();
            try {
                this.in.readInt();
                RPCProtos.ResponseHeader responseHeader = RPCProtos.ResponseHeader.parseDelimitedFrom((InputStream)this.in);
                int id = responseHeader.getCallId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.getName() + ": got response header " + TextFormat.shortDebugString((Message)responseHeader)));
                }
                Call call = this.calls.get(id);
                if (responseHeader.hasException()) {
                    RPCProtos.ExceptionResponse exceptionResponse = responseHeader.getException();
                    RemoteException re = this.createRemoteException(exceptionResponse);
                    if (this.isFatalConnectionException(exceptionResponse)) {
                        this.markClosed((IOException)((Object)re));
                    } else if (call != null) {
                        call.setException((IOException)((Object)re));
                    }
                } else {
                    Message rpcResponseType;
                    try {
                        rpcResponseType = ProtobufRpcClientEngine.Invoker.getReturnProtoType(HBaseClient.this.reflectionCache.getMethod(this.remoteId.getProtocol(), call.method.getName()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    Message value = null;
                    if (rpcResponseType != null) {
                        Message.Builder builder = rpcResponseType.newBuilderForType();
                        builder.mergeDelimitedFrom((InputStream)this.in);
                        value = builder.build();
                    }
                    CellScanner cellBlockScanner = null;
                    if (responseHeader.hasCellBlockMeta()) {
                        int size = responseHeader.getCellBlockMeta().getLength();
                        byte[] cellBlock = new byte[size];
                        IOUtils.readFully((InputStream)this.in, (byte[])cellBlock, (int)0, (int)cellBlock.length);
                        cellBlockScanner = HBaseClient.this.ipcUtil.createCellScanner(this.codec, this.compressor, cellBlock);
                    }
                    if (call != null) {
                        call.setResponse(value, cellBlockScanner);
                    }
                }
                if (call != null) {
                    this.calls.remove(id);
                }
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException && this.remoteId.rpcTimeout > 0) {
                    this.closeException = e;
                } else {
                    this.markClosed(e);
                }
            }
            finally {
                if (this.remoteId.rpcTimeout > 0) {
                    this.cleanupCalls(this.remoteId.rpcTimeout);
                }
            }
        }

        private boolean isFatalConnectionException(RPCProtos.ExceptionResponse e) {
            return e.getExceptionClassName().equals(FatalConnectionException.class.getName());
        }

        private RemoteException createRemoteException(RPCProtos.ExceptionResponse e) {
            String innerExceptionClassName = e.getExceptionClassName();
            boolean doNotRetry = e.getDoNotRetry();
            return e.hasHostname() ? new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), e.getHostname(), e.getPort(), doNotRetry) : new RemoteWithExtrasException(innerExceptionClassName, e.getStackTrace(), doNotRetry);
        }

        protected synchronized void markClosed(IOException e) {
            if (this.shouldCloseConnection.compareAndSet(false, true)) {
                this.closeException = e;
                this.notifyAll();
            }
        }

        protected void cleanupCalls() {
            this.cleanupCalls(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanupCalls(long rpcTimeout) {
            Iterator<Map.Entry<Integer, Call>> itor = this.calls.entrySet().iterator();
            while (itor.hasNext()) {
                Call c = itor.next().getValue();
                long waitTime = System.currentTimeMillis() - c.getStartTime();
                if (waitTime < rpcTimeout) break;
                if (this.closeException == null) {
                    this.closeException = new CallTimeoutException("Call id=" + c.id + ", waitTime=" + waitTime + ", rpcTimetout=" + rpcTimeout);
                }
                c.setException(this.closeException);
                Call call = c;
                synchronized (call) {
                    c.notifyAll();
                }
                itor.remove();
            }
            try {
                if (!this.calls.isEmpty()) {
                    Call firstCall = this.calls.get(this.calls.firstKey());
                    long maxWaitTime = System.currentTimeMillis() - firstCall.getStartTime();
                    if (maxWaitTime < rpcTimeout) {
                        rpcTimeout -= maxWaitTime;
                    }
                }
                if (!this.shouldCloseConnection.get()) {
                    this.closeException = null;
                    if (this.socket != null) {
                        this.socket.setSoTimeout((int)rpcTimeout);
                    }
                }
            }
            catch (SocketException e) {
                LOG.debug((Object)"Couldn't lower timeout, which may result in longer than expected calls");
            }
        }

        protected class PingInputStream
        extends FilterInputStream {
            protected PingInputStream(InputStream in) {
                super(in);
            }

            private void handleTimeout(SocketTimeoutException e) throws IOException {
                if (Connection.this.shouldCloseConnection.get() || !HBaseClient.this.running.get() || Connection.this.remoteId.rpcTimeout > 0) {
                    throw e;
                }
                Connection.this.sendPing();
            }

            @Override
            public int read() throws IOException {
                while (true) {
                    try {
                        return super.read();
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                while (true) {
                    try {
                        return super.read(buf, off, len);
                    }
                    catch (SocketTimeoutException e) {
                        this.handleTimeout(e);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected class Call {
        final int id;
        final Message param;
        CellScanner cells;
        Message response;
        IOException error;
        boolean done;
        long startTime;
        final Method method;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Call(Method method, Message param, CellScanner cells) {
            this.param = param;
            this.method = method;
            this.cells = cells;
            this.startTime = System.currentTimeMillis();
            HBaseClient hBaseClient2 = HBaseClient.this;
            synchronized (hBaseClient2) {
                this.id = HBaseClient.this.counter++;
            }
        }

        public String toString() {
            return "callId: " + this.id + " methodName: " + this.method.getName() + " param {" + (this.param != null ? TextFormat.shortDebugString((Message)this.param) : "") + "}";
        }

        protected synchronized void callComplete() {
            this.done = true;
            this.notify();
        }

        public synchronized void setException(IOException error) {
            this.error = error;
            this.callComplete();
        }

        public synchronized void setResponse(Message response, CellScanner cells) {
            this.response = response;
            this.cells = cells;
            this.callComplete();
        }

        public long getStartTime() {
            return this.startTime;
        }
    }

    public static class FailedServerException
    extends IOException {
        public FailedServerException(String s) {
            super(s);
        }
    }

    static class FailedServers {
        private final LinkedList<Pair<Long, String>> failedServers = new LinkedList();
        private final int recheckServersTimeout;

        FailedServers(Configuration conf) {
            this.recheckServersTimeout = conf.getInt(HBaseClient.FAILED_SERVER_EXPIRY_KEY, 2000);
        }

        public synchronized void addToFailedServers(InetSocketAddress address) {
            long expiry = EnvironmentEdgeManager.currentTimeMillis() + (long)this.recheckServersTimeout;
            this.failedServers.addFirst((Pair<Long, String>)new Pair((Object)expiry, (Object)address.toString()));
        }

        public synchronized boolean isFailedServer(InetSocketAddress address) {
            if (this.failedServers.isEmpty()) {
                return false;
            }
            String lookup = address.toString();
            long now = EnvironmentEdgeManager.currentTimeMillis();
            Iterator it = this.failedServers.iterator();
            while (it.hasNext()) {
                Pair cur = (Pair)it.next();
                if ((Long)cur.getFirst() < now) {
                    it.remove();
                    continue;
                }
                if (!lookup.equals(cur.getSecond())) continue;
                return true;
            }
            return false;
        }
    }
}

