/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.IpcProtocol;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.ipc.RpcClientEngine;

@InterfaceAudience.Private
public class HBaseClientRPC {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.ipc.HBaseClientRPC");
    private static ThreadLocal<Integer> rpcTimeout = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return Integer.MAX_VALUE;
        }
    };

    public static <T extends IpcProtocol> T waitForProxy(RpcClientEngine engine, Class<T> protocol, InetSocketAddress addr, Configuration conf, int maxAttempts, int rpcTimeout, long timeout) throws IOException {
        long startTime = System.currentTimeMillis();
        int reconnectAttempts = 0;
        while (true) {
            IOException ioe;
            block7: {
                try {
                    return engine.getProxy(protocol, addr, conf, rpcTimeout);
                }
                catch (SocketTimeoutException te) {
                    LOG.info((Object)("Problem connecting to server: " + addr));
                    ioe = te;
                }
                catch (IOException ioex) {
                    ConnectException ce = null;
                    ioe = ioex instanceof ConnectException ? (ce = (ConnectException)ioex) : (ioex.getCause() != null && ioex.getCause() instanceof ConnectException ? (ce = (ConnectException)ioex.getCause()) : (ioex.getMessage().toLowerCase().contains("connection refused") ? (ce = new ConnectException(ioex.getMessage())) : ioex));
                    if (ce == null) break block7;
                    HBaseClientRPC.handleConnectionException(++reconnectAttempts, maxAttempts, protocol, addr, ce);
                }
            }
            if (System.currentTimeMillis() - timeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                Thread.interrupted();
                throw new InterruptedIOException();
            }
        }
    }

    private static void handleConnectionException(int retries, int maxAttmpts, Class<?> protocol, InetSocketAddress addr, ConnectException ce) throws RetriesExhaustedException {
        if (maxAttmpts >= 0 && retries >= maxAttmpts) {
            LOG.info((Object)("Server at " + addr + " could not be reached after " + maxAttmpts + " tries, giving up."));
            throw new RetriesExhaustedException("Failed setting up proxy " + protocol + " to " + addr.toString() + " after attempts=" + maxAttmpts, ce);
        }
    }

    public static void setRpcTimeout(int t) {
        rpcTimeout.set(t);
    }

    public static int getRpcTimeout() {
        return rpcTimeout.get();
    }

    public static void resetRpcTimeout() {
        rpcTimeout.remove();
    }
}

