/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.IpcProtocol;
import org.apache.hadoop.hbase.ipc.HBaseClient;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcClientEngine;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.ipc.RemoteException;

public class ProtobufRpcClientEngine
implements RpcClientEngine {
    private static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hbase.ipc.ProtobufRpcClientEngine");
    protected HBaseClient client;

    @Override
    public HBaseClient getClient() {
        return this.client;
    }

    public ProtobufRpcClientEngine(Configuration conf, String clusterId) {
        this.client = new HBaseClient(conf, clusterId);
    }

    @Override
    public <T extends IpcProtocol> T getProxy(Class<T> protocol, InetSocketAddress addr, Configuration conf, int rpcTimeout) throws IOException {
        Invoker invoker = new Invoker(protocol, addr, User.getCurrent(), rpcTimeout, this.client);
        return (T)((IpcProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)invoker));
    }

    @Override
    public void close() {
        this.client.stop();
    }

    static class Invoker
    implements InvocationHandler {
        private static final Map<String, Message> returnTypes = new ConcurrentHashMap<String, Message>();
        private Class<? extends IpcProtocol> protocol;
        private InetSocketAddress address;
        private User ticket;
        private HBaseClient client;
        private final int rpcTimeout;

        public Invoker(Class<? extends IpcProtocol> protocol, InetSocketAddress addr, User ticket, int rpcTimeout, HBaseClient client) throws IOException {
            this.protocol = protocol;
            this.address = addr;
            this.ticket = ticket;
            this.client = client;
            this.rpcTimeout = rpcTimeout;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ServiceException {
            long startTime = 0L;
            if (LOG.isTraceEnabled()) {
                startTime = System.currentTimeMillis();
            }
            if (args.length != 2) {
                throw new ServiceException(method.getName() + " didn't get two args: " + args.length);
            }
            PayloadCarryingRpcController controller = (PayloadCarryingRpcController)args[0];
            CellScanner cells = null;
            if (controller != null) {
                cells = controller.cellScanner();
                controller.setCellScanner(null);
            }
            Message param = (Message)args[1];
            Pair<Message, CellScanner> val = null;
            try {
                val = this.client.call(method, param, cells, this.address, this.protocol, this.ticket, this.rpcTimeout);
                if (controller != null) {
                    if (val.getSecond() != null) {
                        controller.setCellScanner((CellScanner)val.getSecond());
                    }
                } else if (val.getSecond() != null) {
                    throw new ServiceException("Client dropping data on the floor!");
                }
                if (LOG.isTraceEnabled()) {
                    long callTime = System.currentTimeMillis() - startTime;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Call: " + method.getName() + " " + callTime));
                    }
                }
                return val.getFirst();
            }
            catch (Throwable e) {
                if (e instanceof RemoteException) {
                    IOException cause = ((RemoteException)e).unwrapRemoteException();
                    throw new ServiceException("methodName=" + method.getName(), (Throwable)cause);
                }
                throw new ServiceException(e);
            }
        }

        static Message getReturnProtoType(Method method) throws Exception {
            if (returnTypes.containsKey(method.getName())) {
                return returnTypes.get(method.getName());
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.getName().equals("void")) {
                return null;
            }
            Method newInstMethod = returnType.getMethod("getDefaultInstance", new Class[0]);
            newInstMethod.setAccessible(true);
            Message protoType = (Message)newInstMethod.invoke(null, (Object[])null);
            returnTypes.put(method.getName(), protoType);
            return protoType;
        }
    }
}

