/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Message;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hbase.IpcProtocol;

class ReflectionCache {
    private final Map<String, Message> methodArgCache = new ConcurrentHashMap<String, Message>();
    private final Map<String, Method> methodInstanceCache = new ConcurrentHashMap<String, Method>();

    Method getMethod(Class<? extends IpcProtocol> protocol, String methodName) {
        Method[] methods;
        Method method = this.methodInstanceCache.get(methodName);
        if (method != null) {
            return method;
        }
        for (Method m : methods = protocol.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            m.setAccessible(true);
            this.methodInstanceCache.put(methodName, m);
            return m;
        }
        return null;
    }

    Message getMethodArgType(Method method) throws Exception {
        Class<?> arg;
        Message protoType = this.methodArgCache.get(method.getName());
        if (protoType != null) {
            return protoType;
        }
        Class<?>[] args = method.getParameterTypes();
        if (args.length == 2) {
            arg = args[1];
        } else if (args.length == 1) {
            arg = args[0];
        } else {
            return null;
        }
        Method newInstMethod = arg.getMethod("getDefaultInstance", new Class[0]);
        newInstMethod.setAccessible(true);
        protoType = (Message)newInstMethod.invoke(null, (Object[])null);
        this.methodArgCache.put(method.getName(), protoType);
        return protoType;
    }
}

