/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationStateInterface;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

public class ReplicationStateImpl
implements ReplicationStateInterface {
    private ReplicationStateTracker stateTracker;
    private final String stateZnode;
    private final ZooKeeperWatcher zookeeper;
    private final Abortable abortable;
    private final AtomicBoolean replicating;
    private static final Log LOG = LogFactory.getLog(ReplicationStateImpl.class);

    public ReplicationStateImpl(ZooKeeperWatcher zk, String stateZnode, Abortable abortable, AtomicBoolean replicating) {
        this.zookeeper = zk;
        this.stateZnode = stateZnode;
        this.abortable = abortable;
        this.replicating = replicating;
        this.stateTracker = new ReplicationStateTracker(this.zookeeper, this.stateZnode, this.abortable);
        this.stateTracker.start();
        this.readReplicationStateZnode();
    }

    @Override
    public boolean getState() throws KeeperException {
        return this.getReplication();
    }

    @Override
    public void setState(boolean newState) throws KeeperException {
        this.setReplicating(newState);
    }

    @Override
    public void close() throws IOException {
        if (this.stateTracker != null) {
            this.stateTracker.stop();
        }
    }

    private boolean isStateEnabled(byte[] bytes) throws DeserializationException {
        ZooKeeperProtos.ReplicationState.State state = this.parseStateFrom(bytes);
        return ZooKeeperProtos.ReplicationState.State.ENABLED == state;
    }

    private ZooKeeperProtos.ReplicationState.State parseStateFrom(byte[] bytes) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(bytes);
        int pblen = ProtobufUtil.lengthOfPBMagic();
        ZooKeeperProtos.ReplicationState.Builder builder = ZooKeeperProtos.ReplicationState.newBuilder();
        try {
            ZooKeeperProtos.ReplicationState state = ((ZooKeeperProtos.ReplicationState.Builder)builder.mergeFrom(bytes, pblen, bytes.length - pblen)).build();
            return state.getState();
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
    }

    private void setReplicating(boolean newState) throws KeeperException {
        ZKUtil.createWithParents(this.zookeeper, this.stateZnode);
        byte[] stateBytes = newState ? ReplicationZookeeper.ENABLED_ZNODE_BYTES : ReplicationZookeeper.DISABLED_ZNODE_BYTES;
        ZKUtil.setData(this.zookeeper, this.stateZnode, stateBytes);
    }

    private boolean getReplication() throws KeeperException {
        byte[] data = this.stateTracker.getData(false);
        if (data == null || data.length == 0) {
            this.setReplicating(true);
            return true;
        }
        try {
            return this.isStateEnabled(data);
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    private void readReplicationStateZnode() {
        try {
            this.replicating.set(this.getReplication());
            LOG.info((Object)("Replication is now " + (this.replicating.get() ? "started" : "stopped")));
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed getting data on from " + this.stateZnode, e);
        }
    }

    private class ReplicationStateTracker
    extends ZooKeeperNodeTracker {
        public ReplicationStateTracker(ZooKeeperWatcher watcher, String stateZnode, Abortable abortable) {
            super(watcher, stateZnode, abortable);
        }

        @Override
        public synchronized void nodeDataChanged(String path) {
            if (path.equals(this.node)) {
                super.nodeDataChanged(path);
                ReplicationStateImpl.this.readReplicationStateZnode();
            }
        }
    }
}

