/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClientSnapshotDescriptionUtils {
    public static void assertSnapshotRequestIsValid(HBaseProtos.SnapshotDescription snapshot) throws IllegalArgumentException {
        if (HTableDescriptor.isMetaTable(Bytes.toBytes((String)snapshot.getTable()))) {
            throw new IllegalArgumentException(".META. and -ROOT- snapshots are not allowed");
        }
        HTableDescriptor.isLegalTableName(Bytes.toBytes((String)snapshot.getName()));
        HTableDescriptor.isLegalTableName(Bytes.toBytes((String)snapshot.getTable()));
    }

    public static String toString(HBaseProtos.SnapshotDescription ssd) {
        if (ssd == null) {
            return null;
        }
        return "{ ss=" + ssd.getName() + " table=" + ssd.getTable() + " type=" + ssd.getType() + " }";
    }
}

