/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RegionCoprocessorRpcChannel
extends CoprocessorRpcChannel {
    private static Log LOG = LogFactory.getLog(RegionCoprocessorRpcChannel.class);
    private final HConnection connection;
    private final TableName table;
    private final byte[] row;
    private byte[] lastRegion;
    private RpcRetryingCallerFactory rpcFactory;

    public RegionCoprocessorRpcChannel(HConnection conn, TableName table, byte[] row) {
        this.connection = conn;
        this.table = table;
        this.row = row;
        this.rpcFactory = RpcRetryingCallerFactory.instantiate(conn.getConfiguration());
    }

    @Override
    protected Message callExecService(Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call: " + method.getName() + ", " + request.toString()));
        }
        if (this.row == null) {
            throw new IllegalArgumentException("Missing row property for remote region location");
        }
        final ClientProtos.CoprocessorServiceCall call = ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteString.copyFrom((byte[])this.row)).setServiceName(method.getService().getFullName()).setMethodName(method.getName()).setRequest(request.toByteString()).build();
        RegionServerCallable<ClientProtos.CoprocessorServiceResponse> callable = new RegionServerCallable<ClientProtos.CoprocessorServiceResponse>(this.connection, this.table, this.row){

            @Override
            public ClientProtos.CoprocessorServiceResponse call() throws Exception {
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                return ProtobufUtil.execService(this.getStub(), call, regionName);
            }
        };
        ClientProtos.CoprocessorServiceResponse result = this.rpcFactory.newCaller().callWithRetries(callable);
        Message response = null;
        response = result.getValue().hasValue() ? responsePrototype.newBuilderForType().mergeFrom(result.getValue().getValue()).build() : responsePrototype.getDefaultInstanceForType();
        this.lastRegion = result.getRegion().getValue().toByteArray();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Result is region=" + Bytes.toStringBinary((byte[])this.lastRegion) + ", value=" + response));
        }
        return response;
    }

    public byte[] getLastRegion() {
        return this.lastRegion;
    }
}

