/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Methods;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
public abstract class User {
    public static final String HBASE_SECURITY_CONF_KEY = "hbase.security.authentication";
    private static Log LOG = LogFactory.getLog(User.class);
    protected UserGroupInformation ugi;

    public UserGroupInformation getUGI() {
        return this.ugi;
    }

    public String getName() {
        return this.ugi.getUserName();
    }

    public String[] getGroupNames() {
        return this.ugi.getGroupNames();
    }

    public abstract String getShortName();

    public abstract <T> T runAs(PrivilegedAction<T> var1);

    public abstract <T> T runAs(PrivilegedExceptionAction<T> var1) throws IOException, InterruptedException;

    public abstract void obtainAuthTokenForJob(Configuration var1, Job var2) throws IOException, InterruptedException;

    public abstract void obtainAuthTokenForJob(JobConf var1) throws IOException, InterruptedException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ugi.equals((Object)((User)o).ugi);
    }

    public int hashCode() {
        return this.ugi.hashCode();
    }

    public String toString() {
        return this.ugi.toString();
    }

    public static User getCurrent() throws IOException {
        SecureHadoopUser user = new SecureHadoopUser();
        if (user.getUGI() == null) {
            return null;
        }
        return user;
    }

    public static User create(UserGroupInformation ugi) {
        if (ugi == null) {
            return null;
        }
        return new SecureHadoopUser(ugi);
    }

    public static User createUserForTesting(Configuration conf, String name, String[] groups) {
        return SecureHadoopUser.createUserForTesting(conf, name, groups);
    }

    public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
        SecureHadoopUser.login(conf, fileConfKey, principalConfKey, localhost);
    }

    public static boolean isSecurityEnabled() {
        return SecureHadoopUser.isSecurityEnabled();
    }

    public static boolean isHBaseSecurityEnabled(Configuration conf) {
        return "kerberos".equalsIgnoreCase(conf.get(HBASE_SECURITY_CONF_KEY));
    }

    private static Object callStatic(String methodName) throws Exception {
        return User.call(null, methodName, null, null);
    }

    private static Object callStatic(String methodName, Class[] types, Object[] args) throws Exception {
        return User.call(null, methodName, types, args);
    }

    private static Object call(UserGroupInformation instance, String methodName, Class[] types, Object[] args) throws Exception {
        return Methods.call(UserGroupInformation.class, (Object)instance, (String)methodName, (Class[])types, (Object[])args);
    }

    private static class SecureHadoopUser
    extends User {
        private String shortName;

        private SecureHadoopUser() throws IOException {
            try {
                this.ugi = (UserGroupInformation)User.callStatic("getCurrentUser");
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception getting current secure user");
            }
        }

        private SecureHadoopUser(UserGroupInformation ugi) {
            this.ugi = ugi;
        }

        @Override
        public String getShortName() {
            if (this.shortName != null) {
                return this.shortName;
            }
            try {
                this.shortName = (String)User.call(this.ugi, "getShortUserName", null, null);
                return this.shortName;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error getting user short name");
            }
        }

        @Override
        public <T> T runAs(PrivilegedAction<T> action) {
            try {
                return (T)User.call(this.ugi, "doAs", new Class[]{PrivilegedAction.class}, new Object[]{action});
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs()");
            }
        }

        @Override
        public <T> T runAs(PrivilegedExceptionAction<T> action) throws IOException, InterruptedException {
            try {
                return (T)User.call(this.ugi, "doAs", new Class[]{PrivilegedExceptionAction.class}, new Object[]{action});
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception in runAs(PrivilegedExceptionAction)");
            }
        }

        @Override
        public void obtainAuthTokenForJob(Configuration conf, Job job) throws IOException, InterruptedException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                Methods.call(c, null, (String)"obtainTokenForJob", (Class[])new Class[]{Configuration.class, UserGroupInformation.class, Job.class}, (Object[])new Object[]{conf, this.ugi, job});
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainAndCacheToken()");
            }
        }

        @Override
        public void obtainAuthTokenForJob(JobConf job) throws IOException, InterruptedException {
            try {
                Class<?> c = Class.forName("org.apache.hadoop.hbase.security.token.TokenUtil");
                Methods.call(c, null, (String)"obtainTokenForJob", (Class[])new Class[]{JobConf.class, UserGroupInformation.class}, (Object[])new Object[]{job, this.ugi});
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException("Failure loading TokenUtil class, is secure RPC available?", cnfe);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected error calling TokenUtil.obtainAndCacheToken()");
            }
        }

        public static User createUserForTesting(Configuration conf, String name, String[] groups) {
            try {
                return new SecureHadoopUser((UserGroupInformation)User.callStatic("createUserForTesting", new Class[]{String.class, String[].class}, new Object[]{name, groups}));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Error creating secure test user");
            }
        }

        public static void login(Configuration conf, String fileConfKey, String principalConfKey, String localhost) throws IOException {
            if (SecureHadoopUser.isSecurityEnabled()) {
                try {
                    Class<?> c = Class.forName("org.apache.hadoop.security.SecurityUtil");
                    Class[] types = new Class[]{Configuration.class, String.class, String.class, String.class};
                    Object[] args = new Object[]{conf, fileConfKey, principalConfKey, localhost};
                    Methods.call(c, null, (String)"login", (Class[])types, (Object[])args);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException("Unable to login using org.apache.hadoop.security.SecurityUtil.login(). SecurityUtil class was not found!  Is this a version of secure Hadoop?", cnfe);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e) {
                    throw new UndeclaredThrowableException(e, "Unhandled exception in User.login()");
                }
            }
        }

        public static boolean isSecurityEnabled() {
            try {
                return (Boolean)User.callStatic("isSecurityEnabled");
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e, "Unexpected exception calling UserGroupInformation.isSecurityEnabled()");
            }
        }
    }
}

