/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestGet {
    private static final byte[] ROW = new byte[]{114};
    private static final String PB_GET = "CgNyb3ciEwoPdGVzdC5Nb2NrRmlsdGVyEgAwATgB";
    private static final String MOCK_FILTER_JAR = "UEsDBBQACAgIACqBiEIAAAAAAAAAAAAAAAAJAAQATUVUQS1JTkYv/soAAAMAUEsHCAAAAAACAAAAAAAAAFBLAwQUAAgICAAqgYhCAAAAAAAAAAAAAAAAFAAAAE1FVEEtSU5GL01BTklGRVNULk1G803My0xLLS7RDUstKs7Mz7NSMNQz4OVyLkpNLElN0XWqBAmY6xnEG1gqaPgXJSbnpCo45xcV5BcllgCVa/Jy8XIBAFBLBwgxyqRbQwAAAEQAAABQSwMECgAACAAAz4CIQgAAAAAAAAAAAAAAAAUAAAB0ZXN0L1BLAwQUAAgICACPgIhCAAAAAAAAAAAAAAAAFQAAAHRlc3QvTW9ja0ZpbHRlci5jbGFzc41Qy0rDQBQ9k6RNG6N9aH2uXAhWwUC3FRdRC0J1oxSkq0k6mmjaCUkq6lfpqqLgB/hR4k1aqlQEs7j3zLnn3Ec+Pl/fATSwoUNhKCUiTqxT6d62/CARkQ6NoS6ja4uH3PWE5fGelKHlOTwW1lWmscZSmxiG/L4/8JMDBnW73mHQDmVPGFBRNJFDnga0/YE4G/YdEV1wJyBHtS1dHnR45KfvCaklnh8zVNoz+zQZiiGPYtGKZJ+htt216780BkjFoIeO/UA1BqVrM+xm2n+dQlOM43tXhIkvB7GOZYbmX0Yx1VlHIhZ0ReA/8pSYdkj3WTWxgBL1PZfDyBU0h64sfS+9d8PvODZJqSL9VEL0wyjq9LIoM8q5nREKzwQUGBTzYxJzFM0JNjFPuZhOm5gbpE5rhTewyxHKTzN+/Ye/gAqqQPmE/IukWiJOo0ot67Q1XeMFK7NtWNZGydBahta/AFBLBwjdsJqTXwEAAF0CAABQSwECFAAUAAgICAAqgYhCAAAAAAIAAAAAAAAACQAEAAAAAAAAAAAAAAAAAAAATUVUQS1JTkYv/soAAFBLAQIUABQACAgIACqBiEIxyqRbQwAAAEQAAAAUAAAAAAAAAAAAAAAAAD0AAABNRVRBLUlORi9NQU5JRkVTVC5NRlBLAQIKAAoAAAgAAM+AiEIAAAAAAAAAAAAAAAAFAAAAAAAAAAAAAAAAAMIAAAB0ZXN0L1BLAQIUABQACAgIAI+AiELdsJqTXwEAAF0CAAAVAAAAAAAAAAAAAAAAAOUAAAB0ZXN0L01vY2tGaWx0ZXIuY2xhc3NQSwUGAAAAAAQABADzAAAAhwIAAAAA";

    @Test
    public void testAttributesSerialization() throws IOException {
        Get get = new Get(Bytes.toBytes((String)"row"));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        get.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        get.setAttribute("attribute3", Bytes.toBytes((String)"value3"));
        ClientProtos.Get getProto = ProtobufUtil.toGet((Get)get);
        Get get2 = ProtobufUtil.toGet((ClientProtos.Get)getProto);
        Assert.assertNull((Object)get2.getAttribute("absent"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), get2.getAttribute("attribute1")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), get2.getAttribute("attribute2")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value3"), get2.getAttribute("attribute3")));
        Assert.assertEquals((long)3L, (long)get2.getAttributesMap().size());
    }

    @Test
    public void testGetAttributes() {
        Get get = new Get(ROW);
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull((Object)get.getAttribute("absent"));
        get.setAttribute("absent", null);
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull((Object)get.getAttribute("absent"));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), get.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])get.getAttributesMap().get("attribute1")));
        get.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), get.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])get.getAttributesMap().get("attribute1")));
        get.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), get.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)get.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])get.getAttributesMap().get("attribute2")));
        get.setAttribute("attribute2", null);
        Assert.assertNull((Object)get.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertNull(get.getAttributesMap().get("attribute2"));
        get.setAttribute("attribute2", null);
        Assert.assertNull((Object)get.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)get.getAttributesMap().size());
        Assert.assertNull(get.getAttributesMap().get("attribute2"));
        get.setAttribute("attribute1", null);
        Assert.assertNull((Object)get.getAttribute("attribute1"));
        Assert.assertTrue((boolean)get.getAttributesMap().isEmpty());
        Assert.assertNull(get.getAttributesMap().get("attribute1"));
    }

    @Test
    public void testNullQualifier() {
        Get get = new Get(ROW);
        byte[] family = Bytes.toBytes((String)"family");
        get.addColumn(family, null);
        Set qualifiers = (Set)get.getFamilyMap().get(family);
        Assert.assertEquals((long)1L, (long)qualifiers.size());
    }

    @Test
    public void testDynamicFilter() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        String localPath = conf.get("hbase.local.dir") + File.separator + "jars" + File.separator;
        File jarFile = new File(localPath, "MockFilter.jar");
        jarFile.delete();
        Assert.assertFalse((String)("Should be deleted: " + jarFile.getPath()), (boolean)jarFile.exists());
        ClientProtos.Get getProto = ClientProtos.Get.parseFrom((byte[])Base64.decode((String)PB_GET));
        try {
            ProtobufUtil.toGet((ClientProtos.Get)getProto);
            Assert.fail((String)"Should not be able to load the filter class");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe.getCause() instanceof ClassNotFoundException));
        }
        FileOutputStream fos = new FileOutputStream(jarFile);
        fos.write(Base64.decode((String)MOCK_FILTER_JAR));
        fos.close();
        Get get = ProtobufUtil.toGet((ClientProtos.Get)getProto);
        Assert.assertEquals((Object)"test.MockFilter", (Object)get.getFilter().getClass().getName());
    }
}

