/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestPutWriteToWal {
    private Put put;

    @Before
    public void setUp() throws Exception {
        this.put = new Put("test".getBytes());
    }

    @Test
    public void testWriteToWAL() {
        this.put.setWriteToWAL(true);
        Assert.assertEquals((Object)Durability.USE_DEFAULT, (Object)this.put.getDurability());
    }

    @Test
    public void testNoWriteToWAL() {
        this.put.setWriteToWAL(false);
        Assert.assertEquals((Object)Durability.SKIP_WAL, (Object)this.put.getDurability());
    }

    @Test
    public void testWriteToWALSwitch() {
        this.put.setWriteToWAL(false);
        Assert.assertEquals((Object)Durability.SKIP_WAL, (Object)this.put.getDurability());
        this.put.setWriteToWAL(true);
        Assert.assertEquals((Object)Durability.USE_DEFAULT, (Object)this.put.getDurability());
    }

    @Test
    public void testPutCopy() {
        this.put.setWriteToWAL(false);
        Put putCopy1 = new Put(this.put);
        Assert.assertEquals((Object)Durability.SKIP_WAL, (Object)putCopy1.getDurability());
        this.put.setWriteToWAL(true);
        Put putCopy2 = new Put(this.put);
        Assert.assertEquals((Object)Durability.USE_DEFAULT, (Object)putCopy2.getDurability());
    }
}

