/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestScan {
    @Test
    public void testAttributesSerialization() throws IOException {
        Scan scan = new Scan();
        scan.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        scan.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        scan.setAttribute("attribute3", Bytes.toBytes((String)"value3"));
        ClientProtos.Scan scanProto = ProtobufUtil.toScan((Scan)scan);
        Scan scan2 = ProtobufUtil.toScan((ClientProtos.Scan)scanProto);
        Assert.assertNull((Object)scan2.getAttribute("absent"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), scan2.getAttribute("attribute1")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), scan2.getAttribute("attribute2")));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value3"), scan2.getAttribute("attribute3")));
        Assert.assertEquals((long)3L, (long)scan2.getAttributesMap().size());
    }

    @Test
    public void testScanAttributes() {
        Scan scan = new Scan();
        Assert.assertTrue((boolean)scan.getAttributesMap().isEmpty());
        Assert.assertNull((Object)scan.getAttribute("absent"));
        scan.setAttribute("absent", null);
        Assert.assertTrue((boolean)scan.getAttributesMap().isEmpty());
        Assert.assertNull((Object)scan.getAttribute("absent"));
        scan.setAttribute("attribute1", Bytes.toBytes((String)"value1"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), scan.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value1"), (byte[])scan.getAttributesMap().get("attribute1")));
        scan.setAttribute("attribute1", Bytes.toBytes((String)"value12"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), scan.getAttribute("attribute1")));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value12"), (byte[])scan.getAttributesMap().get("attribute1")));
        scan.setAttribute("attribute2", Bytes.toBytes((String)"value2"));
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), scan.getAttribute("attribute2")));
        Assert.assertEquals((long)2L, (long)scan.getAttributesMap().size());
        Assert.assertTrue((boolean)Arrays.equals(Bytes.toBytes((String)"value2"), (byte[])scan.getAttributesMap().get("attribute2")));
        scan.setAttribute("attribute2", null);
        Assert.assertNull((Object)scan.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertNull(scan.getAttributesMap().get("attribute2"));
        scan.setAttribute("attribute2", null);
        Assert.assertNull((Object)scan.getAttribute("attribute2"));
        Assert.assertEquals((long)1L, (long)scan.getAttributesMap().size());
        Assert.assertNull(scan.getAttributesMap().get("attribute2"));
        scan.setAttribute("attribute1", null);
        Assert.assertNull((Object)scan.getAttribute("attribute1"));
        Assert.assertTrue((boolean)scan.getAttributesMap().isEmpty());
        Assert.assertNull(scan.getAttributesMap().get("attribute1"));
    }

    @Test
    public void testNullQualifier() {
        Scan scan = new Scan();
        byte[] family = Bytes.toBytes((String)"family");
        scan.addColumn(family, null);
        Set qualifiers = (Set)scan.getFamilyMap().get(family);
        Assert.assertEquals((long)1L, (long)qualifiers.size());
    }
}

