/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import com.google.protobuf.HBaseZeroCopyByteString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.protobuf.generated.EncryptionProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionUtil {
    private static final SecureRandom RNG = new SecureRandom();

    public static byte[] wrapKey(Configuration conf, byte[] key, String algorithm) throws IOException {
        return EncryptionUtil.wrapKey(conf, conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), new SecretKeySpec(key, algorithm));
    }

    public static byte[] wrapKey(Configuration conf, String subject, Key key) throws IOException {
        Cipher cipher = Encryption.getCipher((Configuration)conf, (String)"AES");
        if (cipher == null) {
            throw new RuntimeException("Cipher 'AES' not available");
        }
        EncryptionProtos.WrappedKey.Builder builder = EncryptionProtos.WrappedKey.newBuilder();
        builder.setAlgorithm(key.getAlgorithm());
        byte[] iv = null;
        if (cipher.getIvLength() > 0) {
            iv = new byte[cipher.getIvLength()];
            RNG.nextBytes(iv);
            builder.setIv(HBaseZeroCopyByteString.wrap((byte[])iv));
        }
        byte[] keyBytes = key.getEncoded();
        builder.setLength(keyBytes.length);
        builder.setHash(HBaseZeroCopyByteString.wrap((byte[])Encryption.hash128((byte[][])new byte[][]{keyBytes})));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encryption.encryptWithSubjectKey((OutputStream)out, (InputStream)new ByteArrayInputStream(keyBytes), (String)subject, (Configuration)conf, (Cipher)cipher, (byte[])iv);
        builder.setData(HBaseZeroCopyByteString.wrap((byte[])out.toByteArray()));
        out.reset();
        builder.build().writeDelimitedTo((OutputStream)out);
        return out.toByteArray();
    }

    public static Key unwrapKey(Configuration conf, String subject, byte[] value) throws IOException, KeyException {
        EncryptionProtos.WrappedKey wrappedKey = (EncryptionProtos.WrappedKey)EncryptionProtos.WrappedKey.PARSER.parseDelimitedFrom((InputStream)new ByteArrayInputStream(value));
        Cipher cipher = Encryption.getCipher((Configuration)conf, (String)"AES");
        if (cipher == null) {
            throw new RuntimeException("Algorithm 'AES' not available");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] iv = wrappedKey.hasIv() ? wrappedKey.getIv().toByteArray() : null;
        Encryption.decryptWithSubjectKey((OutputStream)out, (InputStream)wrappedKey.getData().newInput(), (int)wrappedKey.getLength(), (String)subject, (Configuration)conf, (Cipher)cipher, (byte[])iv);
        byte[] keyBytes = out.toByteArray();
        if (wrappedKey.hasHash() && !Bytes.equals((byte[])wrappedKey.getHash().toByteArray(), (byte[])Encryption.hash128((byte[][])new byte[][]{keyBytes}))) {
            throw new KeyException("Key was not successfully unwrapped");
        }
        return new SecretKeySpec(keyBytes, wrappedKey.getAlgorithm());
    }
}

