/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.SecureBulkLoadProtos;
import org.apache.hadoop.hbase.security.SecureBulkLoadUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class SecureBulkLoadClient {
    private HTable table;

    public SecureBulkLoadClient(HTable table) {
        this.table = table;
    }

    public String prepareBulkLoad(final TableName tableName) throws IOException {
        try {
            return this.table.coprocessorService(SecureBulkLoadProtos.SecureBulkLoadService.class, HConstants.EMPTY_START_ROW, HConstants.LAST_ROW, new Batch.Call<SecureBulkLoadProtos.SecureBulkLoadService, String>(){

                @Override
                public String call(SecureBulkLoadProtos.SecureBulkLoadService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    SecureBulkLoadProtos.PrepareBulkLoadRequest request = SecureBulkLoadProtos.PrepareBulkLoadRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
                    instance.prepareBulkLoad((RpcController)controller, request, rpcCallback);
                    SecureBulkLoadProtos.PrepareBulkLoadResponse response = (SecureBulkLoadProtos.PrepareBulkLoadResponse)rpcCallback.get();
                    if (controller.failedOnException()) {
                        throw controller.getFailedOn();
                    }
                    return response.getBulkToken();
                }
            }).entrySet().iterator().next().getValue();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public void cleanupBulkLoad(final String bulkToken) throws IOException {
        try {
            this.table.coprocessorService(SecureBulkLoadProtos.SecureBulkLoadService.class, HConstants.EMPTY_START_ROW, HConstants.LAST_ROW, new Batch.Call<SecureBulkLoadProtos.SecureBulkLoadService, String>(){

                @Override
                public String call(SecureBulkLoadProtos.SecureBulkLoadService instance) throws IOException {
                    ServerRpcController controller = new ServerRpcController();
                    BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                    SecureBulkLoadProtos.CleanupBulkLoadRequest request = SecureBulkLoadProtos.CleanupBulkLoadRequest.newBuilder().setBulkToken(bulkToken).build();
                    instance.cleanupBulkLoad((RpcController)controller, request, rpcCallback);
                    if (controller.failedOnException()) {
                        throw controller.getFailedOn();
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, Token<?> userToken, String bulkToken, byte[] startRow) throws IOException {
        try {
            CoprocessorRpcChannel channel = this.table.coprocessorService(startRow);
            SecureBulkLoadProtos.SecureBulkLoadService instance = ProtobufUtil.newServiceStub(SecureBulkLoadProtos.SecureBulkLoadService.class, channel);
            SecureBulkLoadProtos.DelegationToken protoDT = SecureBulkLoadProtos.DelegationToken.newBuilder().build();
            if (userToken != null) {
                protoDT = SecureBulkLoadProtos.DelegationToken.newBuilder().setIdentifier(HBaseZeroCopyByteString.wrap((byte[])userToken.getIdentifier())).setPassword(HBaseZeroCopyByteString.wrap((byte[])userToken.getPassword())).setKind(userToken.getKind().toString()).setService(userToken.getService().toString()).build();
            }
            ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath> protoFamilyPaths = new ArrayList<ClientProtos.BulkLoadHFileRequest.FamilyPath>();
            for (Pair<byte[], String> el : familyPaths) {
                protoFamilyPaths.add(ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder().setFamily(HBaseZeroCopyByteString.wrap((byte[])((byte[])el.getFirst()))).setPath((String)el.getSecond()).build());
            }
            SecureBulkLoadProtos.SecureBulkLoadHFilesRequest request = SecureBulkLoadProtos.SecureBulkLoadHFilesRequest.newBuilder().setFsToken(protoDT).addAllFamilyPath(protoFamilyPaths).setBulkToken(bulkToken).build();
            ServerRpcController controller = new ServerRpcController();
            BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
            instance.secureBulkLoadHFiles((RpcController)controller, request, rpcCallback);
            SecureBulkLoadProtos.SecureBulkLoadHFilesResponse response = (SecureBulkLoadProtos.SecureBulkLoadHFilesResponse)rpcCallback.get();
            if (controller.failedOnException()) {
                throw controller.getFailedOn();
            }
            return response.getLoaded();
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public Path getStagingPath(String bulkToken, byte[] family) throws IOException {
        return SecureBulkLoadUtil.getStagingPath(this.table.getConfiguration(), bulkToken, family);
    }
}

