/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Put
extends Mutation
implements HeapSize,
Comparable<Row> {
    public Put(byte[] row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] row, long ts) {
        this(row, 0, row.length, ts);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength) {
        this(rowArray, rowOffset, rowLength, Long.MAX_VALUE);
    }

    public Put(ByteBuffer row, long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        Put.checkRow(row);
        this.row = new byte[row.remaining()];
        row.get(this.row);
        this.ts = ts;
    }

    public Put(ByteBuffer row) {
        this(row, Long.MAX_VALUE);
    }

    public Put(byte[] rowArray, int rowOffset, int rowLength, long ts) {
        Put.checkRow(rowArray, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])rowArray, (int)rowOffset, (int)rowLength);
        this.ts = ts;
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
    }

    public Put(Put putToCopy) {
        this(putToCopy.getRow(), putToCopy.ts);
        this.familyMap = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : putToCopy.getFamilyCellMap().entrySet()) {
            this.familyMap.put(entry.getKey(), entry.getValue());
        }
        this.durability = putToCopy.durability;
        for (Map.Entry<Object, Object> entry : putToCopy.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    public Put add(byte[] family, byte[] qualifier, byte[] value) {
        return this.add(family, qualifier, this.ts, value);
    }

    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value) {
        return this.addImmutable(family, qualifier, this.ts, value);
    }

    public Put addImmutable(byte[] family, byte[] qualifier, byte[] value, Tag[] tag) {
        return this.addImmutable(family, qualifier, this.ts, value, tag);
    }

    public Put add(byte[] family, byte[] qualifier, long ts, byte[] value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add((Cell)kv);
        this.familyMap.put(CellUtil.cloneFamily((Cell)kv), list);
        return this;
    }

    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Put addImmutable(byte[] family, byte[] qualifier, long ts, byte[] value, Tag[] tag) {
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, tag);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value, Tag[] tag) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, tag);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Put add(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, null);
        list.add((Cell)kv);
        this.familyMap.put(CellUtil.cloneFamily((Cell)kv), list);
        return this;
    }

    public Put addImmutable(byte[] family, ByteBuffer qualifier, long ts, ByteBuffer value) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, ts, value, null);
        list.add((Cell)kv);
        this.familyMap.put(family, list);
        return this;
    }

    public Put add(Cell kv) throws IOException {
        byte[] family = CellUtil.cloneFamily((Cell)kv);
        List<Cell> list = this.getCellList(family);
        int res = Bytes.compareTo((byte[])this.row, (int)0, (int)this.row.length, (byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength());
        if (res != 0) {
            throw new WrongRowIOException("The row in " + kv.toString() + " doesn't match the original one " + Bytes.toStringBinary((byte[])this.row));
        }
        list.add(kv);
        this.familyMap.put(family, list);
        return this;
    }

    public boolean has(byte[] family, byte[] qualifier) {
        return this.has(family, qualifier, this.ts, new byte[0], true, true);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts) {
        return this.has(family, qualifier, ts, new byte[0], false, true);
    }

    public boolean has(byte[] family, byte[] qualifier, byte[] value) {
        return this.has(family, qualifier, this.ts, value, true, false);
    }

    public boolean has(byte[] family, byte[] qualifier, long ts, byte[] value) {
        return this.has(family, qualifier, ts, value, false, false);
    }

    private boolean has(byte[] family, byte[] qualifier, long ts, byte[] value, boolean ignoreTS, boolean ignoreValue) {
        List<Cell> list = this.getCellList(family);
        if (list.size() == 0) {
            return false;
        }
        if (!ignoreTS && !ignoreValue) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || !CellUtil.matchingValue((Cell)cell, (byte[])value) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (ignoreValue && !ignoreTS) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || cell.getTimestamp() != ts) continue;
                return true;
            }
        } else if (!ignoreValue && ignoreTS) {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier) || !CellUtil.matchingValue((Cell)cell, (byte[])value)) continue;
                return true;
            }
        } else {
            for (Cell cell : list) {
                if (!CellUtil.matchingFamily((Cell)cell, (byte[])family) || !CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Cell> get(byte[] family, byte[] qualifier) {
        ArrayList<Cell> filteredList = new ArrayList<Cell>();
        for (Cell cell : this.getCellList(family)) {
            if (!CellUtil.matchingQualifier((Cell)cell, (byte[])qualifier)) continue;
            filteredList.add(cell);
        }
        return filteredList;
    }
}

