/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class TableConfiguration {
    private final long writeBufferSize;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final int retries;
    private final int maxKeyValueSize;

    TableConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong("hbase.client.write.buffer", 0x200000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", Integer.MAX_VALUE);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", 100);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.maxKeyValueSize = conf.getInt("hbase.client.keyvalue.maxsize", -1);
    }

    @VisibleForTesting
    protected TableConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.metaOperationTimeout = Integer.MAX_VALUE;
        this.operationTimeout = Integer.MAX_VALUE;
        this.scannerCaching = 100;
        this.retries = 31;
        this.maxKeyValueSize = -1;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }
}

