/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClientSmallScanner
extends ClientScanner {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private RegionServerCallable<Result[]> smallScanCallable = null;
    private SmallScannerCallableFactory callableFactory;

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName) throws IOException {
        this(conf, scan, tableName, HConnectionManager.getConnection(conf));
    }

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection) throws IOException {
        this(conf, scan, tableName, connection, RpcRetryingCallerFactory.instantiate(conf, connection.getStatisticsTracker()), RpcControllerFactory.instantiate(conf));
    }

    public ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory) throws IOException {
        this(conf, scan, tableName, connection, rpcFactory, controllerFactory, new SmallScannerCallableFactory());
    }

    @VisibleForTesting
    ClientSmallScanner(Configuration conf, Scan scan, TableName tableName, HConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, SmallScannerCallableFactory callableFactory) throws IOException {
        super(conf, scan, tableName, connection, rpcFactory, controllerFactory);
        this.callableFactory = callableFactory;
    }

    @Override
    protected void initializeScannerInConstruction() throws IOException {
    }

    private boolean nextScanner(int nbRows, boolean done, boolean currentRegionDone) throws IOException {
        byte[] localStartKey;
        int cacheNum = nbRows;
        boolean regionChanged = true;
        if (this.currentRegion != null && currentRegionDone) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Finished with small scan at " + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Finished with region " + this.currentRegion));
            }
        } else if (this.lastResult != null) {
            regionChanged = false;
            localStartKey = Bytes.add((byte[])this.lastResult.getRow(), (byte[])new byte[1]);
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace((Object)("Advancing internal small scanner to startKey at '" + Bytes.toStringBinary((byte[])localStartKey) + "'"));
        }
        this.smallScanCallable = this.callableFactory.getCallable(this.scan, this.getConnection(), this.getTable(), this.scanMetrics, localStartKey, cacheNum, this.rpcControllerFactory);
        if (this.scanMetrics != null && regionChanged) {
            this.scanMetrics.countOfRegions.incrementAndGet();
        }
        return true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.loadCache();
        }
        if (this.cache.size() > 0) {
            return (Result)this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @Override
    protected void loadCache() throws IOException {
        Result[] values = null;
        long remainingResultSize = this.maxScannerResultSize;
        int countdown = this.caching;
        boolean currentRegionDone = false;
        while (remainingResultSize > 0L && countdown > 0 && this.nextScanner(countdown, values == null, currentRegionDone)) {
            values = this.caller.callWithRetries(this.smallScanCallable);
            this.currentRegion = this.smallScanCallable.getHRegionInfo();
            long currentTime = System.currentTimeMillis();
            if (this.scanMetrics != null) {
                this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
            }
            this.lastNext = currentTime;
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    Result rs = values[i];
                    this.cache.add(rs);
                    for (Cell kv : rs.rawCells()) {
                        remainingResultSize -= KeyValueUtil.ensureKeyValue((Cell)kv).heapSize();
                    }
                    --countdown;
                    this.lastResult = rs;
                }
            }
            if (this.smallScanCallable.hasMoreResultsContext()) {
                currentRegionDone = !this.smallScanCallable.getServerHasMoreResults();
                continue;
            }
            currentRegionDone = countdown > 0;
        }
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
    }

    @VisibleForTesting
    protected void setScannerCallableFactory(SmallScannerCallableFactory callableFactory) {
        this.callableFactory = callableFactory;
    }

    @VisibleForTesting
    protected void setRpcRetryingCaller(RpcRetryingCaller<Result[]> caller) {
        this.caller = caller;
    }

    @VisibleForTesting
    protected void setRpcControllerFactory(RpcControllerFactory rpcControllerFactory) {
        this.rpcControllerFactory = rpcControllerFactory;
    }

    @InterfaceAudience.Private
    protected static class SmallScannerCallableFactory {
        protected SmallScannerCallableFactory() {
        }

        public RegionServerCallable<Result[]> getCallable(Scan sc, HConnection connection, TableName tableName, ScanMetrics scanMetrics, byte[] localStartKey, int cacheNum, RpcControllerFactory rpcControllerFactory) throws IOException {
            sc.setStartRow(localStartKey);
            PayloadCarryingRpcController controller = rpcControllerFactory.newController();
            return new SmallScannerCallable(connection, tableName, sc, scanMetrics, controller, cacheNum);
        }
    }

    static class SmallScannerCallable
    extends ScannerCallable {
        public SmallScannerCallable(HConnection connection, TableName tableName, Scan scan, ScanMetrics scanMetrics, PayloadCarryingRpcController controller, int cacheNum) {
            super(connection, tableName, scan, scanMetrics, controller);
            this.setCaching(cacheNum);
        }

        @Override
        public Result[] call() throws IOException {
            if (this.closed) {
                return null;
            }
            if (Thread.interrupted()) {
                throw new InterruptedIOException();
            }
            ClientProtos.ScanRequest request = RequestConverter.buildScanRequest(this.getLocation().getRegionInfo().getRegionName(), this.getScan(), this.getCaching(), true);
            ClientProtos.ScanResponse response = null;
            try {
                this.controller.setPriority(this.getTableName());
                response = this.getStub().scan((RpcController)this.controller, request);
                Result[] results = ResponseConverter.getResults(this.controller.cellScanner(), response);
                if (response.hasMoreResultsInRegion()) {
                    this.setHasMoreResultsContext(true);
                    this.setServerHasMoreResults(response.getMoreResultsInRegion());
                } else {
                    this.setHasMoreResultsContext(false);
                }
                this.updateResultsMetrics(results);
                return results;
            }
            catch (ServiceException se) {
                throw ProtobufUtil.getRemoteException(se);
            }
        }
    }
}

