/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public abstract class AbstractClientScanner
implements ResultScanner {
    protected ScanMetrics scanMetrics;

    protected void initScanMetrics(Scan scan) {
        byte[] enableMetrics = scan.getAttribute("scan.attributes.metrics.enable");
        if (enableMetrics != null && Bytes.toBoolean((byte[])enableMetrics)) {
            this.scanMetrics = new ScanMetrics();
        }
    }

    public ScanMetrics getScanMetrics() {
        return this.scanMetrics;
    }

    @Override
    public Result[] next(int nbRows) throws IOException {
        Result next;
        ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
        for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
            resultSets.add(next);
        }
        return resultSets.toArray(new Result[resultSets.size()]);
    }

    @Override
    public Iterator<Result> iterator() {
        return new Iterator<Result>(){
            Result next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = AbstractClientScanner.this.next();
                        return this.next != null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public Result next() {
                if (!this.hasNext()) {
                    return null;
                }
                Result temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

