/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.protobuf;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionCoprocessorServiceExec;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Triple;

@InterfaceAudience.Private
public final class RequestConverter {
    private static AdminProtos.RollWALWriterRequest ROLL_WAL_WRITER_REQUEST = AdminProtos.RollWALWriterRequest.newBuilder().build();
    private static AdminProtos.GetServerInfoRequest GET_SERVER_INFO_REQUEST = AdminProtos.GetServerInfoRequest.newBuilder().build();
    private static final MasterProtos.GetClusterStatusRequest GET_CLUSTER_STATUS_REQUEST = MasterProtos.GetClusterStatusRequest.newBuilder().build();
    private static final MasterProtos.RunCatalogScanRequest CATALOG_SCAN_REQUEST = MasterProtos.RunCatalogScanRequest.newBuilder().build();
    private static final MasterProtos.IsCatalogJanitorEnabledRequest IS_CATALOG_JANITOR_ENABLED_REQUEST = MasterProtos.IsCatalogJanitorEnabledRequest.newBuilder().build();

    private RequestConverter() {
    }

    public static ClientProtos.GetRequest buildGetRowOrBeforeRequest(byte[] regionName, byte[] row, byte[] family) {
        ClientProtos.GetRequest.Builder builder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.Column.Builder columnBuilder = ClientProtos.Column.newBuilder();
        columnBuilder.setFamily(ByteStringer.wrap((byte[])family));
        ClientProtos.Get.Builder getBuilder = ClientProtos.Get.newBuilder();
        getBuilder.setRow(ByteStringer.wrap((byte[])row));
        getBuilder.addColumn(columnBuilder.build());
        getBuilder.setClosestRowBefore(true);
        builder.setGet(getBuilder.build());
        return builder.build();
    }

    public static ClientProtos.GetRequest buildGetRequest(byte[] regionName, Get get) throws IOException {
        ClientProtos.GetRequest.Builder builder = ClientProtos.GetRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setGet(ProtobufUtil.toGet(get));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildIncrementRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, long amount, Durability durability, long nonceGroup, long nonce) {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.MutationProto.Builder mutateBuilder = ClientProtos.MutationProto.newBuilder();
        mutateBuilder.setRow(ByteStringer.wrap((byte[])row));
        mutateBuilder.setMutateType(ClientProtos.MutationProto.MutationType.INCREMENT);
        mutateBuilder.setDurability(ProtobufUtil.toDurability(durability));
        ClientProtos.MutationProto.ColumnValue.Builder columnBuilder = ClientProtos.MutationProto.ColumnValue.newBuilder();
        columnBuilder.setFamily(ByteStringer.wrap((byte[])family));
        ClientProtos.MutationProto.ColumnValue.QualifierValue.Builder valueBuilder = ClientProtos.MutationProto.ColumnValue.QualifierValue.newBuilder();
        valueBuilder.setValue(ByteStringer.wrap((byte[])Bytes.toBytes((long)amount)));
        valueBuilder.setQualifier(ByteStringer.wrap((byte[])qualifier));
        columnBuilder.addQualifierValue(valueBuilder.build());
        mutateBuilder.addColumnValue(columnBuilder.build());
        if (nonce != 0L) {
            mutateBuilder.setNonce(nonce);
        }
        builder.setMutation(mutateBuilder.build());
        if (nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, Put put) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.Condition condition = RequestConverter.buildCondition(row, family, qualifier, comparator, compareType);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, ClientProtos.MutationProto.newBuilder()));
        builder.setCondition(condition);
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType, Delete delete) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.Condition condition = RequestConverter.buildCondition(row, family, qualifier, comparator, compareType);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete, ClientProtos.MutationProto.newBuilder()));
        builder.setCondition(condition);
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Put put) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Mutation)put, ClientProtos.MutationProto.newBuilder()));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Append append, long nonceGroup, long nonce) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (nonce != 0L && nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, append, ClientProtos.MutationProto.newBuilder(), nonce));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Increment increment, long nonceGroup, long nonce) {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (nonce != 0L && nonceGroup != 0L) {
            builder.setNonceGroup(nonceGroup);
        }
        builder.setMutation(ProtobufUtil.toMutation(increment, ClientProtos.MutationProto.newBuilder(), nonce));
        return builder.build();
    }

    public static ClientProtos.MutateRequest buildMutateRequest(byte[] regionName, Delete delete) throws IOException {
        ClientProtos.MutateRequest.Builder builder = ClientProtos.MutateRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)delete, ClientProtos.MutationProto.newBuilder()));
        return builder.build();
    }

    public static ClientProtos.RegionAction.Builder buildRegionAction(byte[] regionName, RowMutations rowMutations) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(ClientProtos.RegionAction.newBuilder(), regionName);
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType mutateType = null;
            if (mutation instanceof Put) {
                mutateType = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                mutateType = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutation(mutateType, mutation, mutationBuilder);
            actionBuilder.clear();
            actionBuilder.setMutation(mp);
            builder.addAction(actionBuilder.build());
        }
        return builder;
    }

    public static ClientProtos.RegionAction.Builder buildNoDataRegionAction(byte[] regionName, RowMutations rowMutations, List<CellScannable> cells, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        for (Mutation mutation : rowMutations.getMutations()) {
            ClientProtos.MutationProto.MutationType type = null;
            if (mutation instanceof Put) {
                type = ClientProtos.MutationProto.MutationType.PUT;
            } else if (mutation instanceof Delete) {
                type = ClientProtos.MutationProto.MutationType.DELETE;
            } else {
                throw new DoNotRetryIOException("RowMutations supports only put and delete, not " + mutation.getClass().getName());
            }
            mutationBuilder.clear();
            ClientProtos.MutationProto mp = ProtobufUtil.toMutationNoData(type, mutation, mutationBuilder);
            cells.add(mutation);
            actionBuilder.clear();
            regionActionBuilder.addAction(actionBuilder.setMutation(mp).build());
        }
        return regionActionBuilder;
    }

    private static ClientProtos.RegionAction.Builder getRegionActionBuilderWithRegion(ClientProtos.RegionAction.Builder regionActionBuilder, byte[] regionName) {
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        regionActionBuilder.setRegion(region);
        return regionActionBuilder;
    }

    public static ClientProtos.ScanRequest buildScanRequest(byte[] regionName, Scan scan, int numberOfRows, boolean closeScanner) throws IOException {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setRegion(region);
        builder.setScan(ProtobufUtil.toScan(scan));
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        return builder.build();
    }

    public static ClientProtos.ScanRequest buildScanRequest(long scannerId, int numberOfRows, boolean closeScanner, long nextCallSeq) {
        ClientProtos.ScanRequest.Builder builder = ClientProtos.ScanRequest.newBuilder();
        builder.setNumberOfRows(numberOfRows);
        builder.setCloseScanner(closeScanner);
        builder.setScannerId(scannerId);
        builder.setNextCallSeq(nextCallSeq);
        return builder.build();
    }

    public static ClientProtos.BulkLoadHFileRequest buildBulkLoadHFileRequest(List<Pair<byte[], String>> familyPaths, byte[] regionName, boolean assignSeqNum) {
        ClientProtos.BulkLoadHFileRequest.Builder builder = ClientProtos.BulkLoadHFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        ClientProtos.BulkLoadHFileRequest.FamilyPath.Builder familyPathBuilder = ClientProtos.BulkLoadHFileRequest.FamilyPath.newBuilder();
        for (Pair<byte[], String> familyPath : familyPaths) {
            familyPathBuilder.setFamily(ByteStringer.wrap((byte[])((byte[])familyPath.getFirst())));
            familyPathBuilder.setPath((String)familyPath.getSecond());
            builder.addFamilyPath(familyPathBuilder.build());
        }
        builder.setAssignSeqNum(assignSeqNum);
        return builder.build();
    }

    public static <R> ClientProtos.RegionAction.Builder buildRegionAction(byte[] regionName, List<Action<R>> actions, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        for (Action<R> action : actions) {
            Row row = action.getAction();
            actionBuilder.clear();
            actionBuilder.setIndex(action.getOriginalIndex());
            mutationBuilder.clear();
            if (row instanceof Get) {
                Get g = (Get)row;
                regionActionBuilder.addAction(actionBuilder.setGet(ProtobufUtil.toGet(g)));
                continue;
            }
            if (row instanceof Put) {
                regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, (Mutation)((Put)row), mutationBuilder)));
                continue;
            }
            if (row instanceof Delete) {
                regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)((Delete)row), mutationBuilder)));
                continue;
            }
            if (row instanceof Append) {
                regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.APPEND, (Append)row, mutationBuilder, action.getNonce())));
                continue;
            }
            if (row instanceof Increment) {
                regionActionBuilder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation((Increment)row, mutationBuilder, action.getNonce())));
                continue;
            }
            if (row instanceof RegionCoprocessorServiceExec) {
                RegionCoprocessorServiceExec exec = (RegionCoprocessorServiceExec)row;
                regionActionBuilder.addAction(actionBuilder.setServiceCall(ClientProtos.CoprocessorServiceCall.newBuilder().setRow(ByteStringer.wrap((byte[])exec.getRow())).setServiceName(exec.getMethod().getService().getFullName()).setMethodName(exec.getMethod().getName()).setRequest(exec.getRequest().toByteString())));
                continue;
            }
            if (row instanceof RowMutations) {
                throw new UnsupportedOperationException("No RowMutations in multi calls; use mutateRow");
            }
            throw new DoNotRetryIOException("Multi doesn't support " + row.getClass().getName());
        }
        return regionActionBuilder;
    }

    public static <R> ClientProtos.RegionAction.Builder buildNoDataRegionAction(byte[] regionName, List<Action<R>> actions, List<CellScannable> cells, ClientProtos.RegionAction.Builder regionActionBuilder, ClientProtos.Action.Builder actionBuilder, ClientProtos.MutationProto.Builder mutationBuilder) throws IOException {
        ClientProtos.RegionAction.Builder builder = RequestConverter.getRegionActionBuilderWithRegion(ClientProtos.RegionAction.newBuilder(), regionName);
        for (Action<R> action : actions) {
            Row row = action.getAction();
            actionBuilder.clear();
            actionBuilder.setIndex(action.getOriginalIndex());
            mutationBuilder.clear();
            if (row instanceof Get) {
                Get g = (Get)row;
                builder.addAction(actionBuilder.setGet(ProtobufUtil.toGet(g)));
                continue;
            }
            if (row instanceof Put) {
                Put p = (Put)row;
                cells.add(p);
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.PUT, p, mutationBuilder)));
                continue;
            }
            if (row instanceof Delete) {
                Delete d = (Delete)row;
                int size = d.size();
                if (size > 0) {
                    cells.add(d);
                    builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.DELETE, d, mutationBuilder)));
                    continue;
                }
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, (Mutation)d, mutationBuilder)));
                continue;
            }
            if (row instanceof Append) {
                Append a = (Append)row;
                cells.add(a);
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.APPEND, a, mutationBuilder, action.getNonce())));
                continue;
            }
            if (row instanceof Increment) {
                Increment i = (Increment)row;
                cells.add(i);
                builder.addAction(actionBuilder.setMutation(ProtobufUtil.toMutationNoData(ClientProtos.MutationProto.MutationType.INCREMENT, i, mutationBuilder, action.getNonce())));
                continue;
            }
            if (row instanceof RowMutations) continue;
            throw new DoNotRetryIOException("Multi doesn't support " + row.getClass().getName());
        }
        return builder;
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName) {
        return RequestConverter.buildGetRegionInfoRequest(regionName, false);
    }

    public static AdminProtos.GetRegionInfoRequest buildGetRegionInfoRequest(byte[] regionName, boolean includeCompactionState) {
        AdminProtos.GetRegionInfoRequest.Builder builder = AdminProtos.GetRegionInfoRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (includeCompactionState) {
            builder.setCompactionState(includeCompactionState);
        }
        return builder.build();
    }

    public static AdminProtos.GetStoreFileRequest buildGetStoreFileRequest(byte[] regionName, byte[] family) {
        AdminProtos.GetStoreFileRequest.Builder builder = AdminProtos.GetStoreFileRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.addFamily(ByteStringer.wrap((byte[])family));
        return builder.build();
    }

    public static AdminProtos.GetOnlineRegionRequest buildGetOnlineRegionRequest() {
        return AdminProtos.GetOnlineRegionRequest.newBuilder().build();
    }

    public static AdminProtos.FlushRegionRequest buildFlushRegionRequest(byte[] regionName) {
        AdminProtos.FlushRegionRequest.Builder builder = AdminProtos.FlushRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        return builder.build();
    }

    public static AdminProtos.OpenRegionRequest buildOpenRegionRequest(List<Triple<HRegionInfo, Integer, List<ServerName>>> regionOpenInfos, Boolean openForReplay) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        for (Triple<HRegionInfo, Integer, List<ServerName>> regionOpenInfo : regionOpenInfos) {
            Integer second = (Integer)regionOpenInfo.getSecond();
            int versionOfOfflineNode = second == null ? -1 : second;
            builder.addOpenInfo(RequestConverter.buildRegionOpenInfo((HRegionInfo)regionOpenInfo.getFirst(), versionOfOfflineNode, (List)regionOpenInfo.getThird(), openForReplay));
        }
        return builder.build();
    }

    public static AdminProtos.OpenRegionRequest buildOpenRegionRequest(ServerName server, HRegionInfo region, int versionOfOfflineNode, List<ServerName> favoredNodes, Boolean openForReplay) {
        AdminProtos.OpenRegionRequest.Builder builder = AdminProtos.OpenRegionRequest.newBuilder();
        builder.addOpenInfo(RequestConverter.buildRegionOpenInfo(region, versionOfOfflineNode, favoredNodes, openForReplay));
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        return builder.build();
    }

    public static AdminProtos.UpdateFavoredNodesRequest buildUpdateFavoredNodesRequest(List<Pair<HRegionInfo, List<ServerName>>> updateRegionInfos) {
        AdminProtos.UpdateFavoredNodesRequest.Builder ubuilder = AdminProtos.UpdateFavoredNodesRequest.newBuilder();
        for (Pair<HRegionInfo, List<ServerName>> pair : updateRegionInfos) {
            AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo.Builder builder = AdminProtos.UpdateFavoredNodesRequest.RegionUpdateInfo.newBuilder();
            builder.setRegion(HRegionInfo.convert((HRegionInfo)pair.getFirst()));
            for (ServerName server : (List)pair.getSecond()) {
                builder.addFavoredNodes(ProtobufUtil.toServerName(server));
            }
            ubuilder.addUpdateInfo(builder.build());
        }
        return ubuilder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName, boolean transitionInZK) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setTransitionInZK(transitionInZK);
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, byte[] regionName, int versionOfClosingNode, ServerName destinationServer, boolean transitionInZK) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setVersionOfClosingNode(versionOfClosingNode);
        builder.setTransitionInZK(transitionInZK);
        if (destinationServer != null) {
            builder.setDestinationServer(ProtobufUtil.toServerName(destinationServer));
        }
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        return builder.build();
    }

    public static AdminProtos.CloseRegionRequest buildCloseRegionRequest(ServerName server, String encodedRegionName, boolean transitionInZK) {
        AdminProtos.CloseRegionRequest.Builder builder = AdminProtos.CloseRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, Bytes.toBytes((String)encodedRegionName));
        builder.setRegion(region);
        builder.setTransitionInZK(transitionInZK);
        if (server != null) {
            builder.setServerStartCode(server.getStartcode());
        }
        return builder.build();
    }

    public static AdminProtos.SplitRegionRequest buildSplitRegionRequest(byte[] regionName, byte[] splitPoint) {
        AdminProtos.SplitRegionRequest.Builder builder = AdminProtos.SplitRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        if (splitPoint != null) {
            builder.setSplitPoint(ByteStringer.wrap((byte[])splitPoint));
        }
        return builder.build();
    }

    public static AdminProtos.MergeRegionsRequest buildMergeRegionsRequest(byte[] regionA, byte[] regionB, boolean forcible) {
        AdminProtos.MergeRegionsRequest.Builder builder = AdminProtos.MergeRegionsRequest.newBuilder();
        HBaseProtos.RegionSpecifier regionASpecifier = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionA);
        HBaseProtos.RegionSpecifier regionBSpecifier = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionB);
        builder.setRegionA(regionASpecifier);
        builder.setRegionB(regionBSpecifier);
        builder.setForcible(forcible);
        return builder.build();
    }

    public static AdminProtos.CompactRegionRequest buildCompactRegionRequest(byte[] regionName, boolean major, byte[] family) {
        AdminProtos.CompactRegionRequest.Builder builder = AdminProtos.CompactRegionRequest.newBuilder();
        HBaseProtos.RegionSpecifier region = RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName);
        builder.setRegion(region);
        builder.setMajor(major);
        if (family != null) {
            builder.setFamily(ByteStringer.wrap((byte[])family));
        }
        return builder.build();
    }

    public static AdminProtos.RollWALWriterRequest buildRollWALWriterRequest() {
        return ROLL_WAL_WRITER_REQUEST;
    }

    public static AdminProtos.GetServerInfoRequest buildGetServerInfoRequest() {
        return GET_SERVER_INFO_REQUEST;
    }

    public static AdminProtos.StopServerRequest buildStopServerRequest(String reason) {
        AdminProtos.StopServerRequest.Builder builder = AdminProtos.StopServerRequest.newBuilder();
        builder.setReason(reason);
        return builder.build();
    }

    public static HBaseProtos.RegionSpecifier buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType type, byte[] value) {
        HBaseProtos.RegionSpecifier.Builder regionBuilder = HBaseProtos.RegionSpecifier.newBuilder();
        regionBuilder.setValue(ByteStringer.wrap((byte[])value));
        regionBuilder.setType(type);
        return regionBuilder.build();
    }

    private static ClientProtos.Condition buildCondition(byte[] row, byte[] family, byte[] qualifier, ByteArrayComparable comparator, HBaseProtos.CompareType compareType) throws IOException {
        ClientProtos.Condition.Builder builder = ClientProtos.Condition.newBuilder();
        builder.setRow(ByteStringer.wrap((byte[])row));
        builder.setFamily(ByteStringer.wrap((byte[])family));
        builder.setQualifier(ByteStringer.wrap((byte[])qualifier));
        builder.setComparator(ProtobufUtil.toComparator(comparator));
        builder.setCompareType(compareType);
        return builder.build();
    }

    public static MasterProtos.AddColumnRequest buildAddColumnRequest(TableName tableName, HColumnDescriptor column) {
        MasterProtos.AddColumnRequest.Builder builder = MasterProtos.AddColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnFamilies(column.convert());
        return builder.build();
    }

    public static MasterProtos.DeleteColumnRequest buildDeleteColumnRequest(TableName tableName, byte[] columnName) {
        MasterProtos.DeleteColumnRequest.Builder builder = MasterProtos.DeleteColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnName(ByteStringer.wrap((byte[])columnName));
        return builder.build();
    }

    public static MasterProtos.ModifyColumnRequest buildModifyColumnRequest(TableName tableName, HColumnDescriptor column) {
        MasterProtos.ModifyColumnRequest.Builder builder = MasterProtos.ModifyColumnRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setColumnFamilies(column.convert());
        return builder.build();
    }

    public static MasterProtos.MoveRegionRequest buildMoveRegionRequest(byte[] encodedRegionName, byte[] destServerName) throws DeserializationException {
        MasterProtos.MoveRegionRequest.Builder builder = MasterProtos.MoveRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedRegionName));
        if (destServerName != null) {
            builder.setDestServerName(ProtobufUtil.toServerName(ServerName.valueOf(Bytes.toString((byte[])destServerName))));
        }
        return builder.build();
    }

    public static MasterProtos.DispatchMergingRegionsRequest buildDispatchMergingRegionsRequest(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws DeserializationException {
        MasterProtos.DispatchMergingRegionsRequest.Builder builder = MasterProtos.DispatchMergingRegionsRequest.newBuilder();
        builder.setRegionA(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedNameOfRegionA));
        builder.setRegionB(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.ENCODED_REGION_NAME, encodedNameOfRegionB));
        builder.setForcible(forcible);
        return builder.build();
    }

    public static MasterProtos.AssignRegionRequest buildAssignRegionRequest(byte[] regionName) {
        MasterProtos.AssignRegionRequest.Builder builder = MasterProtos.AssignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.UnassignRegionRequest buildUnassignRegionRequest(byte[] regionName, boolean force) {
        MasterProtos.UnassignRegionRequest.Builder builder = MasterProtos.UnassignRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        builder.setForce(force);
        return builder.build();
    }

    public static MasterProtos.OfflineRegionRequest buildOfflineRegionRequest(byte[] regionName) {
        MasterProtos.OfflineRegionRequest.Builder builder = MasterProtos.OfflineRegionRequest.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        return builder.build();
    }

    public static MasterProtos.DeleteTableRequest buildDeleteTableRequest(TableName tableName) {
        MasterProtos.DeleteTableRequest.Builder builder = MasterProtos.DeleteTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        return builder.build();
    }

    public static MasterProtos.EnableTableRequest buildEnableTableRequest(TableName tableName) {
        MasterProtos.EnableTableRequest.Builder builder = MasterProtos.EnableTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        return builder.build();
    }

    public static MasterProtos.DisableTableRequest buildDisableTableRequest(TableName tableName) {
        MasterProtos.DisableTableRequest.Builder builder = MasterProtos.DisableTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        return builder.build();
    }

    public static MasterProtos.CreateTableRequest buildCreateTableRequest(HTableDescriptor hTableDesc, byte[][] splitKeys) {
        MasterProtos.CreateTableRequest.Builder builder = MasterProtos.CreateTableRequest.newBuilder();
        builder.setTableSchema(hTableDesc.convert());
        if (splitKeys != null) {
            for (byte[] splitKey : splitKeys) {
                builder.addSplitKeys(ByteStringer.wrap((byte[])splitKey));
            }
        }
        return builder.build();
    }

    public static MasterProtos.ModifyTableRequest buildModifyTableRequest(TableName tableName, HTableDescriptor hTableDesc) {
        MasterProtos.ModifyTableRequest.Builder builder = MasterProtos.ModifyTableRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        builder.setTableSchema(hTableDesc.convert());
        return builder.build();
    }

    public static MasterProtos.GetSchemaAlterStatusRequest buildGetSchemaAlterStatusRequest(TableName tableName) {
        MasterProtos.GetSchemaAlterStatusRequest.Builder builder = MasterProtos.GetSchemaAlterStatusRequest.newBuilder();
        builder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(List<TableName> tableNames) {
        MasterProtos.GetTableDescriptorsRequest.Builder builder = MasterProtos.GetTableDescriptorsRequest.newBuilder();
        if (tableNames != null) {
            for (TableName tableName : tableNames) {
                builder.addTableNames(ProtobufUtil.toProtoTableName(tableName));
            }
        }
        return builder.build();
    }

    public static MasterProtos.GetTableDescriptorsRequest buildGetTableDescriptorsRequest(TableName tableName) {
        return MasterProtos.GetTableDescriptorsRequest.newBuilder().addTableNames(ProtobufUtil.toProtoTableName(tableName)).build();
    }

    public static MasterProtos.IsMasterRunningRequest buildIsMasterRunningRequest() {
        return MasterProtos.IsMasterRunningRequest.newBuilder().build();
    }

    public static MasterProtos.BalanceRequest buildBalanceRequest() {
        return MasterProtos.BalanceRequest.newBuilder().build();
    }

    public static MasterProtos.SetBalancerRunningRequest buildSetBalancerRunningRequest(boolean on, boolean synchronous) {
        return MasterProtos.SetBalancerRunningRequest.newBuilder().setOn(on).setSynchronous(synchronous).build();
    }

    public static MasterProtos.GetClusterStatusRequest buildGetClusterStatusRequest() {
        return GET_CLUSTER_STATUS_REQUEST;
    }

    public static MasterProtos.RunCatalogScanRequest buildCatalogScanRequest() {
        return CATALOG_SCAN_REQUEST;
    }

    public static MasterProtos.EnableCatalogJanitorRequest buildEnableCatalogJanitorRequest(boolean enable) {
        return MasterProtos.EnableCatalogJanitorRequest.newBuilder().setEnable(enable).build();
    }

    public static MasterProtos.IsCatalogJanitorEnabledRequest buildIsCatalogJanitorEnabledRequest() {
        return IS_CATALOG_JANITOR_ENABLED_REQUEST;
    }

    public static RegionServerStatusProtos.GetLastFlushedSequenceIdRequest buildGetLastFlushedSequenceIdRequest(byte[] regionName) {
        return RegionServerStatusProtos.GetLastFlushedSequenceIdRequest.newBuilder().setRegionName(ByteStringer.wrap((byte[])regionName)).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.GlobalPermission.Builder permissionBuilder = AccessControlProtos.GlobalPermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        ret.setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, TableName tableName, byte[] family, byte[] qualifier, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (tableName == null) {
            throw new NullPointerException("TableName cannot be null");
        }
        permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        if (family != null) {
            permissionBuilder.setFamily(ByteStringer.wrap((byte[])family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteStringer.wrap((byte[])qualifier));
        }
        ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.GrantRequest buildGrantRequest(String username, String namespace, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.NamespacePermission.Builder permissionBuilder = AccessControlProtos.NamespacePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (namespace != null) {
            permissionBuilder.setNamespaceName(ByteString.copyFromUtf8((String)namespace));
        }
        ret.setType(AccessControlProtos.Permission.Type.Namespace).setNamespacePermission(permissionBuilder);
        return AccessControlProtos.GrantRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.GlobalPermission.Builder permissionBuilder = AccessControlProtos.GlobalPermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        ret.setType(AccessControlProtos.Permission.Type.Global).setGlobalPermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, TableName tableName, byte[] family, byte[] qualifier, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.TablePermission.Builder permissionBuilder = AccessControlProtos.TablePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (tableName != null) {
            permissionBuilder.setTableName(ProtobufUtil.toProtoTableName(tableName));
        }
        if (family != null) {
            permissionBuilder.setFamily(ByteStringer.wrap((byte[])family));
        }
        if (qualifier != null) {
            permissionBuilder.setQualifier(ByteStringer.wrap((byte[])qualifier));
        }
        ret.setType(AccessControlProtos.Permission.Type.Table).setTablePermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
    }

    public static AccessControlProtos.RevokeRequest buildRevokeRequest(String username, String namespace, AccessControlProtos.Permission.Action ... actions) {
        AccessControlProtos.Permission.Builder ret = AccessControlProtos.Permission.newBuilder();
        AccessControlProtos.NamespacePermission.Builder permissionBuilder = AccessControlProtos.NamespacePermission.newBuilder();
        for (AccessControlProtos.Permission.Action a : actions) {
            permissionBuilder.addAction(a);
        }
        if (namespace != null) {
            permissionBuilder.setNamespaceName(ByteString.copyFromUtf8((String)namespace));
        }
        ret.setType(AccessControlProtos.Permission.Type.Namespace).setNamespacePermission(permissionBuilder);
        return AccessControlProtos.RevokeRequest.newBuilder().setUserPermission(AccessControlProtos.UserPermission.newBuilder().setUser(ByteString.copyFromUtf8((String)username)).setPermission(ret)).build();
    }

    private static AdminProtos.OpenRegionRequest.RegionOpenInfo buildRegionOpenInfo(HRegionInfo region, int versionOfOfflineNode, List<ServerName> favoredNodes, Boolean openForReplay) {
        AdminProtos.OpenRegionRequest.RegionOpenInfo.Builder builder = AdminProtos.OpenRegionRequest.RegionOpenInfo.newBuilder();
        builder.setRegion(HRegionInfo.convert(region));
        if (versionOfOfflineNode >= 0) {
            builder.setVersionOfOfflineNode(versionOfOfflineNode);
        }
        if (favoredNodes != null) {
            for (ServerName server : favoredNodes) {
                builder.addFavoredNodes(ProtobufUtil.toServerName(server));
            }
        }
        if (openForReplay != null) {
            builder.setOpenForDistributedLogReplay(openForReplay.booleanValue());
        }
        return builder.build();
    }
}

