/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RegionTransition {
    private final ZooKeeperProtos.RegionTransition rt;

    private RegionTransition() {
        this(null);
    }

    private RegionTransition(ZooKeeperProtos.RegionTransition rt) {
        this.rt = rt;
    }

    public EventType getEventType() {
        return EventType.get(this.rt.getEventTypeCode());
    }

    public ServerName getServerName() {
        return ProtobufUtil.toServerName(this.rt.getServerName());
    }

    public long getCreateTime() {
        return this.rt.getCreateTime();
    }

    public byte[] getRegionName() {
        return this.rt.getRegionName().toByteArray();
    }

    public byte[] getPayload() {
        return this.rt.getPayload().toByteArray();
    }

    public String toString() {
        byte[] payload = this.getPayload();
        return "region=" + Bytes.toStringBinary((byte[])this.getRegionName()) + ", state=" + (Object)((Object)this.getEventType()) + ", servername=" + this.getServerName() + ", createTime=" + this.getCreateTime() + ", payload.length=" + (payload == null ? 0 : payload.length);
    }

    public static RegionTransition createRegionTransition(EventType type, byte[] regionName, ServerName sn) {
        return RegionTransition.createRegionTransition(type, regionName, sn, null);
    }

    public static RegionTransition createRegionTransition(EventType type, byte[] regionName, ServerName sn, byte[] payload) {
        HBaseProtos.ServerName pbsn = HBaseProtos.ServerName.newBuilder().setHostName(sn.getHostname()).setPort(sn.getPort()).setStartCode(sn.getStartcode()).build();
        ZooKeeperProtos.RegionTransition.Builder builder = ZooKeeperProtos.RegionTransition.newBuilder().setEventTypeCode(type.getCode()).setRegionName(ByteStringer.wrap((byte[])regionName)).setServerName(pbsn);
        builder.setCreateTime(System.currentTimeMillis());
        if (payload != null) {
            builder.setPayload(ByteStringer.wrap((byte[])payload));
        }
        return new RegionTransition(builder.build());
    }

    public static RegionTransition parseFrom(byte[] data) throws DeserializationException {
        ProtobufUtil.expectPBMagicPrefix(data);
        try {
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            ZooKeeperProtos.RegionTransition rt = ((ZooKeeperProtos.RegionTransition.Builder)ZooKeeperProtos.RegionTransition.newBuilder().mergeFrom(data, prefixLen, data.length - prefixLen)).build();
            return new RegionTransition(rt);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(this.rt.toByteArray());
    }
}

