/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ServerLoad {
    private int stores = 0;
    private int storefiles = 0;
    private int storeUncompressedSizeMB = 0;
    private int storefileSizeMB = 0;
    private int memstoreSizeMB = 0;
    private int storefileIndexSizeMB = 0;
    private int readRequestsCount = 0;
    private int writeRequestsCount = 0;
    private int rootIndexSizeKB = 0;
    private int totalStaticIndexSizeKB = 0;
    private int totalStaticBloomSizeKB = 0;
    private long totalCompactingKVs = 0L;
    private long currentCompactedKVs = 0L;
    protected ClusterStatusProtos.ServerLoad serverLoad;
    public static final ServerLoad EMPTY_SERVERLOAD = new ServerLoad(ClusterStatusProtos.ServerLoad.newBuilder().build());

    public ServerLoad(ClusterStatusProtos.ServerLoad serverLoad) {
        this.serverLoad = serverLoad;
        for (ClusterStatusProtos.RegionLoad rl : serverLoad.getRegionLoadsList()) {
            this.stores += rl.getStores();
            this.storefiles += rl.getStorefiles();
            this.storeUncompressedSizeMB += rl.getStoreUncompressedSizeMB();
            this.storefileSizeMB += rl.getStorefileSizeMB();
            this.memstoreSizeMB += rl.getMemstoreSizeMB();
            this.storefileIndexSizeMB += rl.getStorefileIndexSizeMB();
            this.readRequestsCount = (int)((long)this.readRequestsCount + rl.getReadRequestsCount());
            this.writeRequestsCount = (int)((long)this.writeRequestsCount + rl.getWriteRequestsCount());
            this.rootIndexSizeKB += rl.getRootIndexSizeKB();
            this.totalStaticIndexSizeKB += rl.getTotalStaticIndexSizeKB();
            this.totalStaticBloomSizeKB += rl.getTotalStaticBloomSizeKB();
            this.totalCompactingKVs += rl.getTotalCompactingKVs();
            this.currentCompactedKVs += rl.getCurrentCompactedKVs();
        }
    }

    public ClusterStatusProtos.ServerLoad obtainServerLoadPB() {
        return this.serverLoad;
    }

    public int getNumberOfRequests() {
        return this.serverLoad.getNumberOfRequests();
    }

    public boolean hasNumberOfRequests() {
        return this.serverLoad.hasNumberOfRequests();
    }

    public int getTotalNumberOfRequests() {
        return this.serverLoad.getTotalNumberOfRequests();
    }

    public boolean hasTotalNumberOfRequests() {
        return this.serverLoad.hasTotalNumberOfRequests();
    }

    public int getUsedHeapMB() {
        return this.serverLoad.getUsedHeapMB();
    }

    public boolean hasUsedHeapMB() {
        return this.serverLoad.hasUsedHeapMB();
    }

    public int getMaxHeapMB() {
        return this.serverLoad.getMaxHeapMB();
    }

    public boolean hasMaxHeapMB() {
        return this.serverLoad.hasMaxHeapMB();
    }

    public int getStores() {
        return this.stores;
    }

    public int getStorefiles() {
        return this.storefiles;
    }

    public int getStoreUncompressedSizeMB() {
        return this.storeUncompressedSizeMB;
    }

    public int getStorefileSizeInMB() {
        return this.storefileSizeMB;
    }

    public int getMemstoreSizeInMB() {
        return this.memstoreSizeMB;
    }

    public int getStorefileIndexSizeInMB() {
        return this.storefileIndexSizeMB;
    }

    public int getReadRequestsCount() {
        return this.readRequestsCount;
    }

    public int getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    public int getRootIndexSizeKB() {
        return this.rootIndexSizeKB;
    }

    public int getTotalStaticIndexSizeKB() {
        return this.totalStaticIndexSizeKB;
    }

    public int getTotalStaticBloomSizeKB() {
        return this.totalStaticBloomSizeKB;
    }

    public long getTotalCompactingKVs() {
        return this.totalCompactingKVs;
    }

    public long getCurrentCompactedKVs() {
        return this.currentCompactedKVs;
    }

    public int getNumberOfRegions() {
        return this.serverLoad.getRegionLoadsCount();
    }

    public int getInfoServerPort() {
        return this.serverLoad.getInfoServerPort();
    }

    public int getLoad() {
        return this.getNumberOfRegions();
    }

    public Map<byte[], RegionLoad> getRegionsLoad() {
        TreeMap<byte[], RegionLoad> regionLoads = new TreeMap<byte[], RegionLoad>(Bytes.BYTES_COMPARATOR);
        for (ClusterStatusProtos.RegionLoad rl : this.serverLoad.getRegionLoadsList()) {
            RegionLoad regionLoad = new RegionLoad(rl);
            regionLoads.put(regionLoad.getName(), regionLoad);
        }
        return regionLoads;
    }

    public String[] getRegionServerCoprocessors() {
        List list = this.obtainServerLoadPB().getCoprocessorsList();
        String[] ret = new String[list.size()];
        int i = 0;
        for (HBaseProtos.Coprocessor elem : list) {
            ret[i++] = elem.getName();
        }
        return ret;
    }

    public String[] getRsCoprocessors() {
        TreeSet<String> coprocessSet = new TreeSet<String>();
        for (HBaseProtos.Coprocessor coprocessor : this.obtainServerLoadPB().getCoprocessorsList()) {
            coprocessSet.add(coprocessor.getName());
        }
        return coprocessSet.toArray(new String[coprocessSet.size()]);
    }

    public double getRequestsPerSecond() {
        return this.getNumberOfRequests();
    }

    public String toString() {
        StringBuilder sb = Strings.appendKeyValue((StringBuilder)new StringBuilder(), (String)"requestsPerSecond", (Object)this.getRequestsPerSecond());
        Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfOnlineRegions", (Object)this.getNumberOfRegions());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"usedHeapMB", (Object)this.getUsedHeapMB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"maxHeapMB", (Object)this.getMaxHeapMB());
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfStores", (Object)this.stores);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"numberOfStorefiles", (Object)this.storefiles);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"storefileUncompressedSizeMB", (Object)this.storeUncompressedSizeMB);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"storefileSizeMB", (Object)this.storefileSizeMB);
        if (this.storeUncompressedSizeMB != 0) {
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"compressionRatio", (Object)String.format("%.4f", Float.valueOf((float)this.storefileSizeMB / (float)this.storeUncompressedSizeMB)));
        }
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"memstoreSizeMB", (Object)this.memstoreSizeMB);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"storefileIndexSizeMB", (Object)this.storefileIndexSizeMB);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"readRequestsCount", (Object)this.readRequestsCount);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"writeRequestsCount", (Object)this.writeRequestsCount);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"rootIndexSizeKB", (Object)this.rootIndexSizeKB);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"totalStaticIndexSizeKB", (Object)this.totalStaticIndexSizeKB);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"totalStaticBloomSizeKB", (Object)this.totalStaticBloomSizeKB);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"totalCompactingKVs", (Object)this.totalCompactingKVs);
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"currentCompactedKVs", (Object)this.currentCompactedKVs);
        float compactionProgressPct = Float.NaN;
        if (this.totalCompactingKVs > 0L) {
            compactionProgressPct = Float.valueOf((float)this.currentCompactedKVs / (float)this.totalCompactingKVs).floatValue();
        }
        sb = Strings.appendKeyValue((StringBuilder)sb, (String)"compactionProgressPct", (Object)Float.valueOf(compactionProgressPct));
        Object[] coprocessorStrings = this.getRsCoprocessors();
        if (coprocessorStrings != null) {
            sb = Strings.appendKeyValue((StringBuilder)sb, (String)"coprocessors", (Object)Arrays.toString(coprocessorStrings));
        }
        return sb.toString();
    }
}

