/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Result
implements CellScannable,
CellScanner {
    private Cell[] cells;
    private Boolean exists;
    private transient byte[] row = null;
    private transient NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> familyMap = null;
    private static byte[] buffer = null;
    private static final int PAD_WIDTH = 128;
    public static final Result EMPTY_RESULT = new Result();
    private static final int INITIAL_CELLSCANNER_INDEX = -1;
    private int cellScannerIndex = -1;

    public Result() {
    }

    @Deprecated
    public Result(KeyValue[] cells) {
        this.cells = cells;
    }

    @Deprecated
    public Result(List<KeyValue> kvs) {
        this(kvs.toArray(new Cell[kvs.size()]), null);
    }

    public static Result create(List<Cell> cells) {
        return new Result(cells.toArray(new Cell[cells.size()]), null);
    }

    public static Result create(List<Cell> cells, Boolean exists) {
        if (exists != null) {
            return new Result(null, exists);
        }
        return new Result(cells.toArray(new Cell[cells.size()]), null);
    }

    public static Result create(Cell[] cells) {
        return new Result(cells, null);
    }

    private Result(Cell[] cells, Boolean exists) {
        this.cells = cells;
        this.exists = exists;
    }

    public byte[] getRow() {
        if (this.row == null) {
            this.row = this.cells == null || this.cells.length == 0 ? null : CellUtil.cloneRow((Cell)this.cells[0]);
        }
        return this.row;
    }

    public Cell[] rawCells() {
        return this.cells;
    }

    @Deprecated
    public KeyValue[] raw() {
        KeyValue[] kvs = new KeyValue[this.cells.length];
        for (int i = 0; i < kvs.length; ++i) {
            kvs[i] = KeyValueUtil.ensureKeyValue((Cell)this.cells[i]);
        }
        return kvs;
    }

    public List<Cell> listCells() {
        return this.isEmpty() ? null : Arrays.asList(this.rawCells());
    }

    @Deprecated
    public List<KeyValue> list() {
        return this.isEmpty() ? null : Arrays.asList(this.raw());
    }

    @Deprecated
    public List<KeyValue> getColumn(byte[] family, byte[] qualifier) {
        return KeyValueUtil.ensureKeyValues(this.getColumnCells(family, qualifier));
    }

    public List<Cell> getColumnCells(byte[] family, byte[] qualifier) {
        KeyValue kv;
        ArrayList<Cell> result = new ArrayList<Cell>();
        Cell[] kvs = this.rawCells();
        if (kvs == null || kvs.length == 0) {
            return result;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return result;
        }
        for (int i = pos; i < kvs.length && (kv = KeyValueUtil.ensureKeyValue((Cell)kvs[i])).matchingColumn(family, qualifier); ++i) {
            result.add((Cell)kv);
        }
        return result;
    }

    protected int binarySearch(Cell[] kvs, byte[] family, byte[] qualifier) {
        KeyValue searchTerm = KeyValue.createFirstOnRow((byte[])CellUtil.cloneRow((Cell)kvs[0]), (byte[])family, (byte[])qualifier);
        int pos = Arrays.binarySearch(kvs, searchTerm, KeyValue.COMPARATOR);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    protected int binarySearch(Cell[] kvs, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue searchTerm;
        int pos;
        double keyValueSize = KeyValue.getKeyValueDataStructureSize((int)kvs[0].getRowLength(), (int)flength, (int)qlength, (int)0);
        if (buffer == null || keyValueSize > (double)buffer.length) {
            buffer = new byte[(int)Math.ceil(keyValueSize / 128.0) * 128];
        }
        if ((pos = Arrays.binarySearch(kvs, searchTerm = KeyValue.createFirstOnRow((byte[])buffer, (int)0, (byte[])kvs[0].getRowArray(), (int)kvs[0].getRowOffset(), (int)kvs[0].getRowLength(), (byte[])family, (int)foffset, (int)flength, (byte[])qualifier, (int)qoffset, (int)qlength), KeyValue.COMPARATOR)) < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return -1;
        }
        return pos;
    }

    @Deprecated
    public KeyValue getColumnLatest(byte[] family, byte[] qualifier) {
        return KeyValueUtil.ensureKeyValue((Cell)this.getColumnLatestCell(family, qualifier));
    }

    public Cell getColumnLatestCell(byte[] family, byte[] qualifier) {
        Cell[] kvs = this.rawCells();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, qualifier);
        if (pos == -1) {
            return null;
        }
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)kvs[pos]);
        if (kv.matchingColumn(family, qualifier)) {
            return kv;
        }
        return null;
    }

    @Deprecated
    public KeyValue getColumnLatest(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return KeyValueUtil.ensureKeyValue((Cell)this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength));
    }

    public Cell getColumnLatestCell(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell[] kvs = this.rawCells();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = this.binarySearch(kvs, family, foffset, flength, qualifier, qoffset, qlength);
        if (pos == -1) {
            return null;
        }
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)kvs[pos]);
        if (kv.matchingColumn(family, foffset, flength, qualifier, qoffset, qlength)) {
            return kv;
        }
        return null;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        Cell kv = this.getColumnLatestCell(family, qualifier);
        if (kv == null) {
            return null;
        }
        return CellUtil.cloneValue((Cell)kv);
    }

    public ByteBuffer getValueAsByteBuffer(byte[] family, byte[] qualifier) {
        Cell kv = this.getColumnLatestCell(family, 0, family.length, qualifier, 0, qualifier.length);
        if (kv == null) {
            return null;
        }
        return ByteBuffer.wrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
    }

    public ByteBuffer getValueAsByteBuffer(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        if (kv == null) {
            return null;
        }
        return ByteBuffer.wrap(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
    }

    public boolean loadValue(byte[] family, byte[] qualifier, ByteBuffer dst) throws BufferOverflowException {
        return this.loadValue(family, 0, family.length, qualifier, 0, qualifier.length, dst);
    }

    public boolean loadValue(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength, ByteBuffer dst) throws BufferOverflowException {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        if (kv == null) {
            return false;
        }
        dst.put(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
        return true;
    }

    public boolean containsNonEmptyColumn(byte[] family, byte[] qualifier) {
        return this.containsNonEmptyColumn(family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public boolean containsNonEmptyColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        return kv != null && kv.getValueLength() > 0;
    }

    public boolean containsEmptyColumn(byte[] family, byte[] qualifier) {
        return this.containsEmptyColumn(family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public boolean containsEmptyColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        Cell kv = this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength);
        return kv != null && kv.getValueLength() == 0;
    }

    public boolean containsColumn(byte[] family, byte[] qualifier) {
        Cell kv = this.getColumnLatestCell(family, qualifier);
        return kv != null;
    }

    public boolean containsColumn(byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return this.getColumnLatestCell(family, foffset, flength, qualifier, qoffset, qlength) != null;
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
        if (this.familyMap != null) {
            return this.familyMap;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.familyMap = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (Cell kv : this.cells) {
            byte[] qualifier;
            TreeMap<Long, byte[]> versionMap;
            byte[] family = CellUtil.cloneFamily((Cell)kv);
            TreeMap columnMap = (TreeMap)this.familyMap.get(family);
            if (columnMap == null) {
                columnMap = new TreeMap(Bytes.BYTES_COMPARATOR);
                this.familyMap.put(family, columnMap);
            }
            if ((versionMap = (TreeMap<Long, byte[]>)columnMap.get(qualifier = CellUtil.cloneQualifier((Cell)kv))) == null) {
                versionMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

                    @Override
                    public int compare(Long l1, Long l2) {
                        return l2.compareTo(l1);
                    }
                });
                columnMap.put(qualifier, versionMap);
            }
            Long timestamp = kv.getTimestamp();
            byte[] value = CellUtil.cloneValue((Cell)kv);
            versionMap.put(timestamp, value);
        }
        return this.familyMap;
    }

    public NavigableMap<byte[], NavigableMap<byte[], byte[]>> getNoVersionMap() {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], NavigableMap<byte[], byte[]>> returnMap = new TreeMap<byte[], NavigableMap<byte[], byte[]>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry familyEntry : this.familyMap.entrySet()) {
            TreeMap qualifierMap = new TreeMap(Bytes.BYTES_COMPARATOR);
            for (Map.Entry qualifierEntry : ((NavigableMap)familyEntry.getValue()).entrySet()) {
                byte[] value = (byte[])((NavigableMap)qualifierEntry.getValue()).get(((NavigableMap)qualifierEntry.getValue()).firstKey());
                qualifierMap.put(qualifierEntry.getKey(), value);
            }
            returnMap.put((byte[])familyEntry.getKey(), qualifierMap);
        }
        return returnMap;
    }

    public NavigableMap<byte[], byte[]> getFamilyMap(byte[] family) {
        if (this.familyMap == null) {
            this.getMap();
        }
        if (this.isEmpty()) {
            return null;
        }
        TreeMap<byte[], byte[]> returnMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
        NavigableMap qualifierMap = (NavigableMap)this.familyMap.get(family);
        if (qualifierMap == null) {
            return returnMap;
        }
        for (Map.Entry entry : qualifierMap.entrySet()) {
            byte[] value = (byte[])((NavigableMap)entry.getValue()).get(((NavigableMap)entry.getValue()).firstKey());
            returnMap.put((byte[])entry.getKey(), value);
        }
        return returnMap;
    }

    public byte[] value() {
        if (this.isEmpty()) {
            return null;
        }
        return CellUtil.cloneValue((Cell)this.cells[0]);
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int size() {
        return this.cells == null ? 0 : this.cells.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("keyvalues=");
        if (this.isEmpty()) {
            sb.append("NONE");
            return sb.toString();
        }
        sb.append("{");
        boolean moreThanOne = false;
        for (Cell kv : this.cells) {
            if (moreThanOne) {
                sb.append(", ");
            } else {
                moreThanOne = true;
            }
            sb.append(kv.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static void compareResults(Result res1, Result res2) throws Exception {
        if (res2 == null) {
            throw new Exception("There wasn't enough rows, we stopped at " + Bytes.toStringBinary((byte[])res1.getRow()));
        }
        if (res1.size() != res2.size()) {
            throw new Exception("This row doesn't have the same number of KVs: " + res1.toString() + " compared to " + res2.toString());
        }
        Cell[] ourKVs = res1.rawCells();
        Cell[] replicatedKVs = res2.rawCells();
        for (int i = 0; i < res1.size(); ++i) {
            if (ourKVs[i].equals(replicatedKVs[i]) && Bytes.equals((byte[])CellUtil.cloneValue((Cell)ourKVs[i]), (byte[])CellUtil.cloneValue((Cell)replicatedKVs[i]))) continue;
            throw new Exception("This result was different: " + res1.toString() + " compared to " + res2.toString());
        }
    }

    public void copyFrom(Result other) {
        this.row = null;
        this.familyMap = null;
        this.cells = other.cells;
    }

    public CellScanner cellScanner() {
        this.cellScannerIndex = -1;
        return this;
    }

    public Cell current() {
        if (this.cells == null) {
            return null;
        }
        return this.cellScannerIndex < 0 ? null : this.cells[this.cellScannerIndex];
    }

    public boolean advance() {
        if (this.cells == null) {
            return false;
        }
        return ++this.cellScannerIndex < this.cells.length;
    }

    public Boolean getExists() {
        return this.exists;
    }

    public void setExists(Boolean exists) {
        this.exists = exists;
    }
}

