/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.util.ReflectionUtils;

public class RpcRetryingCallerFactory {
    public static final String CUSTOM_CALLER_CONF_KEY = "hbase.rpc.callerfactory.class";
    protected final Configuration conf;
    private final long pause;
    private final int retries;
    private final int startLogErrorsCnt;

    public RpcRetryingCallerFactory(Configuration conf) {
        this.conf = conf;
        this.pause = conf.getLong(HConstants.HBASE_CLIENT_PAUSE, HConstants.DEFAULT_HBASE_CLIENT_PAUSE);
        this.retries = conf.getInt(HConstants.HBASE_CLIENT_RETRIES_NUMBER, HConstants.DEFAULT_HBASE_CLIENT_RETRIES_NUMBER);
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 9);
    }

    public <T> RpcRetryingCaller<T> newCaller() {
        return new RpcRetryingCaller(this.pause, this.retries, this.startLogErrorsCnt);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration) {
        String clazzName = RpcRetryingCallerFactory.class.getName();
        String rpcCallerFactoryClazz = configuration.get(CUSTOM_CALLER_CONF_KEY, clazzName);
        if (rpcCallerFactoryClazz.equals(clazzName)) {
            return new RpcRetryingCallerFactory(configuration);
        }
        return (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcCallerFactoryClazz, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{configuration});
    }
}

