/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;

@InterfaceAudience.Private
public class RegionState {
    private final AtomicLong stamp;
    private HRegionInfo hri;
    private volatile ServerName serverName;
    private volatile State state;

    public RegionState() {
        this.stamp = new AtomicLong(System.currentTimeMillis());
    }

    public RegionState(HRegionInfo region, State state) {
        this(region, state, System.currentTimeMillis(), null);
    }

    public RegionState(HRegionInfo region, State state, ServerName serverName) {
        this(region, state, System.currentTimeMillis(), serverName);
    }

    public RegionState(HRegionInfo region, State state, long stamp, ServerName serverName) {
        this.hri = region;
        this.state = state;
        this.stamp = new AtomicLong(stamp);
        this.serverName = serverName;
    }

    public void updateTimestampToNow() {
        this.setTimestamp(System.currentTimeMillis());
    }

    public State getState() {
        return this.state;
    }

    public long getStamp() {
        return this.stamp.get();
    }

    public HRegionInfo getRegion() {
        return this.hri;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    public boolean isClosing() {
        return this.state == State.CLOSING;
    }

    public boolean isClosed() {
        return this.state == State.CLOSED;
    }

    public boolean isPendingClose() {
        return this.state == State.PENDING_CLOSE;
    }

    public boolean isOpening() {
        return this.state == State.OPENING;
    }

    public boolean isOpened() {
        return this.state == State.OPEN;
    }

    public boolean isPendingOpen() {
        return this.state == State.PENDING_OPEN;
    }

    public boolean isOffline() {
        return this.state == State.OFFLINE;
    }

    public boolean isSplitting() {
        return this.state == State.SPLITTING;
    }

    public boolean isSplit() {
        return this.state == State.SPLIT;
    }

    public boolean isSplittingNew() {
        return this.state == State.SPLITTING_NEW;
    }

    public boolean isFailedOpen() {
        return this.state == State.FAILED_OPEN;
    }

    public boolean isFailedClose() {
        return this.state == State.FAILED_CLOSE;
    }

    public boolean isMerging() {
        return this.state == State.MERGING;
    }

    public boolean isMerged() {
        return this.state == State.MERGED;
    }

    public boolean isMergingNew() {
        return this.state == State.MERGING_NEW;
    }

    public boolean isOpenOrMergingOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isOpened() || this.isMerging());
    }

    public boolean isOpenOrMergingNewOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isOpened() || this.isMergingNew());
    }

    public boolean isOpenOrSplittingOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isOpened() || this.isSplitting());
    }

    public boolean isOpenOrSplittingNewOnServer(ServerName sn) {
        return this.isOnServer(sn) && (this.isOpened() || this.isSplittingNew());
    }

    public boolean isPendingOpenOrOpeningOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isPendingOpenOrOpening();
    }

    public boolean isPendingOpenOrOpening() {
        return this.isPendingOpen() || this.isOpening() || this.isFailedOpen();
    }

    public boolean isPendingCloseOrClosingOnServer(ServerName sn) {
        return this.isOnServer(sn) && this.isPendingCloseOrClosing();
    }

    public boolean isPendingCloseOrClosing() {
        return this.isPendingClose() || this.isClosing() || this.isFailedClose();
    }

    public boolean isOnServer(ServerName sn) {
        return this.serverName != null && this.serverName.equals(sn);
    }

    public boolean isReadyToOffline() {
        return this.isMerged() || this.isSplit() || this.isOffline() || this.isSplittingNew() || this.isMergingNew();
    }

    public boolean isReadyToOnline() {
        return this.isOpened() || this.isSplittingNew() || this.isMergingNew();
    }

    public boolean isUnassignable() {
        return RegionState.isUnassignable(this.state);
    }

    public static boolean isUnassignable(State state) {
        return state == State.MERGED || state == State.SPLIT || state == State.OFFLINE || state == State.SPLITTING_NEW || state == State.MERGING_NEW;
    }

    public String toString() {
        return "{" + this.hri.getShortNameToLog() + " state=" + (Object)((Object)this.state) + ", ts=" + this.stamp + ", server=" + this.serverName + "}";
    }

    public String toDescriptiveString() {
        long lstamp = this.stamp.get();
        long relTime = System.currentTimeMillis() - lstamp;
        return this.hri.getRegionNameAsString() + " state=" + (Object)((Object)this.state) + ", ts=" + new Date(lstamp) + " (" + relTime / 1000L + "s ago)" + ", server=" + this.serverName;
    }

    public ClusterStatusProtos.RegionState convert() {
        ClusterStatusProtos.RegionState.State rs;
        ClusterStatusProtos.RegionState.Builder regionState = ClusterStatusProtos.RegionState.newBuilder();
        switch (this.state) {
            case OFFLINE: {
                rs = ClusterStatusProtos.RegionState.State.OFFLINE;
                break;
            }
            case PENDING_OPEN: {
                rs = ClusterStatusProtos.RegionState.State.PENDING_OPEN;
                break;
            }
            case OPENING: {
                rs = ClusterStatusProtos.RegionState.State.OPENING;
                break;
            }
            case OPEN: {
                rs = ClusterStatusProtos.RegionState.State.OPEN;
                break;
            }
            case PENDING_CLOSE: {
                rs = ClusterStatusProtos.RegionState.State.PENDING_CLOSE;
                break;
            }
            case CLOSING: {
                rs = ClusterStatusProtos.RegionState.State.CLOSING;
                break;
            }
            case CLOSED: {
                rs = ClusterStatusProtos.RegionState.State.CLOSED;
                break;
            }
            case SPLITTING: {
                rs = ClusterStatusProtos.RegionState.State.SPLITTING;
                break;
            }
            case SPLIT: {
                rs = ClusterStatusProtos.RegionState.State.SPLIT;
                break;
            }
            case FAILED_OPEN: {
                rs = ClusterStatusProtos.RegionState.State.FAILED_OPEN;
                break;
            }
            case FAILED_CLOSE: {
                rs = ClusterStatusProtos.RegionState.State.FAILED_CLOSE;
                break;
            }
            case MERGING: {
                rs = ClusterStatusProtos.RegionState.State.MERGING;
                break;
            }
            case MERGED: {
                rs = ClusterStatusProtos.RegionState.State.MERGED;
                break;
            }
            case SPLITTING_NEW: {
                rs = ClusterStatusProtos.RegionState.State.SPLITTING_NEW;
                break;
            }
            case MERGING_NEW: {
                rs = ClusterStatusProtos.RegionState.State.MERGING_NEW;
                break;
            }
            default: {
                throw new IllegalStateException("");
            }
        }
        regionState.setRegionInfo(HRegionInfo.convert(this.hri));
        regionState.setState(rs);
        regionState.setStamp(this.getStamp());
        return regionState.build();
    }

    public static RegionState convert(ClusterStatusProtos.RegionState proto) {
        State state;
        switch (proto.getState()) {
            case OFFLINE: {
                state = State.OFFLINE;
                break;
            }
            case PENDING_OPEN: {
                state = State.PENDING_OPEN;
                break;
            }
            case OPENING: {
                state = State.OPENING;
                break;
            }
            case OPEN: {
                state = State.OPEN;
                break;
            }
            case PENDING_CLOSE: {
                state = State.PENDING_CLOSE;
                break;
            }
            case CLOSING: {
                state = State.CLOSING;
                break;
            }
            case CLOSED: {
                state = State.CLOSED;
                break;
            }
            case SPLITTING: {
                state = State.SPLITTING;
                break;
            }
            case SPLIT: {
                state = State.SPLIT;
                break;
            }
            case FAILED_OPEN: {
                state = State.FAILED_OPEN;
                break;
            }
            case FAILED_CLOSE: {
                state = State.FAILED_CLOSE;
                break;
            }
            case MERGING: {
                state = State.MERGING;
                break;
            }
            case MERGED: {
                state = State.MERGED;
                break;
            }
            case SPLITTING_NEW: {
                state = State.SPLITTING_NEW;
                break;
            }
            case MERGING_NEW: {
                state = State.MERGING_NEW;
                break;
            }
            default: {
                throw new IllegalStateException("");
            }
        }
        return new RegionState(HRegionInfo.convert(proto.getRegionInfo()), state, proto.getStamp(), null);
    }

    protected void setTimestamp(long timestamp) {
        this.stamp.set(timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegionState tmp = (RegionState)obj;
        return tmp.hri.equals(this.hri) && tmp.state == this.state && (this.serverName != null && this.serverName.equals(tmp.serverName) || tmp.serverName == null && this.serverName == null);
    }

    public int hashCode() {
        return (this.serverName != null ? this.serverName.hashCode() * 11 : 0) + this.hri.hashCode() + 5 * this.state.ordinal();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static enum State {
        OFFLINE,
        PENDING_OPEN,
        OPENING,
        OPEN,
        PENDING_CLOSE,
        CLOSING,
        CLOSED,
        SPLITTING,
        SPLIT,
        FAILED_OPEN,
        FAILED_CLOSE,
        MERGING,
        MERGED,
        SPLITTING_NEW,
        MERGING_NEW;

    }
}

