/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.util.ReflectionUtils;

@InterfaceAudience.Private
public class RpcRetryingCallerFactory {
    public static final String CUSTOM_CALLER_CONF_KEY = "hbase.rpc.callerfactory.class";
    protected final Configuration conf;
    private final long pause;
    private final int retries;
    private final RetryingCallerInterceptor interceptor;
    private final int startLogErrorsCnt;

    public RpcRetryingCallerFactory(Configuration conf) {
        this(conf, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR);
    }

    public RpcRetryingCallerFactory(Configuration conf, RetryingCallerInterceptor interceptor) {
        this.conf = conf;
        this.pause = conf.getLong("hbase.client.pause", 100L);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.startLogErrorsCnt = conf.getInt("hbase.client.start.log.errors.counter", 9);
        this.interceptor = interceptor;
    }

    public <T> RpcRetryingCaller<T> newCaller() {
        return new RpcRetryingCaller(this.pause, this.retries, this.interceptor, this.startLogErrorsCnt);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration) {
        return RpcRetryingCallerFactory.instantiate(configuration, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR);
    }

    public static RpcRetryingCallerFactory instantiate(Configuration configuration, RetryingCallerInterceptor interceptor) {
        String clazzName = RpcRetryingCallerFactory.class.getName();
        String rpcCallerFactoryClazz = configuration.get(CUSTOM_CALLER_CONF_KEY, clazzName);
        if (rpcCallerFactoryClazz.equals(clazzName)) {
            return new RpcRetryingCallerFactory(configuration, interceptor);
        }
        return (RpcRetryingCallerFactory)ReflectionUtils.instantiateWithCustomCtor((String)rpcCallerFactoryClazz, (Class[])new Class[]{Configuration.class}, (Object[])new Object[]{configuration});
    }
}

