/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class Scan
extends Query {
    private static final Log LOG = LogFactory.getLog(Scan.class);
    private static final String RAW_ATTR = "_raw_";
    public static final String HINT_LOOKAHEAD = "_look_ahead_";
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private byte[] stopRow = HConstants.EMPTY_END_ROW;
    private int maxVersions = 1;
    private int batch = -1;
    private int storeLimit = -1;
    private int storeOffset = 0;
    private boolean getScan;
    public static final String SCAN_ATTRIBUTES_METRICS_ENABLE = "scan.attributes.metrics.enable";
    public static final String SCAN_ATTRIBUTES_METRICS_DATA = "scan.attributes.metrics.data";
    public static final String SCAN_ATTRIBUTES_TABLE_NAME = "scan.attributes.table.name";
    private int caching = -1;
    private long maxResultSize = -1L;
    private boolean cacheBlocks = true;
    private boolean reversed = false;
    private TimeRange tr = new TimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    private Boolean loadColumnFamiliesOnDemand = null;
    private boolean small = false;

    public Scan() {
    }

    public Scan(byte[] startRow, Filter filter) {
        this(startRow);
        this.filter = filter;
    }

    public Scan(byte[] startRow) {
        this.startRow = startRow;
    }

    public Scan(byte[] startRow, byte[] stopRow) {
        this.startRow = startRow;
        this.stopRow = stopRow;
        this.getScan = this.isStartRowAndEqualsStopRow();
    }

    public Scan(Scan scan) throws IOException {
        this.startRow = scan.getStartRow();
        this.stopRow = scan.getStopRow();
        this.maxVersions = scan.getMaxVersions();
        this.batch = scan.getBatch();
        this.storeLimit = scan.getMaxResultsPerColumnFamily();
        this.storeOffset = scan.getRowOffsetPerColumnFamily();
        this.caching = scan.getCaching();
        this.maxResultSize = scan.getMaxResultSize();
        this.cacheBlocks = scan.getCacheBlocks();
        this.getScan = scan.isGetScan();
        this.filter = scan.getFilter();
        this.loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue();
        this.consistency = scan.getConsistency();
        this.reversed = scan.isReversed();
        this.small = scan.isSmall();
        TimeRange ctr = scan.getTimeRange();
        this.tr = new TimeRange(ctr.getMin(), ctr.getMax());
        Map<byte[], NavigableSet<byte[]>> fams = scan.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : scan.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
    }

    public Scan(Get get) {
        this.startRow = get.getRow();
        this.stopRow = get.getRow();
        this.filter = get.getFilter();
        this.cacheBlocks = get.getCacheBlocks();
        this.maxVersions = get.getMaxVersions();
        this.storeLimit = get.getMaxResultsPerColumnFamily();
        this.storeOffset = get.getRowOffsetPerColumnFamily();
        this.tr = get.getTimeRange();
        this.familyMap = get.getFamilyMap();
        this.getScan = true;
        this.consistency = get.getConsistency();
        for (Map.Entry<String, byte[]> attr : get.getAttributesMap().entrySet()) {
            this.setAttribute(attr.getKey(), attr.getValue());
        }
    }

    public boolean isGetScan() {
        return this.getScan || this.isStartRowAndEqualsStopRow();
    }

    private boolean isStartRowAndEqualsStopRow() {
        return this.startRow != null && this.startRow.length > 0 && Bytes.equals((byte[])this.startRow, (byte[])this.stopRow);
    }

    public Scan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Scan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public Scan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    public Scan setTimeStamp(long timestamp) throws IOException {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException e) {
            LOG.error((Object)"TimeRange failed, likely caused by integer overflow. ", (Throwable)e);
            throw e;
        }
        return this;
    }

    public Scan setStartRow(byte[] startRow) {
        this.startRow = startRow;
        return this;
    }

    public Scan setStopRow(byte[] stopRow) {
        this.stopRow = stopRow;
        return this;
    }

    public Scan setRowPrefixFilter(byte[] rowPrefix) {
        if (rowPrefix == null) {
            this.setStartRow(HConstants.EMPTY_START_ROW);
            this.setStopRow(HConstants.EMPTY_END_ROW);
        } else {
            this.setStartRow(rowPrefix);
            this.setStopRow(this.calculateTheClosestNextRowKeyForPrefix(rowPrefix));
        }
        return this;
    }

    private byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    public Scan setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Scan setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    public Scan setBatch(int batch) {
        if (this.hasFilter() && this.filter.hasFilterRow()) {
            throw new IncompatibleFilterException("Cannot set batch on a scan using a filter that returns true for filter.hasFilterRow");
        }
        this.batch = batch;
        return this;
    }

    public Scan setMaxResultsPerColumnFamily(int limit) {
        this.storeLimit = limit;
        return this;
    }

    public Scan setRowOffsetPerColumnFamily(int offset) {
        this.storeOffset = offset;
        return this;
    }

    public Scan setCaching(int caching) {
        this.caching = caching;
        return this;
    }

    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    public Scan setMaxResultSize(long maxResultSize) {
        this.maxResultSize = maxResultSize;
        return this;
    }

    @Override
    public Scan setFilter(Filter filter) {
        super.setFilter(filter);
        return this;
    }

    public Scan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getMaxResultsPerColumnFamily() {
        return this.storeLimit;
    }

    public int getRowOffsetPerColumnFamily() {
        return this.storeOffset;
    }

    public int getCaching() {
        return this.caching;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public Scan setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public Scan setReversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Scan setLoadColumnFamiliesOnDemand(boolean value) {
        this.loadColumnFamiliesOnDemand = value;
        return this;
    }

    public Boolean getLoadColumnFamiliesOnDemandValue() {
        return this.loadColumnFamiliesOnDemand;
    }

    public boolean doLoadColumnFamiliesOnDemand() {
        return this.loadColumnFamiliesOnDemand != null && this.loadColumnFamiliesOnDemand != false;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        if (this.familyMap.size() == 0) {
            map.put("families", "ALL");
            return map;
        }
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap familyColumns = new HashMap();
        map.put("families", familyColumns);
        map.put("startRow", Bytes.toStringBinary((byte[])this.startRow));
        map.put("stopRow", Bytes.toStringBinary((byte[])this.stopRow));
        map.put("maxVersions", this.maxVersions);
        map.put("batch", this.batch);
        map.put("caching", this.caching);
        map.put("maxResultSize", this.maxResultSize);
        map.put("cacheBlocks", this.cacheBlocks);
        map.put("loadColumnFamiliesOnDemand", this.loadColumnFamiliesOnDemand);
        ArrayList<Long> timeRange = new ArrayList<Long>();
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> columns = new ArrayList<String>();
            familyColumns.put(Bytes.toStringBinary((byte[])entry.getKey()), columns);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                columns.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                columns.add(Bytes.toStringBinary((byte[])column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    public Scan setRaw(boolean raw) {
        this.setAttribute(RAW_ATTR, Bytes.toBytes((boolean)raw));
        return this;
    }

    public boolean isRaw() {
        byte[] attr = this.getAttribute(RAW_ATTR);
        return attr == null ? false : Bytes.toBoolean((byte[])attr);
    }

    public Scan setSmall(boolean small) {
        this.small = small;
        return this;
    }

    public boolean isSmall() {
        return this.small;
    }

    @Override
    public Scan setAttribute(String name, byte[] value) {
        return (Scan)super.setAttribute(name, value);
    }

    @Override
    public Scan setId(String id) {
        return (Scan)super.setId(id);
    }

    @Override
    public Scan setAuthorizations(Authorizations authorizations) {
        return (Scan)super.setAuthorizations(authorizations);
    }

    @Override
    public Scan setACL(Map<String, Permission> perms) {
        return (Scan)super.setACL(perms);
    }

    @Override
    public Scan setACL(String user, Permission perms) {
        return (Scan)super.setACL(user, perms);
    }

    @Override
    public Scan setConsistency(Consistency consistency) {
        return (Scan)super.setConsistency(consistency);
    }

    @Override
    public Scan setReplicaId(int Id) {
        return (Scan)super.setReplicaId(Id);
    }

    @Override
    public Scan setIsolationLevel(IsolationLevel level) {
        return (Scan)super.setIsolationLevel(level);
    }

    static Scan createGetClosestRowOrBeforeReverseScan(byte[] row) {
        Scan scan = new Scan(row);
        scan.setSmall(true);
        scan.setReversed(true);
        scan.setCaching(1);
        return scan;
    }
}

