/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Collection;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class RegionLocations {
    private final int numNonNullElements;
    private final HRegionLocation[] locations;

    public RegionLocations(HRegionLocation ... locations) {
        int numNonNullElements = 0;
        int maxReplicaId = -1;
        int maxReplicaIdIndex = -1;
        int index = 0;
        for (HRegionLocation loc : locations) {
            if (loc != null) {
                if (loc.getServerName() != null) {
                    ++numNonNullElements;
                }
                if (loc.getRegionInfo().getReplicaId() >= maxReplicaId) {
                    maxReplicaId = loc.getRegionInfo().getReplicaId();
                    maxReplicaIdIndex = index;
                }
            }
            ++index;
        }
        this.numNonNullElements = numNonNullElements;
        if ((maxReplicaId += locations.length - (maxReplicaIdIndex + 1)) + 1 == locations.length) {
            this.locations = locations;
        } else {
            this.locations = new HRegionLocation[maxReplicaId + 1];
            for (HRegionLocation loc : locations) {
                if (loc == null) continue;
                this.locations[loc.getRegionInfo().getReplicaId()] = loc;
            }
        }
    }

    public RegionLocations(Collection<HRegionLocation> locations) {
        this(locations.toArray(new HRegionLocation[locations.size()]));
    }

    public int size() {
        return this.locations.length;
    }

    public int numNonNullElements() {
        return this.numNonNullElements;
    }

    public boolean isEmpty() {
        return this.numNonNullElements == 0;
    }

    public RegionLocations removeByServer(ServerName serverName) {
        HRegionLocation[] newLocations = null;
        for (int i = 0; i < this.locations.length; ++i) {
            if (this.locations[i] != null && serverName.equals(this.locations[i].getServerName())) {
                if (newLocations == null) {
                    newLocations = new HRegionLocation[this.locations.length];
                    System.arraycopy(this.locations, 0, newLocations, 0, i);
                }
                newLocations[i] = null;
                continue;
            }
            if (newLocations == null) continue;
            newLocations[i] = this.locations[i];
        }
        return newLocations == null ? this : new RegionLocations(newLocations);
    }

    public RegionLocations remove(HRegionLocation location) {
        if (location == null) {
            return this;
        }
        if (location.getRegionInfo() == null) {
            return this;
        }
        int replicaId = location.getRegionInfo().getReplicaId();
        if (replicaId >= this.locations.length) {
            return this;
        }
        if (this.locations[replicaId] == null || !location.getRegionInfo().equals(this.locations[replicaId].getRegionInfo()) || !location.equals(this.locations[replicaId])) {
            return this;
        }
        HRegionLocation[] newLocations = new HRegionLocation[this.locations.length];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        newLocations[replicaId] = null;
        return new RegionLocations(newLocations);
    }

    public RegionLocations remove(int replicaId) {
        if (this.getRegionLocation(replicaId) == null) {
            return this;
        }
        HRegionLocation[] newLocations = new HRegionLocation[this.locations.length];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        if (replicaId < newLocations.length) {
            newLocations[replicaId] = null;
        }
        return new RegionLocations(newLocations);
    }

    public RegionLocations mergeLocations(RegionLocations other) {
        assert (other != null);
        HRegionLocation[] newLocations = null;
        int max = other.locations.length;
        for (int i = 0; i < max; ++i) {
            HRegionLocation otherLoc;
            HRegionLocation thisLoc = this.getRegionLocation(i);
            HRegionLocation selectedLoc = this.selectRegionLocation(thisLoc, otherLoc = other.getRegionLocation(i), true, false);
            if (selectedLoc != thisLoc && newLocations == null) {
                newLocations = new HRegionLocation[max];
                System.arraycopy(this.locations, 0, newLocations, 0, i);
            }
            if (newLocations == null) continue;
            newLocations[i] = selectedLoc;
        }
        return newLocations == null ? this : new RegionLocations(newLocations);
    }

    private HRegionLocation selectRegionLocation(HRegionLocation oldLocation, HRegionLocation location, boolean checkForEquals, boolean force) {
        if (location == null) {
            return oldLocation == null ? null : oldLocation;
        }
        if (oldLocation == null) {
            return location;
        }
        if (force || this.isGreaterThan(location.getSeqNum(), oldLocation.getSeqNum(), checkForEquals)) {
            return location;
        }
        return oldLocation;
    }

    public RegionLocations updateLocation(HRegionLocation location, boolean checkForEquals, boolean force) {
        assert (location != null);
        int replicaId = location.getRegionInfo().getReplicaId();
        HRegionLocation oldLoc = this.getRegionLocation(location.getRegionInfo().getReplicaId());
        HRegionLocation selectedLoc = this.selectRegionLocation(oldLoc, location, checkForEquals, force);
        if (selectedLoc == oldLoc) {
            return this;
        }
        HRegionLocation[] newLocations = new HRegionLocation[Math.max(this.locations.length, replicaId + 1)];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        newLocations[replicaId] = location;
        return new RegionLocations(newLocations);
    }

    private boolean isGreaterThan(long a, long b, boolean checkForEquals) {
        return a > b || checkForEquals && a == b;
    }

    public HRegionLocation getRegionLocation(int replicaId) {
        if (replicaId >= this.locations.length) {
            return null;
        }
        return this.locations[replicaId];
    }

    public HRegionLocation getRegionLocationByRegionName(byte[] regionName) {
        for (HRegionLocation loc : this.locations) {
            if (loc == null || !Bytes.equals((byte[])loc.getRegionInfo().getRegionName(), (byte[])regionName) && !Bytes.equals((byte[])loc.getRegionInfo().getEncodedNameAsBytes(), (byte[])regionName)) continue;
            return loc;
        }
        return null;
    }

    public HRegionLocation[] getRegionLocations() {
        return this.locations;
    }

    public HRegionLocation getDefaultRegionLocation() {
        return this.locations[0];
    }

    public HRegionLocation getRegionLocation() {
        for (HRegionLocation loc : this.locations) {
            if (loc == null) continue;
            return loc;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (HRegionLocation loc : this.locations) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(loc == null ? "null" : loc);
        }
        builder.append("]");
        return builder.toString();
    }
}

