/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.exceptions.ConnectionClosingException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PoolMap;
import org.apache.hadoop.io.compress.CompressionCodec;

@InterfaceAudience.Private
public abstract class AbstractRpcClient
implements RpcClient {
    public static final Log LOG = LogFactory.getLog(AbstractRpcClient.class);
    protected final Configuration conf;
    protected String clusterId;
    protected final SocketAddress localAddr;
    protected UserProvider userProvider;
    protected final IPCUtil ipcUtil;
    protected final int minIdleTimeBeforeClose;
    protected final int maxRetries;
    protected final long failureSleep;
    protected final boolean tcpNoDelay;
    protected final boolean tcpKeepAlive;
    protected final Codec codec;
    protected final CompressionCodec compressor;
    protected final boolean fallbackAllowed;
    protected final int connectTO;
    protected final int readTO;
    protected final int writeTO;

    public AbstractRpcClient(Configuration conf, String clusterId, SocketAddress localAddr) {
        this.userProvider = UserProvider.instantiate((Configuration)conf);
        this.localAddr = localAddr;
        this.tcpKeepAlive = conf.getBoolean("hbase.ipc.client.tcpkeepalive", true);
        this.clusterId = clusterId != null ? clusterId : "default-cluster";
        this.failureSleep = conf.getLong("hbase.client.pause", 100L);
        this.maxRetries = conf.getInt("hbase.ipc.client.connect.max.retries", 0);
        this.tcpNoDelay = conf.getBoolean("hbase.ipc.client.tcpnodelay", true);
        this.ipcUtil = new IPCUtil(conf);
        this.minIdleTimeBeforeClose = conf.getInt("hbase.ipc.client.connection.minIdleTimeBeforeClose", 120000);
        this.conf = conf;
        this.codec = this.getCodec();
        this.compressor = AbstractRpcClient.getCompressor(conf);
        this.fallbackAllowed = conf.getBoolean("hbase.ipc.client.fallback-to-simple-auth-allowed", false);
        this.connectTO = conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000);
        this.readTO = conf.getInt("hbase.ipc.client.socket.timeout.read", 20000);
        this.writeTO = conf.getInt("hbase.ipc.client.socket.timeout.write", 60000);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Codec=" + this.codec + ", compressor=" + this.compressor + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", connectTO=" + this.connectTO + ", readTO=" + this.readTO + ", writeTO=" + this.writeTO + ", minIdleTimeBeforeClose=" + this.minIdleTimeBeforeClose + ", maxRetries=" + this.maxRetries + ", fallbackAllowed=" + this.fallbackAllowed + ", bind address=" + (this.localAddr != null ? this.localAddr : "null")));
        }
    }

    @VisibleForTesting
    public static String getDefaultCodec(Configuration c) {
        return c.get("hbase.client.default.rpc.codec", KeyValueCodec.class.getCanonicalName());
    }

    Codec getCodec() {
        String className = this.conf.get("hbase.client.rpc.codec", AbstractRpcClient.getDefaultCodec(this.conf));
        if (className == null || className.length() == 0) {
            return null;
        }
        try {
            return (Codec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting codec " + className, e);
        }
    }

    @Override
    public boolean hasCellBlockSupport() {
        return this.codec != null;
    }

    private static CompressionCodec getCompressor(Configuration conf) {
        String className = conf.get("hbase.client.rpc.compressor", null);
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            return (CompressionCodec)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed getting compressor " + className, e);
        }
    }

    protected static PoolMap.PoolType getPoolType(Configuration config) {
        return PoolMap.PoolType.valueOf(config.get("hbase.client.ipc.pool.type"), PoolMap.PoolType.RoundRobin, PoolMap.PoolType.ThreadLocal);
    }

    protected static int getPoolSize(Configuration config) {
        return config.getInt("hbase.client.ipc.pool.size", 1);
    }

    Message callBlockingMethod(Descriptors.MethodDescriptor md, PayloadCarryingRpcController pcrc, Message param, Message returnType, User ticket, InetSocketAddress isa) throws ServiceException {
        if (pcrc == null) {
            pcrc = new PayloadCarryingRpcController();
        }
        long startTime = 0L;
        if (LOG.isTraceEnabled()) {
            startTime = EnvironmentEdgeManager.currentTime();
        }
        try {
            Pair<Message, CellScanner> val = this.call(pcrc, md, param, returnType, ticket, isa);
            pcrc.setCellScanner((CellScanner)val.getSecond());
            if (LOG.isTraceEnabled()) {
                long callTime = EnvironmentEdgeManager.currentTime() - startTime;
                LOG.trace((Object)("Call: " + md.getName() + ", callTime: " + callTime + "ms"));
            }
            return (Message)val.getFirst();
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
    }

    protected abstract Pair<Message, CellScanner> call(PayloadCarryingRpcController var1, Descriptors.MethodDescriptor var2, Message var3, Message var4, User var5, InetSocketAddress var6) throws IOException, InterruptedException;

    @Override
    public BlockingRpcChannel createBlockingRpcChannel(ServerName sn, User ticket, int defaultOperationTimeout) {
        return new BlockingRpcChannelImplementation(this, sn, ticket, defaultOperationTimeout);
    }

    protected IOException wrapException(InetSocketAddress addr, Exception exception) {
        if (exception instanceof ConnectException) {
            return (ConnectException)new ConnectException("Call to " + addr + " failed on connection exception: " + exception).initCause(exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return (SocketTimeoutException)new SocketTimeoutException("Call to " + addr + " failed because " + exception).initCause(exception);
        }
        if (exception instanceof ConnectionClosingException) {
            return (ConnectionClosingException)new ConnectionClosingException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
        }
        return (IOException)new IOException("Call to " + addr + " failed on local exception: " + exception).initCause(exception);
    }

    @VisibleForTesting
    public static class BlockingRpcChannelImplementation
    implements BlockingRpcChannel {
        private final InetSocketAddress isa;
        private final AbstractRpcClient rpcClient;
        private final User ticket;
        private final int channelOperationTimeout;

        protected BlockingRpcChannelImplementation(AbstractRpcClient rpcClient, ServerName sn, User ticket, int channelOperationTimeout) {
            this.isa = new InetSocketAddress(sn.getHostname(), sn.getPort());
            this.rpcClient = rpcClient;
            this.ticket = ticket;
            this.channelOperationTimeout = channelOperationTimeout;
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor md, RpcController controller, Message param, Message returnType) throws ServiceException {
            PayloadCarryingRpcController pcrc;
            if (controller != null) {
                pcrc = (PayloadCarryingRpcController)controller;
                if (!pcrc.hasCallTimeout()) {
                    pcrc.setCallTimeout(this.channelOperationTimeout);
                }
            } else {
                pcrc = new PayloadCarryingRpcController();
                pcrc.setCallTimeout(this.channelOperationTimeout);
            }
            return this.rpcClient.callBlockingMethod(md, pcrc, param, returnType, this.ticket, this.isa);
        }
    }
}

