/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BalanceRequest;
import org.apache.hadoop.hbase.client.BalanceResponse;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.CoprocessorBlockingRpcCallback;
import org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hadoop.hbase.client.MasterCoprocessorRpcChannelImpl;
import org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hadoop.hbase.client.RawAsyncHBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionServerCoprocessorRpcChannelImpl;
import org.apache.hadoop.hbase.client.ServerType;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotView;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcChannel;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AdminOverAsyncAdmin
implements Admin {
    private static final Logger LOG = LoggerFactory.getLogger(AdminOverAsyncAdmin.class);
    private volatile boolean aborted = false;
    private final Connection conn;
    private final RawAsyncHBaseAdmin admin;
    private final int operationTimeout;
    private final int syncWaitTimeout;

    public AdminOverAsyncAdmin(Connection conn, RawAsyncHBaseAdmin admin) {
        this.conn = conn;
        this.admin = admin;
        this.operationTimeout = conn.getConfiguration().getInt("hbase.client.operation.timeout", 1200000);
        this.syncWaitTimeout = conn.getConfiguration().getInt("hbase.client.sync.wait.timeout.msec", 600000);
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public int getSyncWaitTimeout() {
        return this.syncWaitTimeout;
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.warn("Aborting becasue of {}", (Object)why, (Object)e);
        this.aborted = true;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.tableExists(tableName));
    }

    @Override
    public List<TableDescriptor> listTableDescriptors() throws IOException {
        return (List)FutureUtils.get(this.admin.listTableDescriptors());
    }

    @Override
    public List<TableDescriptor> listTableDescriptors(boolean includeSysTables) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableDescriptors(includeSysTables));
    }

    @Override
    public List<TableDescriptor> listTableDescriptors(Pattern pattern, boolean includeSysTables) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableDescriptors(pattern, includeSysTables));
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByState(boolean isEnabled) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableDescriptorsByState(isEnabled));
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        return ((List)FutureUtils.get(this.admin.listTableNames())).toArray(new TableName[0]);
    }

    @Override
    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return ((List)FutureUtils.get(this.admin.listTableNames(pattern, includeSysTables))).toArray(new TableName[0]);
    }

    @Override
    public List<TableName> listTableNamesByState(boolean isEnabled) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableNamesByState(isEnabled));
    }

    @Override
    public TableDescriptor getDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return (TableDescriptor)FutureUtils.get(this.admin.getDescriptor(tableName));
    }

    @Override
    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        FutureUtils.get(this.admin.createTable(desc, startKey, endKey, numRegions));
    }

    @Override
    public Future<Void> createTableAsync(TableDescriptor desc) throws IOException {
        return this.admin.createTable(desc);
    }

    @Override
    public Future<Void> createTableAsync(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        return this.admin.createTable(desc, splitKeys);
    }

    @Override
    public Future<Void> deleteTableAsync(TableName tableName) throws IOException {
        return this.admin.deleteTable(tableName);
    }

    @Override
    public Future<Void> truncateTableAsync(TableName tableName, boolean preserveSplits) throws IOException {
        return this.admin.truncateTable(tableName, preserveSplits);
    }

    @Override
    public Future<Void> enableTableAsync(TableName tableName) throws IOException {
        return this.admin.enableTable(tableName);
    }

    @Override
    public Future<Void> disableTableAsync(TableName tableName) throws IOException {
        return this.admin.disableTable(tableName);
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isTableEnabled(tableName));
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isTableDisabled(tableName));
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isTableAvailable(tableName));
    }

    @Override
    public Future<Void> addColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.admin.addColumnFamily(tableName, columnFamily);
    }

    @Override
    public Future<Void> deleteColumnFamilyAsync(TableName tableName, byte[] columnFamily) throws IOException {
        return this.admin.deleteColumnFamily(tableName, columnFamily);
    }

    @Override
    public Future<Void> modifyColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.admin.modifyColumnFamily(tableName, columnFamily);
    }

    @Override
    public Future<Void> modifyColumnFamilyStoreFileTrackerAsync(TableName tableName, byte[] family, String dstSFT) throws IOException {
        return this.admin.modifyColumnFamilyStoreFileTracker(tableName, family, dstSFT);
    }

    @Override
    public List<RegionInfo> getRegions(ServerName serverName) throws IOException {
        return (List)FutureUtils.get(this.admin.getRegions(serverName));
    }

    @Override
    public void flush(TableName tableName) throws IOException {
        FutureUtils.get(this.admin.flush(tableName));
    }

    @Override
    public void flush(TableName tableName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.admin.flush(tableName, columnFamily));
    }

    @Override
    public void flush(TableName tableName, List<byte[]> columnFamilies) throws IOException {
        FutureUtils.get(this.admin.flush(tableName, columnFamilies));
    }

    @Override
    public void flushRegion(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.flushRegion(regionName));
    }

    @Override
    public void flushRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.admin.flushRegion(regionName, columnFamily));
    }

    @Override
    public void flushRegionServer(ServerName serverName) throws IOException {
        FutureUtils.get(this.admin.flushRegionServer(serverName));
    }

    @Override
    public void compact(TableName tableName) throws IOException {
        FutureUtils.get(this.admin.compact(tableName));
    }

    @Override
    public void compactRegion(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.compactRegion(regionName));
    }

    @Override
    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.admin.compact(tableName, columnFamily));
    }

    @Override
    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.admin.compactRegion(regionName, columnFamily));
    }

    @Override
    public void compact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        FutureUtils.get(this.admin.compact(tableName, compactType));
    }

    @Override
    public void compact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        FutureUtils.get(this.admin.compact(tableName, columnFamily, compactType));
    }

    @Override
    public void majorCompact(TableName tableName) throws IOException {
        FutureUtils.get(this.admin.majorCompact(tableName));
    }

    @Override
    public void majorCompactRegion(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.majorCompactRegion(regionName));
    }

    @Override
    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.admin.majorCompact(tableName, columnFamily));
    }

    @Override
    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        FutureUtils.get(this.admin.majorCompactRegion(regionName, columnFamily));
    }

    @Override
    public void majorCompact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        FutureUtils.get(this.admin.majorCompact(tableName, compactType));
    }

    @Override
    public void majorCompact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        FutureUtils.get(this.admin.majorCompact(tableName, columnFamily, compactType));
    }

    @Override
    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) throws IOException {
        return (Map)FutureUtils.get(this.admin.compactionSwitch(switchState, serverNamesList));
    }

    @Override
    public void compactRegionServer(ServerName serverName) throws IOException {
        FutureUtils.get(this.admin.compactRegionServer(serverName));
    }

    @Override
    public void majorCompactRegionServer(ServerName serverName) throws IOException {
        FutureUtils.get(this.admin.majorCompactRegionServer(serverName));
    }

    @Override
    public void move(byte[] encodedRegionName) throws IOException {
        FutureUtils.get(this.admin.move(encodedRegionName));
    }

    @Override
    public void move(byte[] encodedRegionName, ServerName destServerName) throws IOException {
        FutureUtils.get(this.admin.move(encodedRegionName, destServerName));
    }

    @Override
    public void assign(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.assign(regionName));
    }

    @Override
    public void unassign(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.unassign(regionName));
    }

    @Override
    public void offline(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.offline(regionName));
    }

    @Override
    public boolean balancerSwitch(boolean onOrOff, boolean synchronous) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.balancerSwitch(onOrOff, synchronous));
    }

    @Override
    public BalanceResponse balance(BalanceRequest request) throws IOException {
        return (BalanceResponse)FutureUtils.get(this.admin.balance(request));
    }

    @Override
    public boolean balance() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.balance());
    }

    @Override
    public boolean balance(boolean force) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.balance(force));
    }

    @Override
    public boolean isBalancerEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isBalancerEnabled());
    }

    @Override
    public CacheEvictionStats clearBlockCache(TableName tableName) throws IOException {
        return (CacheEvictionStats)FutureUtils.get(this.admin.clearBlockCache(tableName));
    }

    @Override
    public boolean normalize(NormalizeTableFilterParams ntfp) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.normalize(ntfp));
    }

    @Override
    public boolean isNormalizerEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isNormalizerEnabled());
    }

    @Override
    public boolean normalizerSwitch(boolean on) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.normalizerSwitch(on));
    }

    @Override
    public boolean catalogJanitorSwitch(boolean onOrOff) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.catalogJanitorSwitch(onOrOff));
    }

    @Override
    public int runCatalogJanitor() throws IOException {
        return (Integer)FutureUtils.get(this.admin.runCatalogJanitor());
    }

    @Override
    public boolean isCatalogJanitorEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isCatalogJanitorEnabled());
    }

    @Override
    public boolean cleanerChoreSwitch(boolean onOrOff) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.cleanerChoreSwitch(onOrOff));
    }

    @Override
    public boolean runCleanerChore() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.runCleanerChore());
    }

    @Override
    public boolean isCleanerChoreEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isCleanerChoreEnabled());
    }

    @Override
    public Future<Void> mergeRegionsAsync(byte[][] nameOfRegionsToMerge, boolean forcible) throws IOException {
        return this.admin.mergeRegions(Arrays.asList(nameOfRegionsToMerge), forcible);
    }

    @Override
    public void split(TableName tableName) throws IOException {
        FutureUtils.get(this.admin.split(tableName));
    }

    @Override
    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        FutureUtils.get(this.admin.split(tableName, splitPoint));
    }

    @Override
    public Future<Void> splitRegionAsync(byte[] regionName) throws IOException {
        return this.admin.splitRegion(regionName);
    }

    @Override
    public Future<Void> splitRegionAsync(byte[] regionName, byte[] splitPoint) throws IOException {
        return this.admin.splitRegion(regionName, splitPoint);
    }

    @Override
    public void truncateRegion(byte[] regionName) throws IOException {
        FutureUtils.get(this.admin.truncateRegion(regionName));
    }

    @Override
    public Future<Void> truncateRegionAsync(byte[] regionName) {
        return this.admin.truncateRegion(regionName);
    }

    @Override
    public Future<Void> modifyTableAsync(TableDescriptor td) throws IOException {
        return this.modifyTableAsync(td, true);
    }

    @Override
    public Future<Void> modifyTableAsync(TableDescriptor td, boolean reopenRegions) throws IOException {
        return this.admin.modifyTable(td, reopenRegions);
    }

    @Override
    public Future<Void> modifyTableStoreFileTrackerAsync(TableName tableName, String dstSFT) throws IOException {
        return this.admin.modifyTableStoreFileTracker(tableName, dstSFT);
    }

    @Override
    public void shutdown() throws IOException {
        FutureUtils.get(this.admin.shutdown());
    }

    @Override
    public void stopMaster() throws IOException {
        FutureUtils.get(this.admin.stopMaster());
    }

    @Override
    public boolean isMasterInMaintenanceMode() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isMasterInMaintenanceMode());
    }

    @Override
    public void stopRegionServer(String hostnamePort) throws IOException {
        FutureUtils.get(this.admin.stopRegionServer(ServerName.valueOf((String)hostnamePort, (long)0L)));
    }

    @Override
    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> options) throws IOException {
        return (ClusterMetrics)FutureUtils.get(this.admin.getClusterMetrics(options));
    }

    @Override
    public List<RegionMetrics> getRegionMetrics(ServerName serverName) throws IOException {
        return (List)FutureUtils.get(this.admin.getRegionMetrics(serverName));
    }

    @Override
    public List<RegionMetrics> getRegionMetrics(ServerName serverName, TableName tableName) throws IOException {
        return (List)FutureUtils.get(this.admin.getRegionMetrics(serverName, tableName));
    }

    @Override
    public Configuration getConfiguration() {
        return this.conn.getConfiguration();
    }

    @Override
    public Future<Void> createNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        return this.admin.createNamespace(descriptor);
    }

    @Override
    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        return this.admin.modifyNamespace(descriptor);
    }

    @Override
    public Future<Void> deleteNamespaceAsync(String name) throws IOException {
        return this.admin.deleteNamespace(name);
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return (NamespaceDescriptor)FutureUtils.get(this.admin.getNamespaceDescriptor(name));
    }

    @Override
    public String[] listNamespaces() throws IOException {
        return ((List)FutureUtils.get(this.admin.listNamespaces())).toArray(new String[0]);
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return ((List)FutureUtils.get(this.admin.listNamespaceDescriptors())).toArray(new NamespaceDescriptor[0]);
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] name) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableDescriptorsByNamespace(Bytes.toString((byte[])name)));
    }

    @Override
    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return ((List)FutureUtils.get(this.admin.listTableNamesByNamespace(name))).toArray(new TableName[0]);
    }

    @Override
    public List<RegionInfo> getRegions(TableName tableName) throws IOException {
        return (List)FutureUtils.get(this.admin.getRegions(tableName));
    }

    @Override
    public void close() {
    }

    @Override
    public List<TableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableDescriptors(tableNames));
    }

    @Override
    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
        return this.admin.abortProcedure(procId, mayInterruptIfRunning);
    }

    @Override
    public String getProcedures() throws IOException {
        return (String)FutureUtils.get(this.admin.getProcedures());
    }

    @Override
    public String getLocks() throws IOException {
        return (String)FutureUtils.get(this.admin.getLocks());
    }

    @Override
    public void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        FutureUtils.get(this.admin.rollWALWriter(serverName));
    }

    @Override
    public CompactionState getCompactionState(TableName tableName) throws IOException {
        return (CompactionState)((Object)FutureUtils.get(this.admin.getCompactionState(tableName)));
    }

    @Override
    public CompactionState getCompactionState(TableName tableName, CompactType compactType) throws IOException {
        return (CompactionState)((Object)FutureUtils.get(this.admin.getCompactionState(tableName, compactType)));
    }

    @Override
    public CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        return (CompactionState)((Object)FutureUtils.get(this.admin.getCompactionStateForRegion(regionName)));
    }

    @Override
    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        return ((Optional)FutureUtils.get(this.admin.getLastMajorCompactionTimestamp(tableName))).orElse(0L);
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return ((Optional)FutureUtils.get(this.admin.getLastMajorCompactionTimestampForRegion(regionName))).orElse(0L);
    }

    @Override
    public void snapshot(SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        FutureUtils.get(this.admin.snapshot(snapshot));
    }

    @Override
    public Future<Void> snapshotAsync(SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        return this.admin.snapshot(snapshot);
    }

    @Override
    public boolean isSnapshotFinished(SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        return (Boolean)FutureUtils.get(this.admin.isSnapshotFinished(snapshot));
    }

    @Override
    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        FutureUtils.get(this.admin.restoreSnapshot(snapshotName));
    }

    @Override
    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) throws IOException, RestoreSnapshotException {
        FutureUtils.get(this.admin.restoreSnapshot(snapshotName, takeFailSafeSnapshot, restoreAcl));
    }

    @Override
    public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName, boolean restoreAcl, String customSFT) throws IOException, TableExistsException, RestoreSnapshotException {
        return this.admin.cloneSnapshot(snapshotName, tableName, restoreAcl, customSFT);
    }

    @Override
    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        FutureUtils.get(this.admin.execProcedure(signature, instance, props));
    }

    @Override
    public byte[] execProcedureWithReturn(String signature, String instance, Map<String, String> props) throws IOException {
        return (byte[])FutureUtils.get(this.admin.execProcedureWithReturn(signature, instance, props));
    }

    @Override
    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isProcedureFinished(signature, instance, props));
    }

    @Override
    public List<SnapshotDescription> listSnapshots() throws IOException {
        return (List)FutureUtils.get(this.admin.listSnapshots());
    }

    @Override
    public List<SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        return (List)FutureUtils.get(this.admin.listSnapshots(pattern));
    }

    @Override
    public List<SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        return (List)FutureUtils.get(this.admin.listTableSnapshots(tableNamePattern, snapshotNamePattern));
    }

    @Override
    public void deleteSnapshot(String snapshotName) throws IOException {
        FutureUtils.get(this.admin.deleteSnapshot(snapshotName));
    }

    @Override
    public void deleteSnapshots(Pattern pattern) throws IOException {
        FutureUtils.get(this.admin.deleteSnapshots(pattern));
    }

    @Override
    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        FutureUtils.get(this.admin.deleteTableSnapshots(tableNamePattern, snapshotNamePattern));
    }

    @Override
    public void setQuota(QuotaSettings quota) throws IOException {
        FutureUtils.get(this.admin.setQuota(quota));
    }

    @Override
    public List<QuotaSettings> getQuota(QuotaFilter filter) throws IOException {
        return (List)FutureUtils.get(this.admin.getQuota(filter));
    }

    @Override
    public CoprocessorRpcChannel coprocessorService() {
        return new SyncCoprocessorRpcChannelOverAsync(new MasterCoprocessorRpcChannelImpl(this.admin.newMasterCaller()));
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        return new SyncCoprocessorRpcChannelOverAsync(new RegionServerCoprocessorRpcChannelImpl(this.admin.newServerCaller().serverName(serverName)));
    }

    @Override
    public void updateConfiguration(ServerName server) throws IOException {
        FutureUtils.get(this.admin.updateConfiguration(server));
    }

    @Override
    public void updateConfiguration() throws IOException {
        FutureUtils.get(this.admin.updateConfiguration());
    }

    @Override
    public void updateConfiguration(String groupName) throws IOException {
        FutureUtils.get(this.admin.updateConfiguration(groupName));
    }

    @Override
    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        return (List)FutureUtils.get(this.admin.getSecurityCapabilities());
    }

    @Override
    public boolean splitSwitch(boolean enabled, boolean synchronous) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.splitSwitch(enabled, synchronous));
    }

    @Override
    public boolean mergeSwitch(boolean enabled, boolean synchronous) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.mergeSwitch(enabled, synchronous));
    }

    @Override
    public boolean isSplitEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isSplitEnabled());
    }

    @Override
    public boolean isMergeEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isMergeEnabled());
    }

    @Override
    public Future<Void> addReplicationPeerAsync(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) throws IOException {
        return this.admin.addReplicationPeer(peerId, peerConfig, enabled);
    }

    @Override
    public Future<Void> removeReplicationPeerAsync(String peerId) throws IOException {
        return this.admin.removeReplicationPeer(peerId);
    }

    @Override
    public Future<Void> enableReplicationPeerAsync(String peerId) throws IOException {
        return this.admin.enableReplicationPeer(peerId);
    }

    @Override
    public Future<Void> disableReplicationPeerAsync(String peerId) throws IOException {
        return this.admin.disableReplicationPeer(peerId);
    }

    @Override
    public ReplicationPeerConfig getReplicationPeerConfig(String peerId) throws IOException {
        return (ReplicationPeerConfig)FutureUtils.get(this.admin.getReplicationPeerConfig(peerId));
    }

    @Override
    public Future<Void> updateReplicationPeerConfigAsync(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        return this.admin.updateReplicationPeerConfig(peerId, peerConfig);
    }

    @Override
    public List<ReplicationPeerDescription> listReplicationPeers() throws IOException {
        return (List)FutureUtils.get(this.admin.listReplicationPeers());
    }

    @Override
    public List<ReplicationPeerDescription> listReplicationPeers(Pattern pattern) throws IOException {
        return (List)FutureUtils.get(this.admin.listReplicationPeers(pattern));
    }

    @Override
    public Future<Void> transitReplicationPeerSyncReplicationStateAsync(String peerId, SyncReplicationState state) throws IOException {
        return this.admin.transitReplicationPeerSyncReplicationState(peerId, state);
    }

    @Override
    public boolean isReplicationPeerEnabled(String peerId) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isReplicationPeerEnabled(peerId));
    }

    @Override
    public boolean replicationPeerModificationSwitch(boolean on, boolean drainProcedures) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.replicationPeerModificationSwitch(on, drainProcedures));
    }

    @Override
    public boolean isReplicationPeerModificationEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isReplicationPeerModificationEnabled());
    }

    @Override
    public void decommissionRegionServers(List<ServerName> servers, boolean offload) throws IOException {
        FutureUtils.get(this.admin.decommissionRegionServers(servers, offload));
    }

    @Override
    public List<ServerName> listDecommissionedRegionServers() throws IOException {
        return (List)FutureUtils.get(this.admin.listDecommissionedRegionServers());
    }

    @Override
    public void recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) throws IOException {
        FutureUtils.get(this.admin.recommissionRegionServer(server, encodedRegionNames));
    }

    @Override
    public List<TableCFs> listReplicatedTableCFs() throws IOException {
        return (List)FutureUtils.get(this.admin.listReplicatedTableCFs());
    }

    @Override
    public void enableTableReplication(TableName tableName) throws IOException {
        FutureUtils.get(this.admin.enableTableReplication(tableName));
    }

    @Override
    public void disableTableReplication(TableName tableName) throws IOException {
        FutureUtils.get(this.admin.disableTableReplication(tableName));
    }

    @Override
    public void clearCompactionQueues(ServerName serverName, Set<String> queues) throws IOException, InterruptedException {
        FutureUtils.get(this.admin.clearCompactionQueues(serverName, queues));
    }

    @Override
    public List<ServerName> clearDeadServers(List<ServerName> servers) throws IOException {
        return (List)FutureUtils.get(this.admin.clearDeadServers(servers));
    }

    @Override
    public void cloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) throws IOException {
        FutureUtils.get(this.admin.cloneTableSchema(tableName, newTableName, preserveSplits));
    }

    @Override
    public boolean switchRpcThrottle(boolean enable) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.switchRpcThrottle(enable));
    }

    @Override
    public boolean isRpcThrottleEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isRpcThrottleEnabled());
    }

    @Override
    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.exceedThrottleQuotaSwitch(enable));
    }

    @Override
    public Map<TableName, Long> getSpaceQuotaTableSizes() throws IOException {
        return (Map)FutureUtils.get(this.admin.getSpaceQuotaTableSizes());
    }

    @Override
    public Map<TableName, ? extends SpaceQuotaSnapshotView> getRegionServerSpaceQuotaSnapshots(ServerName serverName) throws IOException {
        return (Map)FutureUtils.get(this.admin.getRegionServerSpaceQuotaSnapshots(serverName));
    }

    @Override
    public SpaceQuotaSnapshotView getCurrentSpaceQuotaSnapshot(String namespace) throws IOException {
        return (SpaceQuotaSnapshotView)FutureUtils.get(this.admin.getCurrentSpaceQuotaSnapshot(namespace));
    }

    @Override
    public SpaceQuotaSnapshotView getCurrentSpaceQuotaSnapshot(TableName tableName) throws IOException {
        return (SpaceQuotaSnapshotView)FutureUtils.get(this.admin.getCurrentSpaceQuotaSnapshot(tableName));
    }

    @Override
    public void grant(UserPermission userPermission, boolean mergeExistingPermissions) throws IOException {
        FutureUtils.get(this.admin.grant(userPermission, mergeExistingPermissions));
    }

    @Override
    public void revoke(UserPermission userPermission) throws IOException {
        FutureUtils.get(this.admin.revoke(userPermission));
    }

    @Override
    public List<UserPermission> getUserPermissions(GetUserPermissionsRequest getUserPermissionsRequest) throws IOException {
        return (List)FutureUtils.get(this.admin.getUserPermissions(getUserPermissionsRequest));
    }

    @Override
    public List<Boolean> hasUserPermissions(String userName, List<Permission> permissions) throws IOException {
        return (List)FutureUtils.get(this.admin.hasUserPermissions(userName, permissions));
    }

    @Override
    public boolean snapshotCleanupSwitch(boolean on, boolean synchronous) throws IOException {
        return (Boolean)FutureUtils.get(this.admin.snapshotCleanupSwitch(on, synchronous));
    }

    @Override
    public boolean isSnapshotCleanupEnabled() throws IOException {
        return (Boolean)FutureUtils.get(this.admin.isSnapshotCleanupEnabled());
    }

    @Override
    public List<Boolean> clearSlowLogResponses(Set<ServerName> serverNames) throws IOException {
        return (List)FutureUtils.get(this.admin.clearSlowLogResponses(serverNames));
    }

    @Override
    public RSGroupInfo getRSGroup(String groupName) throws IOException {
        return (RSGroupInfo)FutureUtils.get(this.admin.getRSGroup(groupName));
    }

    @Override
    public void moveServersToRSGroup(Set<Address> servers, String groupName) throws IOException {
        FutureUtils.get(this.admin.moveServersToRSGroup(servers, groupName));
    }

    @Override
    public void addRSGroup(String groupName) throws IOException {
        FutureUtils.get(this.admin.addRSGroup(groupName));
    }

    @Override
    public void removeRSGroup(String groupName) throws IOException {
        FutureUtils.get(this.admin.removeRSGroup(groupName));
    }

    @Override
    public BalanceResponse balanceRSGroup(String groupName, BalanceRequest request) throws IOException {
        return (BalanceResponse)FutureUtils.get(this.admin.balanceRSGroup(groupName, request));
    }

    @Override
    public List<RSGroupInfo> listRSGroups() throws IOException {
        return (List)FutureUtils.get(this.admin.listRSGroups());
    }

    @Override
    public List<TableName> listTablesInRSGroup(String groupName) throws IOException {
        return (List)FutureUtils.get(this.admin.listTablesInRSGroup(groupName));
    }

    @Override
    public Pair<List<String>, List<TableName>> getConfiguredNamespacesAndTablesInRSGroup(String groupName) throws IOException {
        return (Pair)FutureUtils.get(this.admin.getConfiguredNamespacesAndTablesInRSGroup(groupName));
    }

    @Override
    public RSGroupInfo getRSGroup(Address hostPort) throws IOException {
        return (RSGroupInfo)FutureUtils.get(this.admin.getRSGroup(hostPort));
    }

    @Override
    public void removeServersFromRSGroup(Set<Address> servers) throws IOException {
        FutureUtils.get(this.admin.removeServersFromRSGroup(servers));
    }

    @Override
    public RSGroupInfo getRSGroup(TableName tableName) throws IOException {
        return (RSGroupInfo)FutureUtils.get(this.admin.getRSGroup(tableName));
    }

    @Override
    public void setRSGroup(Set<TableName> tables, String groupName) throws IOException {
        FutureUtils.get(this.admin.setRSGroup(tables, groupName));
    }

    @Override
    public void renameRSGroup(String oldName, String newName) throws IOException {
        FutureUtils.get(this.admin.renameRSGroup(oldName, newName));
    }

    @Override
    public void updateRSGroupConfig(String groupName, Map<String, String> configuration) throws IOException {
        FutureUtils.get(this.admin.updateRSGroupConfig(groupName, configuration));
    }

    @Override
    public List<LogEntry> getLogEntries(Set<ServerName> serverNames, String logType, ServerType serverType, int limit, Map<String, Object> filterParams) throws IOException {
        return (List)FutureUtils.get(this.admin.getLogEntries(serverNames, logType, serverType, limit, filterParams));
    }

    @Override
    public void flushMasterStore() throws IOException {
        FutureUtils.get(this.admin.flushMasterStore());
    }

    @Override
    public List<String> getCachedFilesList(ServerName serverName) throws IOException {
        return (List)FutureUtils.get(this.admin.getCachedFilesList(serverName));
    }

    private static final class SyncCoprocessorRpcChannelOverAsync
    implements CoprocessorRpcChannel {
        private final RpcChannel delegate;

        public SyncCoprocessorRpcChannelOverAsync(RpcChannel delegate) {
            this.delegate = delegate;
        }

        public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
            Message ret;
            ClientCoprocessorRpcController c = new ClientCoprocessorRpcController();
            CoprocessorBlockingRpcCallback callback = new CoprocessorBlockingRpcCallback();
            this.delegate.callMethod(method, (RpcController)c, request, responsePrototype, callback);
            try {
                ret = (Message)callback.get();
            }
            catch (IOException e) {
                ConnectionUtils.setCoprocessorError(controller, e);
                return;
            }
            if (c.failed()) {
                ConnectionUtils.setCoprocessorError(controller, c.getFailed());
            }
            done.run((Object)ret);
        }

        public Message callBlockingMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
            Message ret;
            ClientCoprocessorRpcController c = new ClientCoprocessorRpcController();
            CoprocessorBlockingRpcCallback<Message> done = new CoprocessorBlockingRpcCallback<Message>();
            this.callMethod(method, c, request, responsePrototype, done);
            try {
                ret = done.get();
            }
            catch (IOException e) {
                throw new ServiceException((Throwable)e);
            }
            if (c.failed()) {
                ConnectionUtils.setCoprocessorError(controller, c.getFailed());
                throw new ServiceException(c.getFailed());
            }
            return ret;
        }
    }
}

