/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilder;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class Increment
extends Mutation {
    private static final int HEAP_OVERHEAD = ClassSize.REFERENCE + ClassSize.TIMERANGE;
    private TimeRange tr = TimeRange.allTime();

    public Increment(byte[] row) {
        this(row, 0, row.length);
    }

    public Increment(byte[] row, int offset, int length) {
        Increment.checkRow(row, offset, length);
        this.row = Bytes.copy((byte[])row, (int)offset, (int)length);
    }

    public Increment(Increment incrementToCopy) {
        super(incrementToCopy);
        this.tr = incrementToCopy.getTimeRange();
    }

    public Increment(byte[] row, long ts, NavigableMap<byte[], List<Cell>> familyMap) {
        super(row, ts, familyMap);
    }

    @Override
    public Increment add(Cell cell) throws IOException {
        super.add(cell);
        return this;
    }

    public Increment addColumn(byte[] family, byte[] qualifier, long amount) {
        if (family == null) {
            throw new IllegalArgumentException("family cannot be null");
        }
        List<Cell> list = this.getCellList(family);
        KeyValue kv = this.createPutKeyValue(family, qualifier, this.ts, Bytes.toBytes((long)amount));
        list.add((Cell)kv);
        return this;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Increment setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = TimeRange.between((long)minStamp, (long)maxStamp);
        return this;
    }

    @Override
    public Increment setTimestamp(long timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public Increment setReturnResults(boolean returnResults) {
        super.setReturnResults(returnResults);
        return this;
    }

    @Override
    public boolean isReturnResults() {
        return super.isReturnResults();
    }

    @Override
    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableMap<byte[], Long>> getFamilyMapOfLongs() {
        NavigableMap<byte[], List<Cell>> map = super.getFamilyCellMap();
        TreeMap<byte[], NavigableMap<byte[], Long>> results = new TreeMap<byte[], NavigableMap<byte[], Long>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry entry : map.entrySet()) {
            TreeMap<byte[], Long> longs = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
            for (Cell cell : (List)entry.getValue()) {
                longs.put(CellUtil.cloneQualifier((Cell)cell), Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            }
            results.put((byte[])entry.getKey(), (NavigableMap<byte[], Long>)longs);
        }
        return results;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("row=");
        sb.append(Bytes.toStringBinary((byte[])this.row));
        if (this.familyMap.isEmpty()) {
            sb.append(", no columns set to be incremented");
            return sb.toString();
        }
        sb.append(", families=");
        boolean moreThanOne = false;
        for (Map.Entry entry : this.familyMap.entrySet()) {
            if (moreThanOne) {
                sb.append("), ");
            } else {
                moreThanOne = true;
                sb.append("{");
            }
            sb.append("(family=");
            sb.append(Bytes.toString((byte[])((byte[])entry.getKey())));
            sb.append(", columns=");
            if (entry.getValue() == null) {
                sb.append("NONE");
                continue;
            }
            sb.append("{");
            boolean moreThanOneB = false;
            for (Cell cell : (List)entry.getValue()) {
                if (moreThanOneB) {
                    sb.append(", ");
                } else {
                    moreThanOneB = true;
                }
                sb.append(CellUtil.getCellKeyAsString((Cell)cell) + "+=" + Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
            }
            sb.append("}");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    protected long extraHeapSize() {
        return HEAP_OVERHEAD;
    }

    @Override
    public Increment setAttribute(String name, byte[] value) {
        return (Increment)super.setAttribute(name, value);
    }

    @Override
    public Increment setId(String id) {
        return (Increment)super.setId(id);
    }

    @Override
    public Increment setDurability(Durability d) {
        return (Increment)super.setDurability(d);
    }

    @Override
    public Increment setClusterIds(List<UUID> clusterIds) {
        return (Increment)super.setClusterIds(clusterIds);
    }

    @Override
    public Increment setCellVisibility(CellVisibility expression) {
        return (Increment)super.setCellVisibility(expression);
    }

    @Override
    public Increment setACL(String user, Permission perms) {
        return (Increment)super.setACL(user, perms);
    }

    @Override
    public Increment setACL(Map<String, Permission> perms) {
        return (Increment)super.setACL(perms);
    }

    @Override
    public Increment setTTL(long ttl) {
        return (Increment)super.setTTL(ttl);
    }

    @Override
    public Increment setPriority(int priority) {
        return (Increment)super.setPriority(priority);
    }

    @Override
    public CellBuilder getCellBuilder(CellBuilderType type) {
        return this.getCellBuilder(type, Cell.Type.Put);
    }
}

