/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class TableBuilderBase
implements TableBuilder {
    protected TableName tableName;
    protected int operationTimeout;
    protected int rpcTimeout;
    protected int readRpcTimeout;
    protected int writeRpcTimeout;
    protected Map<String, byte[]> requestAttributes = Collections.emptyMap();

    TableBuilderBase(TableName tableName, ConnectionConfiguration connConf) {
        if (tableName == null) {
            throw new IllegalArgumentException("Given table name is null");
        }
        this.tableName = tableName;
        this.operationTimeout = tableName.isSystemTable() ? connConf.getMetaOperationTimeout() : connConf.getOperationTimeout();
        this.rpcTimeout = connConf.getRpcTimeout();
        this.readRpcTimeout = tableName.isSystemTable() ? connConf.getMetaReadRpcTimeout() : connConf.getReadRpcTimeout();
        this.writeRpcTimeout = connConf.getWriteRpcTimeout();
    }

    @Override
    public TableBuilderBase setOperationTimeout(int timeout) {
        this.operationTimeout = timeout;
        return this;
    }

    @Override
    public TableBuilderBase setRpcTimeout(int timeout) {
        this.rpcTimeout = timeout;
        return this;
    }

    @Override
    public TableBuilderBase setReadRpcTimeout(int timeout) {
        this.readRpcTimeout = timeout;
        return this;
    }

    @Override
    public TableBuilderBase setWriteRpcTimeout(int timeout) {
        this.writeRpcTimeout = timeout;
        return this;
    }

    @Override
    public TableBuilderBase setRequestAttribute(String key, byte[] value) {
        if (this.requestAttributes.isEmpty()) {
            this.requestAttributes = new HashMap<String, byte[]>();
        }
        this.requestAttributes.put(key, value);
        return this;
    }
}

