/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class JVM {
    static final Logger LOG = LoggerFactory.getLogger(JVM.class);
    private OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
    private static final boolean ibmvendor = System.getProperty("java.vendor").contains("IBM");
    private static final boolean windows = System.getProperty("os.name").startsWith("Windows");
    private static final boolean linux = System.getProperty("os.name").startsWith("Linux");
    private static final String JVMVersion = System.getProperty("java.version");

    public static boolean isUnix() {
        if (windows) {
            return false;
        }
        return ibmvendor ? linux : true;
    }

    public static boolean isGZIPOutputStreamFinishBroken() {
        return ibmvendor && JVMVersion.contains("1.6.0");
    }

    private Long runUnixMXBeanMethod(String mBeanMethodName) {
        try {
            Class<?> classRef = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            if (classRef.isInstance(this.osMbean)) {
                Method mBeanMethod = classRef.getDeclaredMethod(mBeanMethodName, new Class[0]);
                Object unixos = classRef.cast(this.osMbean);
                return (Long)mBeanMethod.invoke(unixos, new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.warn("Not able to load class or method for com.sun.managment.UnixOperatingSystemMXBean.", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOpenFileDescriptorCount() {
        if (!ibmvendor) {
            Long ofdc = this.runUnixMXBeanMethod("getOpenFileDescriptorCount");
            return ofdc != null ? ofdc : -1L;
        }
        InputStream in = null;
        BufferedReader output = null;
        try {
            RuntimeMXBean rtmbean = ManagementFactory.getRuntimeMXBean();
            String rtname = rtmbean.getName();
            String[] pidhost = rtname.split("@");
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ls /proc/" + pidhost[0] + "/fdinfo | wc -l"});
            in = p.getInputStream();
            output = new BufferedReader(new InputStreamReader(in));
            String openFileDesCount = output.readLine();
            if (openFileDesCount != null) {
                long l = Long.parseLong(openFileDesCount);
                return l;
            }
        }
        catch (IOException ie) {
            LOG.warn("Not able to get the number of open file descriptors", (Throwable)ie);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStream", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStream", (Throwable)e);
                }
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxFileDescriptorCount() {
        if (!ibmvendor) {
            Long mfdc = this.runUnixMXBeanMethod("getMaxFileDescriptorCount");
            return mfdc != null ? mfdc : -1L;
        }
        InputStream in = null;
        BufferedReader output = null;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "ulimit -n"});
            in = p.getInputStream();
            output = new BufferedReader(new InputStreamReader(in));
            String maxFileDesCount = output.readLine();
            if (maxFileDesCount != null) {
                long l = Long.parseLong(maxFileDesCount);
                return l;
            }
        }
        catch (IOException ie) {
            LOG.warn("Not able to get the max number of file descriptors", (Throwable)ie);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the reader", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.warn("Not able to close the InputStream", (Throwable)e);
                }
            }
        }
        return -1L;
    }
}

