/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import java.util.Collections;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestOrder {
    byte[][] VALS = new byte[][]{Bytes.toBytes((String)"foo"), Bytes.toBytes((String)"bar"), Bytes.toBytes((String)"baz")};

    @Test
    public void testApplyAscending() {
        int i;
        byte[][] vals = new byte[this.VALS.length][];
        byte[][] ordered = new byte[this.VALS.length][];
        for (i = 0; i < this.VALS.length; ++i) {
            vals[i] = Arrays.copyOf(this.VALS[i], this.VALS[i].length);
            ordered[i] = Arrays.copyOf(this.VALS[i], this.VALS[i].length);
            Order.ASCENDING.apply(ordered[i]);
        }
        Arrays.sort(vals, Bytes.BYTES_COMPARATOR);
        Arrays.sort(ordered, Bytes.BYTES_COMPARATOR);
        for (i = 0; i < vals.length; ++i) {
            Assert.assertArrayEquals((byte[])vals[i], (byte[])ordered[i]);
        }
        byte[] rangeApply = Arrays.copyOf(this.VALS[0], this.VALS[0].length);
        Order.ASCENDING.apply(rangeApply, 1, 1);
        Assert.assertArrayEquals((byte[])this.VALS[0], (byte[])rangeApply);
    }

    @Test
    public void testApplyDescending() {
        int i;
        byte[][] vals = new byte[this.VALS.length][];
        byte[][] ordered = new byte[this.VALS.length][];
        for (i = 0; i < this.VALS.length; ++i) {
            vals[i] = Arrays.copyOf(this.VALS[i], this.VALS[i].length);
            ordered[i] = Arrays.copyOf(this.VALS[i], this.VALS[i].length);
            Order.DESCENDING.apply(ordered[i]);
        }
        Arrays.sort(vals, Collections.reverseOrder(Bytes.BYTES_COMPARATOR));
        Arrays.sort(ordered, Bytes.BYTES_COMPARATOR);
        for (i = 0; i < vals.length; ++i) {
            Order.DESCENDING.apply(ordered[i]);
            Assert.assertArrayEquals((byte[])vals[i], (byte[])ordered[i]);
        }
        byte[] expected = new byte[]{this.VALS[0][0], Order.DESCENDING.apply(this.VALS[0][1]), this.VALS[0][2]};
        byte[] rangeApply = Arrays.copyOf(this.VALS[0], this.VALS[0].length);
        Order.DESCENDING.apply(rangeApply, 1, 1);
        Assert.assertArrayEquals((byte[])expected, (byte[])rangeApply);
    }
}

