/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
@SuppressWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"}, justification="It has been like this forever")
public class ImmutableBytesWritable
implements WritableComparable<ImmutableBytesWritable> {
    private byte[] bytes;
    private int offset;
    private int length;

    public ImmutableBytesWritable() {
    }

    public ImmutableBytesWritable(byte[] bytes) {
        this(bytes, 0, bytes.length);
    }

    public ImmutableBytesWritable(ImmutableBytesWritable ibw) {
        this(ibw.get(), ibw.getOffset(), ibw.getSize());
    }

    public ImmutableBytesWritable(byte[] bytes, int offset, int length) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public byte[] get() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.bytes;
    }

    public void set(byte[] b) {
        this.set(b, 0, b.length);
    }

    public void set(byte[] b, int offset, int length) {
        this.bytes = b;
        this.offset = offset;
        this.length = length;
    }

    public int getSize() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getLength() {
        if (this.bytes == null) {
            throw new IllegalStateException("Uninitialiized. Null constructor called w/o accompaying readFields invocation");
        }
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.bytes = new byte[this.length];
        in.readFully(this.bytes, 0, this.length);
        this.offset = 0;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.bytes, this.offset, this.length);
    }

    public int hashCode() {
        int hash = 1;
        for (int i = this.offset; i < this.offset + this.length; ++i) {
            hash = 31 * hash + this.bytes[i];
        }
        return hash;
    }

    public int compareTo(ImmutableBytesWritable that) {
        return WritableComparator.compareBytes((byte[])this.bytes, (int)this.offset, (int)this.length, (byte[])that.bytes, (int)that.offset, (int)that.length);
    }

    public int compareTo(byte[] that) {
        return WritableComparator.compareBytes((byte[])this.bytes, (int)this.offset, (int)this.length, (byte[])that, (int)0, (int)that.length);
    }

    public boolean equals(Object right_obj) {
        if (right_obj instanceof byte[]) {
            return this.compareTo((byte[])right_obj) == 0;
        }
        if (right_obj instanceof ImmutableBytesWritable) {
            return this.compareTo((ImmutableBytesWritable)right_obj) == 0;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(3 * this.length);
        int endIdx = this.offset + this.length;
        for (int idx = this.offset; idx < endIdx; ++idx) {
            sb.append(' ');
            String num = Integer.toHexString(0xFF & this.bytes[idx]);
            if (num.length() < 2) {
                sb.append('0');
            }
            sb.append(num);
        }
        return sb.length() > 0 ? sb.substring(1) : "";
    }

    public static byte[][] toArray(List<byte[]> array) {
        byte[][] results = new byte[array.size()][];
        for (int i = 0; i < array.size(); ++i) {
            results[i] = array.get(i);
        }
        return results;
    }

    public byte[] copyBytes() {
        return Arrays.copyOfRange(this.bytes, this.offset, this.offset + this.length);
    }

    static {
        WritableComparator.define(ImmutableBytesWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        private BytesWritable.Comparator comparator = new BytesWritable.Comparator();

        public Comparator() {
            super(ImmutableBytesWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return this.comparator.compare(b1, s1, l1, b2, s2, l2);
        }
    }
}

