/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AuthUtil {
    private static final Log LOG = LogFactory.getLog(AuthUtil.class);

    public static void launchAuthChore(Configuration conf) throws IOException {
        boolean securityEnabled;
        UserProvider userProvider = UserProvider.instantiate(conf);
        boolean bl = securityEnabled = userProvider.isHadoopSecurityEnabled() && userProvider.isHBaseSecurityEnabled();
        if (!securityEnabled) {
            return;
        }
        String host = null;
        try {
            host = Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)conf.get("hbase.client.dns.interface", "default"), (String)conf.get("hbase.client.dns.nameserver", "default")));
            userProvider.login("hbase.client.keytab.file", "hbase.client.kerberos.principal", host);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Error resolving host name");
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)"Error while trying to perform the initial login");
            throw e;
        }
        final UserGroupInformation ugi = userProvider.getCurrent().getUGI();
        Stoppable stoppable = new Stoppable(){
            private volatile boolean isStopped = false;

            @Override
            public void stop(String why) {
                this.isStopped = true;
            }

            @Override
            public boolean isStopped() {
                return this.isStopped;
            }
        };
        int CHECK_TGT_INTERVAL = 30000;
        Chore refreshCredentials = new Chore("RefreshCredentials", 30000, stoppable){

            @Override
            protected void chore() {
                try {
                    ugi.checkTGTAndReloginFromKeytab();
                }
                catch (IOException e) {
                    LOG.info((Object)"Got exception while trying to refresh credentials ");
                }
            }
        };
        Threads.setDaemonThreadRunning(refreshCredentials.getThread());
    }
}

