/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.FixedLengthWrapper;
import org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFixedLengthWrapper {
    static final byte[][] VALUES = new byte[][]{Bytes.toBytes((String)""), Bytes.toBytes((String)"1"), Bytes.toBytes((String)"22"), Bytes.toBytes((String)"333"), Bytes.toBytes((String)"4444"), Bytes.toBytes((String)"55555"), Bytes.toBytes((String)"666666"), Bytes.toBytes((String)"7777777"), Bytes.toBytes((String)"88888888"), Bytes.toBytes((String)"999999999")};
    static final int[] limits = new int[]{9, 12, 15};

    @Test
    public void testReadWrite() {
        for (int limit : limits) {
            SimplePositionedByteRange buff = new SimplePositionedByteRange(limit);
            for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
                for (byte[] val : VALUES) {
                    buff.setPosition(0);
                    FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(ord), limit);
                    Assert.assertEquals((long)limit, (long)type.encode((PositionedByteRange)buff, (Object)val));
                    buff.setPosition(0);
                    byte[] actual = (byte[])type.decode((PositionedByteRange)buff);
                    Assert.assertTrue((String)"Decoding output differs from expected", (boolean)Bytes.equals((byte[])val, (int)0, (int)val.length, (byte[])actual, (int)0, (int)val.length));
                    buff.setPosition(0);
                    Assert.assertEquals((long)limit, (long)type.skip((PositionedByteRange)buff));
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientRemainingRead() {
        SimplePositionedByteRange buff = new SimplePositionedByteRange(0);
        FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(), 3);
        type.decode((PositionedByteRange)buff);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientRemainingWrite() {
        SimplePositionedByteRange buff = new SimplePositionedByteRange(0);
        FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(), 3);
        type.encode((PositionedByteRange)buff, (Object)Bytes.toBytes((String)""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOverflowPassthrough() {
        SimplePositionedByteRange buff = new SimplePositionedByteRange(3);
        FixedLengthWrapper type = new FixedLengthWrapper((DataType)new RawBytes(), 0);
        type.encode((PositionedByteRange)buff, (Object)Bytes.toBytes((String)"foo"));
    }
}

