/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Union2<A, B>
implements DataType<Object> {
    protected final DataType<A> typeA;
    protected final DataType<B> typeB;

    public Union2(DataType<A> typeA, DataType<B> typeB) {
        this.typeA = typeA;
        this.typeB = typeB;
    }

    @Override
    public boolean isOrderPreserving() {
        return this.typeA.isOrderPreserving() && this.typeB.isOrderPreserving();
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return this.typeA.isNullable() && this.typeB.isNullable();
    }

    @Override
    public boolean isSkippable() {
        return this.typeA.isSkippable() && this.typeB.isSkippable();
    }

    @Override
    public Class<Object> encodedClass() {
        throw new UnsupportedOperationException("Union types do not expose a definitive encoded class.");
    }

    public A decodeA(PositionedByteRange src) {
        return (A)this.decode(src);
    }

    public B decodeB(PositionedByteRange src) {
        return (B)this.decode(src);
    }
}

