/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ByteBufferOutputStream
extends OutputStream {
    protected ByteBuffer buf;

    public ByteBufferOutputStream(int capacity) {
        this(capacity, false);
    }

    public ByteBufferOutputStream(int capacity, boolean useDirectByteBuffer) {
        this.buf = useDirectByteBuffer ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
    }

    public int size() {
        return this.buf.position();
    }

    public ByteBuffer getByteBuffer() {
        this.buf.flip();
        return this.buf;
    }

    private void checkSizeAndGrow(int extra) {
        if (this.buf.position() + extra > this.buf.limit()) {
            int newSize = (int)Math.min((long)this.buf.capacity() * 2L, Integer.MAX_VALUE);
            newSize = Math.max(newSize, this.buf.position() + extra);
            ByteBuffer newBuf = ByteBuffer.allocate(newSize);
            this.buf.flip();
            newBuf.put(this.buf);
            this.buf = newBuf;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkSizeAndGrow(1);
        this.buf.put((byte)b);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        ByteBuffer bb = this.buf.duplicate();
        bb.flip();
        channel.write(bb);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkSizeAndGrow(b.length);
        this.buf.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkSizeAndGrow(len);
        this.buf.put(b, off, len);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] toByteArray(int offset, int length) {
        ByteBuffer bb = this.buf.duplicate();
        bb.flip();
        byte[] chunk = new byte[length];
        bb.position(offset);
        bb.get(chunk, 0, length);
        return chunk;
    }
}

