/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hadoop.hbase.SettableTimestamp;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class CellUtil {
    public static ByteRange fillRowRange(Cell cell, ByteRange range) {
        return range.set(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
    }

    public static ByteRange fillFamilyRange(Cell cell, ByteRange range) {
        return range.set(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength());
    }

    public static ByteRange fillQualifierRange(Cell cell, ByteRange range) {
        return range.set(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
    }

    public static ByteRange fillValueRange(Cell cell, ByteRange range) {
        return range.set(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static ByteRange fillTagRange(Cell cell, ByteRange range) {
        return range.set(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
    }

    public static byte[] cloneRow(Cell cell) {
        byte[] output = new byte[cell.getRowLength()];
        CellUtil.copyRowTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneFamily(Cell cell) {
        byte[] output = new byte[cell.getFamilyLength()];
        CellUtil.copyFamilyTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneQualifier(Cell cell) {
        byte[] output = new byte[cell.getQualifierLength()];
        CellUtil.copyQualifierTo(cell, output, 0);
        return output;
    }

    public static byte[] cloneValue(Cell cell) {
        byte[] output = new byte[cell.getValueLength()];
        CellUtil.copyValueTo(cell, output, 0);
        return output;
    }

    public static byte[] getTagArray(Cell cell) {
        byte[] output = new byte[cell.getTagsLength()];
        CellUtil.copyTagTo(cell, output, 0);
        return output;
    }

    public static int copyRowTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getRowArray(), cell.getRowOffset(), destination, destinationOffset, cell.getRowLength());
        return destinationOffset + cell.getRowLength();
    }

    public static int copyFamilyTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), destination, destinationOffset, cell.getFamilyLength());
        return destinationOffset + cell.getFamilyLength();
    }

    public static int copyQualifierTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), destination, destinationOffset, cell.getQualifierLength());
        return destinationOffset + cell.getQualifierLength();
    }

    public static int copyValueTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getValueArray(), cell.getValueOffset(), destination, destinationOffset, cell.getValueLength());
        return destinationOffset + cell.getValueLength();
    }

    public static int copyTagTo(Cell cell, byte[] destination, int destinationOffset) {
        System.arraycopy(cell.getTagsArray(), cell.getTagsOffset(), destination, destinationOffset, cell.getTagsLength());
        return destinationOffset + cell.getTagsLength();
    }

    public static byte getRowByte(Cell cell, int index) {
        return cell.getRowArray()[cell.getRowOffset() + index];
    }

    public static ByteBuffer getValueBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        return buffer;
    }

    public static ByteBuffer getQualifierBufferShallowCopy(Cell cell) {
        ByteBuffer buffer = ByteBuffer.wrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        return buffer;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value) {
        return new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value);
    }

    public static Cell createCell(byte[] rowArray, int rowOffset, int rowLength, byte[] familyArray, int familyOffset, int familyLength, byte[] qualifierArray, int qualifierOffset, int qualifierLength) {
        return new KeyValue(rowArray, rowOffset, rowLength, familyArray, familyOffset, familyLength, qualifierArray, qualifierOffset, qualifierLength, Long.MAX_VALUE, KeyValue.Type.Maximum, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length);
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, long memstoreTS) {
        KeyValue keyValue = new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value);
        keyValue.setSequenceId(memstoreTS);
        return keyValue;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte type, byte[] value, byte[] tags, long memstoreTS) {
        KeyValue keyValue = new KeyValue(row, family, qualifier, timestamp, KeyValue.Type.codeToType(type), value, tags);
        keyValue.setSequenceId(memstoreTS);
        return keyValue;
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, byte[] value, byte[] tags) {
        KeyValue keyValue = new KeyValue(row, family, qualifier, timestamp, type, value, tags);
        return keyValue;
    }

    public static Cell createCell(byte[] row) {
        return CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY);
    }

    public static Cell createCell(byte[] row, byte[] value) {
        return CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, Long.MAX_VALUE, KeyValue.Type.Maximum.getCode(), value);
    }

    public static Cell createCell(byte[] row, byte[] family, byte[] qualifier) {
        return CellUtil.createCell(row, family, qualifier, Long.MAX_VALUE, KeyValue.Type.Maximum.getCode(), HConstants.EMPTY_BYTE_ARRAY);
    }

    public static CellScanner createCellScanner(final List<? extends CellScannable> cellScannerables) {
        return new CellScanner(){
            private final Iterator<? extends CellScannable> iterator;
            private CellScanner cellScanner;
            {
                this.iterator = cellScannerables.iterator();
                this.cellScanner = null;
            }

            @Override
            public Cell current() {
                return this.cellScanner != null ? this.cellScanner.current() : null;
            }

            @Override
            public boolean advance() throws IOException {
                while (true) {
                    if (this.cellScanner == null) {
                        if (!this.iterator.hasNext()) {
                            return false;
                        }
                        this.cellScanner = this.iterator.next().cellScanner();
                    }
                    if (this.cellScanner.advance()) {
                        return true;
                    }
                    this.cellScanner = null;
                }
            }
        };
    }

    public static CellScanner createCellScanner(Iterable<Cell> cellIterable) {
        if (cellIterable == null) {
            return null;
        }
        return CellUtil.createCellScanner(cellIterable.iterator());
    }

    public static CellScanner createCellScanner(final Iterator<Cell> cells) {
        if (cells == null) {
            return null;
        }
        return new CellScanner(){
            private final Iterator<Cell> iterator;
            private Cell current;
            {
                this.iterator = cells;
                this.current = null;
            }

            @Override
            public Cell current() {
                return this.current;
            }

            @Override
            public boolean advance() {
                boolean hasNext = this.iterator.hasNext();
                this.current = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        };
    }

    public static CellScanner createCellScanner(final Cell[] cellArray) {
        return new CellScanner(){
            private final Cell[] cells;
            private int index;
            {
                this.cells = cellArray;
                this.index = -1;
            }

            @Override
            public Cell current() {
                if (this.cells == null) {
                    return null;
                }
                return this.index < 0 ? null : this.cells[this.index];
            }

            @Override
            public boolean advance() {
                if (this.cells == null) {
                    return false;
                }
                return ++this.index < this.cells.length;
            }
        };
    }

    public static CellScanner createCellScanner(final NavigableMap<byte[], List<Cell>> map) {
        return new CellScanner(){
            private final Iterator<Map.Entry<byte[], List<Cell>>> entries;
            private Iterator<Cell> currentIterator;
            private Cell currentCell;
            {
                this.entries = map.entrySet().iterator();
                this.currentIterator = null;
            }

            @Override
            public Cell current() {
                return this.currentCell;
            }

            @Override
            public boolean advance() {
                while (true) {
                    if (this.currentIterator == null) {
                        if (!this.entries.hasNext()) {
                            return false;
                        }
                        this.currentIterator = this.entries.next().getValue().iterator();
                    }
                    if (this.currentIterator.hasNext()) {
                        this.currentCell = this.currentIterator.next();
                        return true;
                    }
                    this.currentCell = null;
                    this.currentIterator = null;
                }
            }
        };
    }

    public static boolean matchingRow(Cell left, Cell right) {
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), right.getRowArray(), right.getRowOffset(), right.getRowLength());
    }

    public static boolean matchingRow(Cell left, byte[] buf) {
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), buf, 0, buf.length);
    }

    public static boolean matchingRow(Cell left, byte[] buf, int offset, int length) {
        return Bytes.equals(left.getRowArray(), left.getRowOffset(), left.getRowLength(), buf, offset, length);
    }

    public static boolean matchingFamily(Cell left, Cell right) {
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), right.getFamilyArray(), right.getFamilyOffset(), right.getFamilyLength());
    }

    public static boolean matchingFamily(Cell left, byte[] buf) {
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), buf, 0, buf.length);
    }

    public static boolean matchingFamily(Cell left, byte[] buf, int offset, int length) {
        return Bytes.equals(left.getFamilyArray(), left.getFamilyOffset(), left.getFamilyLength(), buf, offset, length);
    }

    public static boolean matchingQualifier(Cell left, Cell right) {
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), right.getQualifierArray(), right.getQualifierOffset(), right.getQualifierLength());
    }

    public static boolean matchingQualifier(Cell left, byte[] buf) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), buf, 0, buf.length);
    }

    public static boolean matchingQualifier(Cell left, byte[] buf, int offset, int length) {
        if (buf == null) {
            return left.getQualifierLength() == 0;
        }
        return Bytes.equals(left.getQualifierArray(), left.getQualifierOffset(), left.getQualifierLength(), buf, offset, length);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, byte[] qual) {
        if (!CellUtil.matchingFamily(left, fam)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, qual);
    }

    public static boolean matchingColumn(Cell left, byte[] fam, int foffset, int flength, byte[] qual, int qoffset, int qlength) {
        if (!CellUtil.matchingFamily(left, fam, foffset, flength)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, qual, qoffset, qlength);
    }

    public static boolean matchingColumn(Cell left, Cell right) {
        if (!CellUtil.matchingFamily(left, right)) {
            return false;
        }
        return CellUtil.matchingQualifier(left, right);
    }

    public static boolean matchingValue(Cell left, Cell right) {
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), right.getValueArray(), right.getValueOffset(), right.getValueLength());
    }

    public static boolean matchingValue(Cell left, byte[] buf) {
        return Bytes.equals(left.getValueArray(), left.getValueOffset(), left.getValueLength(), buf, 0, buf.length);
    }

    public static boolean isDelete(Cell cell) {
        return CellUtil.isDelete(cell.getTypeByte());
    }

    public static boolean isDelete(byte type) {
        return KeyValue.Type.Delete.getCode() <= type && type <= KeyValue.Type.DeleteFamily.getCode();
    }

    public static boolean isDeleteType(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    public static boolean isDeleteFamily(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    public static boolean isDeleteFamilyVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    public static boolean isDeleteColumns(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    public static boolean isDeleteColumnVersion(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    public static boolean isDeleteColumnOrFamily(Cell cell) {
        byte t = cell.getTypeByte();
        return t == KeyValue.Type.DeleteColumn.getCode() || t == KeyValue.Type.DeleteFamily.getCode();
    }

    @Deprecated
    public static int estimatedSizeOf(Cell cell) {
        return CellUtil.estimatedSerializedSizeOf(cell);
    }

    public static int estimatedSerializedSizeOf(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).getLength() + 4;
        }
        return CellUtil.getSumOfCellElementLengths(cell) + 12 + 4;
    }

    private static int getSumOfCellElementLengths(Cell cell) {
        return CellUtil.getSumOfCellKeyElementLengths(cell) + cell.getValueLength() + cell.getTagsLength();
    }

    private static int getSumOfCellKeyElementLengths(Cell cell) {
        return cell.getRowLength() + cell.getFamilyLength() + cell.getQualifierLength() + 9;
    }

    public static int estimatedSerializedSizeOfKey(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).getKeyLength();
        }
        return CellUtil.getSumOfCellKeyElementLengths(cell);
    }

    public static long estimatedHeapSizeOf(Cell cell) {
        if (cell instanceof HeapSize) {
            return ((HeapSize)((Object)cell)).heapSize();
        }
        return CellUtil.estimatedSerializedSizeOf(cell);
    }

    @Deprecated
    public static long estimatedHeapSizeOfWithoutTags(Cell cell) {
        if (cell instanceof KeyValue) {
            return ((KeyValue)cell).heapSizeWithoutTags();
        }
        return CellUtil.getSumOfCellKeyElementLengths(cell) + cell.getValueLength();
    }

    public static Iterator<Tag> tagsIterator(final byte[] tags, final int offset, final int length) {
        return new Iterator<Tag>(){
            private int pos;
            private int endOffset;
            {
                this.pos = offset;
                this.endOffset = offset + length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.endOffset;
            }

            @Override
            public Tag next() {
                if (this.hasNext()) {
                    int curTagLen = Bytes.readAsInt(tags, this.pos, 2);
                    Tag tag = new Tag(tags, this.pos, curTagLen + 2);
                    this.pos += 2 + curTagLen;
                    return tag;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean overlappingKeys(byte[] start1, byte[] end1, byte[] start2, byte[] end2) {
        return !(end2.length != 0 && start1.length != 0 && Bytes.compareTo(start1, end2) >= 0 || end1.length != 0 && start2.length != 0 && Bytes.compareTo(start2, end1) >= 0);
    }

    public static void setSequenceId(Cell cell, long seqId) throws IOException {
        if (!(cell instanceof SettableSequenceId)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableSequenceId.class.getName()));
        }
        ((SettableSequenceId)((Object)cell)).setSequenceId(seqId);
    }

    public static void setTimestamp(Cell cell, long ts) throws IOException {
        if (!(cell instanceof SettableTimestamp)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableTimestamp.class.getName()));
        }
        ((SettableTimestamp)((Object)cell)).setTimestamp(ts);
    }

    public static void setTimestamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        if (!(cell instanceof SettableTimestamp)) {
            throw new IOException(new UnsupportedOperationException("Cell is not of type " + SettableTimestamp.class.getName()));
        }
        ((SettableTimestamp)((Object)cell)).setTimestamp(ts, tsOffset);
    }

    public static boolean updateLatestStamp(Cell cell, long ts) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            CellUtil.setTimestamp(cell, ts);
            return true;
        }
        return false;
    }

    public static boolean updateLatestStamp(Cell cell, byte[] ts, int tsOffset) throws IOException {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            CellUtil.setTimestamp(cell, ts, tsOffset);
            return true;
        }
        return false;
    }

    public static void writeFlatKey(Cell cell, DataOutputStream out) throws IOException {
        short rowLen = cell.getRowLength();
        out.writeShort(rowLen);
        out.write(cell.getRowArray(), cell.getRowOffset(), rowLen);
        byte fLen = cell.getFamilyLength();
        out.writeByte(fLen);
        out.write(cell.getFamilyArray(), cell.getFamilyOffset(), fLen);
        out.write(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        out.writeLong(cell.getTimestamp());
        out.writeByte(cell.getTypeByte());
    }

    public static String getCellKeyAsString(Cell cell) {
        StringBuilder sb = new StringBuilder(Bytes.toStringBinary(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength()));
        sb.append('/');
        sb.append(cell.getFamilyLength() == 0 ? "" : Bytes.toStringBinary(cell.getFamilyArray(), cell.getFamilyOffset(), cell.getFamilyLength()));
        if (cell.getFamilyLength() > 0) {
            sb.append(':');
        }
        sb.append(cell.getQualifierLength() == 0 ? "" : Bytes.toStringBinary(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
        sb.append('/');
        sb.append(KeyValue.humanReadableTimestamp(cell.getTimestamp()));
        sb.append('/');
        sb.append((Object)KeyValue.Type.codeToType(cell.getTypeByte()));
        sb.append("/vlen=");
        sb.append(cell.getValueLength());
        sb.append("/seqid=");
        sb.append(cell.getSequenceId());
        return sb.toString();
    }

    public static byte[] getCellKeySerializedAsKeyValueKey(Cell cell) {
        if (cell == null) {
            return null;
        }
        byte[] b = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, b, 0);
        return b;
    }

    public static void writeRowKeyExcludingCommon(Cell cell, short rLen, int commonPrefix, DataOutputStream out) throws IOException {
        if (commonPrefix == 0) {
            out.writeShort(rLen);
        } else if (commonPrefix == 1) {
            out.writeByte((byte)rLen);
            --commonPrefix;
        } else {
            commonPrefix -= 2;
        }
        if (rLen > commonPrefix) {
            out.write(cell.getRowArray(), cell.getRowOffset() + commonPrefix, rLen - commonPrefix);
        }
    }

    public static int findCommonPrefixInFlatKey(Cell c1, Cell c2, boolean bypassFamilyCheck, boolean withTsType) {
        short rLen1 = c1.getRowLength();
        short rLen2 = c2.getRowLength();
        int commonPrefix = 2;
        if (rLen1 != rLen2) {
            return ByteBufferUtils.findCommonPrefix(Bytes.toBytes(rLen1), 0, 2, Bytes.toBytes(rLen2), 0, 2);
        }
        int rkCommonPrefix = ByteBufferUtils.findCommonPrefix(c1.getRowArray(), c1.getRowOffset(), rLen1, c2.getRowArray(), c2.getRowOffset(), rLen2);
        commonPrefix += rkCommonPrefix;
        if (rkCommonPrefix != rLen1) {
            return commonPrefix;
        }
        byte fLen1 = c1.getFamilyLength();
        if (bypassFamilyCheck) {
            commonPrefix += 1 + fLen1;
        } else {
            byte fLen2 = c2.getFamilyLength();
            if (fLen1 != fLen2) {
                return commonPrefix;
            }
            ++commonPrefix;
            int fCommonPrefix = ByteBufferUtils.findCommonPrefix(c1.getFamilyArray(), c1.getFamilyOffset(), fLen1, c2.getFamilyArray(), c2.getFamilyOffset(), fLen2);
            commonPrefix += fCommonPrefix;
            if (fCommonPrefix != fLen1) {
                return commonPrefix;
            }
        }
        int qLen1 = c1.getQualifierLength();
        int qLen2 = c2.getQualifierLength();
        int qCommon = ByteBufferUtils.findCommonPrefix(c1.getQualifierArray(), c1.getQualifierOffset(), qLen1, c2.getQualifierArray(), c2.getQualifierOffset(), qLen2);
        commonPrefix += qCommon;
        if (!withTsType || Math.max(qLen1, qLen2) != qCommon) {
            return commonPrefix;
        }
        int tsCommonPrefix = ByteBufferUtils.findCommonPrefix(Bytes.toBytes(c1.getTimestamp()), 0, 8, Bytes.toBytes(c2.getTimestamp()), 0, 8);
        commonPrefix += tsCommonPrefix;
        if (tsCommonPrefix != 8) {
            return commonPrefix;
        }
        if (c1.getTypeByte() == c2.getTypeByte()) {
            ++commonPrefix;
        }
        return commonPrefix;
    }
}

