/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.metrics.ExceptionTrackingSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsHBaseServerSourceImpl
extends ExceptionTrackingSourceImpl
implements MetricsHBaseServerSource {
    private final MetricsHBaseServerWrapper wrapper;
    private final MutableFastCounter authorizationSuccesses;
    private final MutableFastCounter authorizationFailures;
    private final MutableFastCounter authenticationSuccesses;
    private final MutableFastCounter authenticationFailures;
    private final MutableFastCounter authenticationFallbacks;
    private final MutableFastCounter sentBytes;
    private final MutableFastCounter receivedBytes;
    private final MutableFastCounter maxOutboundBytesExceeded;
    private MetricHistogram queueCallTime;
    private MetricHistogram processCallTime;
    private MetricHistogram totalCallTime;
    private MetricHistogram unwritableTime;
    private MetricHistogram requestSize;
    private MetricHistogram responseSize;

    public MetricsHBaseServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsHBaseServerWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.authorizationSuccesses = this.getMetricsRegistry().newCounter("authorizationSuccesses", "Number of authorization successes.", 0L);
        this.authorizationFailures = this.getMetricsRegistry().newCounter("authorizationFailures", "Number of authorization failures.", 0L);
        this.authenticationSuccesses = this.getMetricsRegistry().newCounter("authenticationSuccesses", "Number of authentication successes.", 0L);
        this.authenticationFailures = this.getMetricsRegistry().newCounter("authenticationFailures", "Number of authentication failures.", 0L);
        this.authenticationFallbacks = this.getMetricsRegistry().newCounter("authenticationFallbacks", "Number of fallbacks to insecure authentication.", 0L);
        this.sentBytes = this.getMetricsRegistry().newCounter("sentBytes", "Number of bytes sent.", 0L);
        this.receivedBytes = this.getMetricsRegistry().newCounter("receivedBytes", "Number of bytes received.", 0L);
        this.queueCallTime = this.getMetricsRegistry().newTimeHistogram("queueCallTime", "Queue Call Time.");
        this.processCallTime = this.getMetricsRegistry().newTimeHistogram("processCallTime", "Processing call time.");
        this.totalCallTime = this.getMetricsRegistry().newTimeHistogram("totalCallTime", "Total call time, including both queued and processing time.");
        this.unwritableTime = this.getMetricsRegistry().newTimeHistogram("unwritableTime", "Time where an channel was unwritable due to having too many outbound bytes");
        this.maxOutboundBytesExceeded = this.getMetricsRegistry().newCounter("maxOutboundBytesExceeded", "Number of times a connection was closed because the channel outbound bytes exceeded the configured max.", 0L);
        this.requestSize = this.getMetricsRegistry().newSizeHistogram("requestSize", "Request size in bytes.");
        this.responseSize = this.getMetricsRegistry().newSizeHistogram("responseSize", "Response size in bytes.");
    }

    @Override
    public void authorizationSuccess() {
        this.authorizationSuccesses.incr();
    }

    @Override
    public void authorizationFailure() {
        this.authorizationFailures.incr();
    }

    @Override
    public void authenticationFailure() {
        this.authenticationFailures.incr();
    }

    @Override
    public void authenticationFallback() {
        this.authenticationFallbacks.incr();
    }

    @Override
    public void authenticationSuccess() {
        this.authenticationSuccesses.incr();
    }

    @Override
    public void sentBytes(long count) {
        this.sentBytes.incr(count);
    }

    @Override
    public void receivedBytes(int count) {
        this.receivedBytes.incr(count);
    }

    @Override
    public void sentResponse(long count) {
        this.responseSize.add(count);
    }

    @Override
    public void receivedRequest(long count) {
        this.requestSize.add(count);
    }

    @Override
    public void dequeuedCall(int qTime) {
        this.queueCallTime.add(qTime);
    }

    @Override
    public void processedCall(int processingTime) {
        this.processCallTime.add(processingTime);
    }

    @Override
    public void queuedAndProcessedCall(int totalTime) {
        this.totalCallTime.add(totalTime);
    }

    @Override
    public void unwritableTime(long unwritableTime) {
        this.unwritableTime.add(unwritableTime);
    }

    @Override
    public void maxOutboundBytesExceeded() {
        this.maxOutboundBytesExceeded.incr();
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.wrapper != null) {
            mrb.addGauge(Interns.info("queueSize", "Number of bytes in the call queues; request has been read and parsed and is waiting to run or is currently being executed."), this.wrapper.getTotalQueueSize()).addGauge(Interns.info("numCallsInGeneralQueue", "Number of calls in the general call queue; parsed requests waiting in scheduler to be executed"), this.wrapper.getGeneralQueueLength()).addGauge(Interns.info("numCallsInReplicationQueue", "Number of calls in the replication call queue waiting to be run"), this.wrapper.getReplicationQueueLength()).addGauge(Interns.info("numCallsInBulkLoadQueue", "Number of calls in the bulkload call queue waiting to be run"), this.wrapper.getBulkLoadQueueLength()).addGauge(Interns.info("numCallsInPriorityQueue", "Number of calls in the priority call queue waiting to be run"), this.wrapper.getPriorityQueueLength()).addGauge(Interns.info("numCallsInMetaPriorityQueue", "Number of calls in the priority call queue waiting to be run"), this.wrapper.getMetaPriorityQueueLength()).addGauge(Interns.info("numOpenConnections", "Number of open connections."), this.wrapper.getNumOpenConnections()).addGauge(Interns.info("numActiveHandler", "Total number of active rpc handlers."), this.wrapper.getActiveRpcHandlerCount()).addGauge(Interns.info("numActiveGeneralHandler", "Number of active general rpc handlers."), this.wrapper.getActiveGeneralRpcHandlerCount()).addGauge(Interns.info("numActivePriorityHandler", "Number of active priority rpc handlers."), this.wrapper.getActivePriorityRpcHandlerCount()).addGauge(Interns.info("numActiveReplicationHandler", "Number of active replication rpc handlers."), this.wrapper.getActiveReplicationRpcHandlerCount()).addCounter(Interns.info("numGeneralCallsDropped", "Total number of calls in general queue which were dropped by CoDel RPC executor"), this.wrapper.getNumGeneralCallsDropped()).addCounter(Interns.info("numLifoModeSwitches", "Total number of calls in general queue which were served from the tail of the queue"), this.wrapper.getNumLifoModeSwitches()).addGauge(Interns.info("numCallsInWriteQueue", "Number of calls in the write call queue; parsed requests waiting in scheduler to be executed"), this.wrapper.getWriteQueueLength()).addGauge(Interns.info("numActiveBulkLoadHandler", "Number of active bulkload rpc handlers."), this.wrapper.getActiveBulkLoadRpcHandlerCount()).addGauge(Interns.info("numCallsInReadQueue", "Number of calls in the read call queue; parsed requests waiting in scheduler to be executed"), this.wrapper.getReadQueueLength()).addGauge(Interns.info("numCallsInScanQueue", "Number of calls in the scan call queue; parsed requests waiting in scheduler to be executed"), this.wrapper.getScanQueueLength()).addGauge(Interns.info("numActiveWriteHandler", "Number of active write rpc handlers."), this.wrapper.getActiveWriteRpcHandlerCount()).addGauge(Interns.info("numActiveReadHandler", "Number of active read rpc handlers."), this.wrapper.getActiveReadRpcHandlerCount()).addGauge(Interns.info("numActiveScanHandler", "Number of active scan rpc handlers."), this.wrapper.getActiveScanRpcHandlerCount()).addGauge(Interns.info("nettyDirectMemoryUsage", "Current Netty direct memory usage."), this.wrapper.getNettyDmUsage());
            Pair<Long, Long> totalAndMax = this.wrapper.getTotalAndMaxNettyOutboundBytes();
            mrb.addGauge(Interns.info("nettyTotalPendingOutboundBytes", "Current total bytes pending write to all channel"), ((Long)totalAndMax.getFirst()).longValue());
            mrb.addGauge(Interns.info("nettyMaxPendingOutboundBytes", "Current maximum bytes pending write to any channel"), ((Long)totalAndMax.getSecond()).longValue());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

