/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import org.apache.hadoop.hbase.ipc.MetricsHBaseServerSource;
import org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;

public class MetricsHBaseServerSourceImpl
extends BaseSourceImpl
implements MetricsHBaseServerSource {
    private final MetricsHBaseServerWrapper wrapper;
    private final MetricMutableCounterLong authorizationSuccesses;
    private final MetricMutableCounterLong authorizationFailures;
    private final MetricMutableCounterLong authenticationSuccesses;
    private final MetricMutableCounterLong authenticationFailures;
    private final MetricMutableCounterLong sentBytes;
    private final MetricMutableCounterLong receivedBytes;
    private MetricMutableHistogram queueCallTime;
    private MetricMutableHistogram processCallTime;

    public MetricsHBaseServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsHBaseServerWrapper wrapper) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.wrapper = wrapper;
        this.authorizationSuccesses = this.getMetricsRegistry().newCounter("authorizationSuccesses", "Number of authorization successes.", 0L);
        this.authorizationFailures = this.getMetricsRegistry().newCounter("authorizationFailures", "Number of authorization failures.", 0L);
        this.authenticationSuccesses = this.getMetricsRegistry().newCounter("authenticationSuccesses", "Number of authentication successes.", 0L);
        this.authenticationFailures = this.getMetricsRegistry().newCounter("authenticationFailures", "Number of authentication failures.", 0L);
        this.sentBytes = this.getMetricsRegistry().newCounter("sentBytes", "Number of bytes sent.", 0L);
        this.receivedBytes = this.getMetricsRegistry().newCounter("receivedBytes", "Number of bytes received.", 0L);
        this.queueCallTime = this.getMetricsRegistry().newHistogram("queueCallTime", "Queue Call Time.");
        this.processCallTime = this.getMetricsRegistry().newHistogram("processCallTime", "Processing call time.");
    }

    public void authorizationSuccess() {
        this.authorizationSuccesses.incr();
    }

    public void authorizationFailure() {
        this.authorizationFailures.incr();
    }

    public void authenticationFailure() {
        this.authenticationFailures.incr();
    }

    public void authenticationSuccess() {
        this.authenticationSuccesses.incr();
    }

    public void sentBytes(long count) {
        this.sentBytes.incr(count);
    }

    public void receivedBytes(int count) {
        this.receivedBytes.incr((long)count);
    }

    public void dequeuedCall(int qTime) {
        this.queueCallTime.add(qTime);
    }

    public void processedCall(int processingTime) {
        this.processCallTime.add(processingTime);
    }

    @Override
    public void getMetrics(MetricsBuilder metricsBuilder, boolean all) {
        MetricsRecordBuilder mrb = metricsBuilder.addRecord(this.metricsName);
        if (this.wrapper != null) {
            mrb.addGauge("queueSize", "Number of bytes in the call queues.", this.wrapper.getTotalQueueSize()).addGauge("numCallsInGeneralQueue", "Number of calls in the general call queue.", this.wrapper.getGeneralQueueLength()).addGauge("numCallsInReplicationQueue", "Number of calls in the replication call queue.", this.wrapper.getReplicationQueueLength()).addGauge("numCallsInPriorityQueue", "Number of calls in the priority call queue.", this.wrapper.getPriorityQueueLength()).addGauge("numOpenConnections", "Number of open connections.", this.wrapper.getNumOpenConnections()).addGauge("numActiveHandler", "Number of active rpc handlers.", this.wrapper.getActiveRpcHandlerCount());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

