/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics;

import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.impl.JmxCacheBuster;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;
import org.apache.hadoop.metrics2.lib.MetricMutableQuantiles;
import org.apache.hadoop.metrics2.source.JvmMetricsSource;

public class BaseSourceImpl
implements BaseSource,
MetricsSource {
    protected final DynamicMetricsRegistry metricsRegistry;
    protected final String metricsName;
    protected final String metricsDescription;
    protected final String metricsContext;
    protected final String metricsJmxContext;

    public BaseSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        this.metricsName = metricsName;
        this.metricsDescription = metricsDescription;
        this.metricsContext = metricsContext;
        this.metricsJmxContext = metricsJmxContext;
        this.metricsRegistry = new DynamicMetricsRegistry(metricsName).setContext(metricsContext);
        DefaultMetricsSystemInitializer.INSTANCE.init(metricsName);
        DefaultMetricsSystem.registerSource((String)metricsJmxContext, (String)metricsDescription, (MetricsSource)this);
        this.init();
    }

    public void init() {
        this.metricsRegistry.clearMetrics();
    }

    public void setGauge(String gaugeName, long value) {
        MetricMutableGaugeLong gaugeInt = this.metricsRegistry.getLongGauge(gaugeName, value);
        gaugeInt.set(value);
    }

    public void incGauge(String gaugeName, long delta) {
        MetricMutableGaugeLong gaugeInt = this.metricsRegistry.getLongGauge(gaugeName, 0L);
        gaugeInt.incr(delta);
    }

    public void decGauge(String gaugeName, long delta) {
        MetricMutableGaugeLong gaugeInt = this.metricsRegistry.getLongGauge(gaugeName, 0L);
        gaugeInt.decr(delta);
    }

    public void incCounters(String key, long delta) {
        MetricMutableCounterLong counter = this.metricsRegistry.getLongCounter(key, 0L);
        counter.incr(delta);
    }

    public void updateHistogram(String name, long value) {
        MetricMutableHistogram histo = this.metricsRegistry.getHistogram(name);
        histo.add(value);
    }

    public void updateQuantile(String name, long value) {
        MetricMutableQuantiles histo = this.metricsRegistry.getQuantile(name);
        histo.add(value);
    }

    public void removeMetric(String key) {
        this.metricsRegistry.removeMetric(key);
        JmxCacheBuster.clearJmxCache();
    }

    public void getMetrics(MetricsBuilder metricsBuilder, boolean all) {
        MetricsRecordBuilder mrb = metricsBuilder.addRecord(this.metricsName).setContext(this.metricsContext);
        this.metricsRegistry.snapshot(mrb, all);
    }

    public DynamicMetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public String getMetricsContext() {
        return this.metricsContext;
    }

    public String getMetricsDescription() {
        return this.metricsDescription;
    }

    public String getMetricsJmxContext() {
        return this.metricsJmxContext;
    }

    public String getMetricsName() {
        return this.metricsName;
    }

    private static enum DefaultMetricsSystemInitializer {
        INSTANCE;

        private boolean inited = false;
        private JvmMetricsSource jvmMetricsSource;

        synchronized void init(String name) {
            if (this.inited) {
                return;
            }
            this.inited = true;
            DefaultMetricsSystem.initialize((String)"HBase");
            this.jvmMetricsSource = JvmMetricsSource.create((String)name, (String)"");
        }
    }
}

