/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.rest.MetricsRESTSource;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;

public class MetricsRESTSourceImpl
extends BaseSourceImpl
implements MetricsRESTSource {
    private MetricMutableCounterLong request;
    private MetricMutableCounterLong sucGet;
    private MetricMutableCounterLong sucPut;
    private MetricMutableCounterLong sucDel;
    private MetricMutableCounterLong sucScan;
    private MetricMutableCounterLong fGet;
    private MetricMutableCounterLong fPut;
    private MetricMutableCounterLong fDel;
    private MetricMutableCounterLong fScan;

    public MetricsRESTSourceImpl() {
        this("REST", "Metrics about the HBase REST server", "rest", "REST");
    }

    public MetricsRESTSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        super.init();
        this.request = this.getMetricsRegistry().getLongCounter("requests", 0L);
        this.sucGet = this.getMetricsRegistry().getLongCounter("successfulGet", 0L);
        this.sucPut = this.getMetricsRegistry().getLongCounter("successfulPut", 0L);
        this.sucDel = this.getMetricsRegistry().getLongCounter("successfulDelete", 0L);
        this.sucScan = this.getMetricsRegistry().getLongCounter("successfulScanCount", 0L);
        this.fGet = this.getMetricsRegistry().getLongCounter("failedGet", 0L);
        this.fPut = this.getMetricsRegistry().getLongCounter("failedPut", 0L);
        this.fDel = this.getMetricsRegistry().getLongCounter("failedDelete", 0L);
        this.fScan = this.getMetricsRegistry().getLongCounter("failedScanCount", 0L);
    }

    public void incrementRequests(int inc) {
        this.request.incr((long)inc);
    }

    public void incrementSucessfulGetRequests(int inc) {
        this.sucGet.incr((long)inc);
    }

    public void incrementSucessfulPutRequests(int inc) {
        this.sucPut.incr((long)inc);
    }

    public void incrementSucessfulDeleteRequests(int inc) {
        this.sucDel.incr((long)inc);
    }

    public void incrementFailedGetRequests(int inc) {
        this.fGet.incr((long)inc);
    }

    public void incrementFailedPutRequests(int inc) {
        this.fPut.incr((long)inc);
    }

    public void incrementFailedDeleteRequests(int inc) {
        this.fDel.incr((long)inc);
    }

    public void incrementSucessfulScanRequests(int inc) {
        this.sucScan.incr((long)inc);
    }

    public void incrementFailedScanRequests(int inc) {
        this.fScan.incr((long)inc);
    }
}

