/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSourceImpl;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;

@InterfaceAudience.Private
public class MetricsTableAggregateSourceImpl
extends BaseSourceImpl
implements MetricsTableAggregateSource {
    private static final Log LOG = LogFactory.getLog(MetricsTableAggregateSourceImpl.class);
    private ConcurrentHashMap<String, MetricsTableSource> tableSources = new ConcurrentHashMap();

    public MetricsTableAggregateSourceImpl() {
        this("Tables", "Metrics about HBase RegionServer tables", "regionserver", "RegionServer,sub=Tables");
    }

    public MetricsTableAggregateSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    public void register(String table, MetricsTableSource source) {
        this.tableSources.put(table, source);
    }

    public void deregister(String table) {
        try {
            this.tableSources.remove(table);
        }
        catch (Exception e) {
            LOG.info((Object)("Error trying to remove " + table + " from " + this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder mrb = collector.addRecord(this.metricsName);
        if (this.tableSources != null) {
            for (MetricsTableSource tableMetricSource : this.tableSources.values()) {
                if (!(tableMetricSource instanceof MetricsTableSourceImpl)) continue;
                ((MetricsTableSourceImpl)tableMetricSource).snapshot(mrb, all);
            }
            mrb.addGauge(Interns.info("numTables", "Number of tables in the metrics system"), this.tableSources.size());
            this.metricsRegistry.snapshot(mrb, all);
        }
    }
}

