/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;

@InterfaceAudience.Private
public class NoOpDataBlockEncoder
implements HFileDataBlockEncoder {
    public static final NoOpDataBlockEncoder INSTANCE = new NoOpDataBlockEncoder();

    private NoOpDataBlockEncoder() {
    }

    @Override
    public HFileBlock diskToCacheFormat(HFileBlock block, boolean isCompaction) {
        if (block.getBlockType() == BlockType.ENCODED_DATA) {
            throw new IllegalStateException("Unexpected encoded block");
        }
        return block;
    }

    @Override
    public void beforeWriteToDisk(ByteBuffer in, boolean includesMemstoreTS, HFileBlockEncodingContext encodeCtx, BlockType blockType) throws IOException {
        if (!encodeCtx.getClass().getName().equals(HFileBlockDefaultEncodingContext.class.getName())) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + ".");
        }
        HFileBlockDefaultEncodingContext defaultContext = (HFileBlockDefaultEncodingContext)encodeCtx;
        defaultContext.compressAfterEncodingWithBlockType(in.array(), blockType);
    }

    @Override
    public boolean useEncodedScanner(boolean isCompaction) {
        return false;
    }

    @Override
    public void saveMetadata(HFile.Writer writer) {
    }

    @Override
    public DataBlockEncoding getEncodingOnDisk() {
        return DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEncodingInCache() {
        return DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        return DataBlockEncoding.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public HFileBlockEncodingContext newOnDiskDataBlockEncodingContext(Compression.Algorithm compressionAlgorithm, byte[] dummyHeader) {
        return new HFileBlockDefaultEncodingContext(compressionAlgorithm, null, dummyHeader);
    }

    @Override
    public HFileBlockDecodingContext newOnDiskDataBlockDecodingContext(Compression.Algorithm compressionAlgorithm) {
        return new HFileBlockDefaultDecodingContext(compressionAlgorithm);
    }
}

