/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.net.DNS;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class TableInputFormatBase
extends InputFormat<ImmutableBytesWritable, Result> {
    final Log LOG = LogFactory.getLog(TableInputFormatBase.class);
    private Scan scan = null;
    private HTable table = null;
    private TableRecordReader tableRecordReader = null;
    private HashMap<InetAddress, String> reverseDNSCacheMap = new HashMap();
    private String nameServer = null;

    public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException {
        if (this.table == null) {
            throw new IOException("Cannot create a record reader because of a previous error. Please look at the previous logs lines from the task's full log for more details.");
        }
        TableSplit tSplit = (TableSplit)split;
        TableRecordReader trr = this.tableRecordReader;
        if (trr == null) {
            trr = new TableRecordReader();
        }
        Scan sc = new Scan(this.scan);
        sc.setStartRow(tSplit.getStartRow());
        sc.setStopRow(tSplit.getEndRow());
        trr.setScan(sc);
        trr.setHTable(this.table);
        try {
            trr.initialize(tSplit, context);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        return trr;
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        if (this.table == null) {
            throw new IOException("No table was provided.");
        }
        this.nameServer = context.getConfiguration().get("hbase.nameserver.address", null);
        Pair keys = this.table.getStartEndKeys();
        if (keys == null || keys.getFirst() == null || ((byte[][])keys.getFirst()).length == 0) {
            HRegionLocation regLoc = this.table.getRegionLocation(HConstants.EMPTY_BYTE_ARRAY, false);
            if (null == regLoc) {
                throw new IOException("Expecting at least one region.");
            }
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(1);
            TableSplit split = new TableSplit(this.table.getName(), HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, regLoc.getHostnamePort().split(":")[0]);
            splits.add(split);
            return splits;
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(((byte[][])keys.getFirst()).length);
        for (int i = 0; i < ((byte[][])keys.getFirst()).length; ++i) {
            String regionLocation;
            if (!this.includeRegionInSplit(((byte[][])keys.getFirst())[i], ((byte[][])keys.getSecond())[i])) continue;
            HRegionLocation location = this.table.getRegionLocation(((byte[][])keys.getFirst())[i], false);
            InetSocketAddress isa = new InetSocketAddress(location.getHostname(), location.getPort());
            if (isa.isUnresolved()) {
                this.LOG.warn((Object)("Failed resolve " + isa));
            }
            InetAddress regionAddress = isa.getAddress();
            try {
                regionLocation = this.reverseDNS(regionAddress);
            }
            catch (NamingException e) {
                this.LOG.error((Object)("Cannot resolve the host name for " + regionAddress + " because of " + e));
                regionLocation = location.getHostname();
            }
            byte[] startRow = this.scan.getStartRow();
            byte[] stopRow = this.scan.getStopRow();
            if (startRow.length != 0 && ((byte[][])keys.getSecond())[i].length != 0 && Bytes.compareTo((byte[])startRow, (byte[])((byte[][])keys.getSecond())[i]) >= 0 || stopRow.length != 0 && Bytes.compareTo((byte[])stopRow, (byte[])((byte[][])keys.getFirst())[i]) <= 0) continue;
            byte[] splitStart = startRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getFirst())[i], (byte[])startRow) >= 0 ? ((byte[][])keys.getFirst())[i] : startRow;
            byte[] splitStop = (stopRow.length == 0 || Bytes.compareTo((byte[])((byte[][])keys.getSecond())[i], (byte[])stopRow) <= 0) && ((byte[][])keys.getSecond())[i].length > 0 ? ((byte[][])keys.getSecond())[i] : stopRow;
            TableSplit split = new TableSplit(this.table.getName(), splitStart, splitStop, regionLocation);
            splits.add(split);
            if (!this.LOG.isDebugEnabled()) continue;
            this.LOG.debug((Object)("getSplits: split -> " + i + " -> " + split));
        }
        return splits;
    }

    private String reverseDNS(InetAddress ipAddress) throws NamingException {
        String hostName = this.reverseDNSCacheMap.get(ipAddress);
        if (hostName == null) {
            hostName = Strings.domainNamePointerToHostName((String)DNS.reverseDns((InetAddress)ipAddress, (String)this.nameServer));
            this.reverseDNSCacheMap.put(ipAddress, hostName);
        }
        return hostName;
    }

    protected boolean includeRegionInSplit(byte[] startKey, byte[] endKey) {
        return true;
    }

    protected HTable getHTable() {
        return this.table;
    }

    protected void setHTable(HTable table) {
        this.table = table;
    }

    public Scan getScan() {
        if (this.scan == null) {
            this.scan = new Scan();
        }
        return this.scan;
    }

    public void setScan(Scan scan) {
        this.scan = scan;
    }

    protected void setTableRecordReader(TableRecordReader tableRecordReader) {
        this.tableRecordReader = tableRecordReader;
    }
}

