/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.SplitLogCounters;
import org.apache.hadoop.hbase.SplitLogTask;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LastSequenceId;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class SplitLogWorker
extends ZooKeeperListener
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SplitLogWorker.class);
    private static final int checkInterval = 5000;
    Thread worker;
    private final ServerName serverName;
    private final TaskExecutor splitTaskExecutor;
    private final Object taskReadyLock = new Object();
    volatile int taskReadySeq = 0;
    private volatile String currentTask = null;
    private int currentVersion;
    private volatile boolean exitWorker;
    private final Object grabTaskLock = new Object();
    private boolean workerInGrabTask = false;
    private final int report_period;
    private RegionServerServices server = null;
    private Configuration conf = null;

    public SplitLogWorker(ZooKeeperWatcher watcher, Configuration conf, RegionServerServices server, TaskExecutor splitTaskExecutor) {
        super(watcher);
        this.server = server;
        this.serverName = server.getServerName();
        this.splitTaskExecutor = splitTaskExecutor;
        this.report_period = conf.getInt("hbase.splitlog.report.period", conf.getInt("hbase.splitlog.manager.timeout", 120000) / 3);
        this.conf = conf;
    }

    public SplitLogWorker(ZooKeeperWatcher watcher, Configuration conf, ServerName serverName, TaskExecutor splitTaskExecutor) {
        super(watcher);
        this.serverName = serverName;
        this.splitTaskExecutor = splitTaskExecutor;
        this.report_period = conf.getInt("hbase.splitlog.report.period", conf.getInt("hbase.splitlog.manager.timeout", 120000) / 3);
        this.conf = conf;
    }

    public SplitLogWorker(final ZooKeeperWatcher watcher, final Configuration conf, RegionServerServices server, final LastSequenceId sequenceIdChecker) {
        this(watcher, conf, server, new TaskExecutor(){

            @Override
            public TaskExecutor.Status exec(String filename, CancelableProgressable p) {
                FileSystem fs;
                Path rootdir;
                try {
                    rootdir = FSUtils.getRootDir(conf);
                    fs = rootdir.getFileSystem(conf);
                }
                catch (IOException e) {
                    LOG.warn((Object)"could not find root dir or fs", (Throwable)e);
                    return TaskExecutor.Status.RESIGNED;
                }
                try {
                    if (!HLogSplitter.splitLogFile(rootdir, fs.getFileStatus(new Path(rootdir, filename)), fs, conf, p, sequenceIdChecker, watcher)) {
                        return TaskExecutor.Status.PREEMPTED;
                    }
                }
                catch (InterruptedIOException iioe) {
                    LOG.warn((Object)("log splitting of " + filename + " interrupted, resigning"), (Throwable)iioe);
                    return TaskExecutor.Status.RESIGNED;
                }
                catch (IOException e) {
                    Throwable cause = e.getCause();
                    if (e instanceof RetriesExhaustedException && (cause instanceof NotServingRegionException || cause instanceof ConnectException || cause instanceof SocketTimeoutException)) {
                        LOG.warn((Object)("log replaying of " + filename + " can't connect to the target regionserver, " + "resigning"), (Throwable)e);
                        return TaskExecutor.Status.RESIGNED;
                    }
                    if (cause instanceof InterruptedException) {
                        LOG.warn((Object)("log splitting of " + filename + " interrupted, resigning"), (Throwable)e);
                        return TaskExecutor.Status.RESIGNED;
                    }
                    if (cause instanceof KeeperException) {
                        LOG.warn((Object)("log splitting of " + filename + " hit ZooKeeper issue, resigning"), (Throwable)e);
                        return TaskExecutor.Status.RESIGNED;
                    }
                    LOG.warn((Object)("log splitting of " + filename + " failed, returning error"), (Throwable)e);
                    return TaskExecutor.Status.ERR;
                }
                return TaskExecutor.Status.DONE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.info((Object)("SplitLogWorker " + this.serverName + " starting"));
            this.watcher.registerListener((ZooKeeperListener)this);
            boolean distributedLogReplay = this.conf.getBoolean("hbase.master.distributed.log.replay", false);
            if (distributedLogReplay) {
                HConnectionManager.getConnection((Configuration)this.conf);
            }
            int res = -1;
            while (res == -1 && !this.exitWorker) {
                try {
                    res = ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)this.watcher.splitLogZNode);
                }
                catch (KeeperException e) {
                    LOG.warn((Object)("Exception when checking for " + this.watcher.splitLogZNode + " ... retrying"), (Throwable)e);
                }
                if (res != -1) continue;
                try {
                    LOG.info((Object)(this.watcher.splitLogZNode + " znode does not exist, waiting for master to create"));
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Interrupted while waiting for " + this.watcher.splitLogZNode + (this.exitWorker ? "" : " (ERROR: exitWorker is not set, exiting anyway)")));
                    this.exitWorker = true;
                    break;
                }
            }
            if (!this.exitWorker) {
                this.taskLoop();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"unexpected error ", t);
        }
        finally {
            LOG.info((Object)("SplitLogWorker " + this.serverName + " exiting"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void taskLoop() {
        while (!this.exitWorker) {
            int i;
            int seq_start = this.taskReadySeq;
            List<String> paths = this.getTaskList();
            if (paths == null) {
                LOG.warn((Object)("Could not get tasks, did someone remove " + this.watcher.splitLogZNode + " ... worker thread exiting."));
                return;
            }
            int offset = (int)(Math.random() * (double)paths.size());
            for (i = 0; i < paths.size(); ++i) {
                if (!HLogUtil.isMetaFile(paths.get(i))) continue;
                offset = i;
                break;
            }
            for (i = 0; i < paths.size(); ++i) {
                int idx = (i + offset) % paths.size();
                this.grabTask(ZKUtil.joinZNode((String)this.watcher.splitLogZNode, (String)paths.get(idx)));
                if (!this.exitWorker) continue;
                return;
            }
            SplitLogCounters.tot_wkr_task_grabing.incrementAndGet();
            Object object = this.taskReadyLock;
            synchronized (object) {
                block9: while (seq_start == this.taskReadySeq) {
                    try {
                        Map<String, HRegion> recoveringRegions;
                        this.taskReadyLock.wait(5000L);
                        if (this.server == null || (recoveringRegions = this.server.getRecoveringRegions()).isEmpty()) continue;
                        ArrayList<String> tmpCopy = new ArrayList<String>(recoveringRegions.keySet());
                        for (String region : tmpCopy) {
                            String nodePath = ZKUtil.joinZNode((String)this.watcher.recoveringRegionsZNode, (String)region);
                            try {
                                if (ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)nodePath) != -1) continue block9;
                                HRegion r = recoveringRegions.remove(region);
                                if (r != null) {
                                    r.setRecovering(false);
                                }
                                LOG.debug((Object)("Mark recovering region:" + region + " up."));
                            }
                            catch (KeeperException e) {
                                LOG.debug((Object)"Got a zookeeper when trying to open a recovering region", (Throwable)e);
                                continue block9;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)("SplitLogWorker interrupted while waiting for task, exiting: " + e.toString() + (this.exitWorker ? "" : " (ERROR: exitWorker is not set, exiting anyway)")));
                        this.exitWorker = true;
                        return;
                    }
                }
            }
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void grabTask(String path) {
        SplitLogTask slt;
        Stat stat = new Stat();
        long t = -1L;
        Object object = this.grabTaskLock;
        synchronized (object) {
            this.currentTask = path;
            this.workerInGrabTask = true;
            if (Thread.interrupted()) {
                return;
            }
        }
        try {
            byte[] data = ZKUtil.getDataNoWatch((ZooKeeperWatcher)this.watcher, (String)path, (Stat)stat);
            if (data == null) {
                SplitLogCounters.tot_wkr_failed_to_grab_task_no_data.incrementAndGet();
                return;
            }
            try {
                slt = SplitLogTask.parseFrom(data);
            }
            catch (DeserializationException e) {
                LOG.warn((Object)("Failed parse data for znode " + path), (Throwable)e);
                SplitLogCounters.tot_wkr_failed_to_grab_task_exception.incrementAndGet();
                if (t > 0L) {
                    LOG.info((Object)("worker " + this.serverName + " done with task " + path + " in " + (System.currentTimeMillis() - t) + "ms"));
                }
                Object object2 = this.grabTaskLock;
                synchronized (object2) {
                    this.workerInGrabTask = false;
                    Thread.interrupted();
                    return;
                }
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Failed to get data for znode " + path), (Throwable)e);
            SplitLogCounters.tot_wkr_failed_to_grab_task_exception.incrementAndGet();
            return;
        }
        if (!slt.isUnassigned()) {
            SplitLogCounters.tot_wkr_failed_to_grab_task_owned.incrementAndGet();
            return;
        }
        this.currentVersion = stat.getVersion();
        if (!this.attemptToOwnTask(true)) {
            SplitLogCounters.tot_wkr_failed_to_grab_task_lost_race.incrementAndGet();
            return;
        }
        if (ZKSplitLog.isRescanNode(this.watcher, this.currentTask)) {
            this.endTask(new SplitLogTask.Done(this.serverName), SplitLogCounters.tot_wkr_task_acquired_rescan);
            return;
        }
        LOG.info((Object)("worker " + this.serverName + " acquired task " + path));
        SplitLogCounters.tot_wkr_task_acquired.incrementAndGet();
        this.getDataSetWatchAsync();
        t = System.currentTimeMillis();
        TaskExecutor.Status status = this.splitTaskExecutor.exec(ZKSplitLog.getFileName(this.currentTask), new CancelableProgressable(){
            private long last_report_at = 0L;

            @Override
            public boolean progress() {
                long t = EnvironmentEdgeManager.currentTimeMillis();
                if (t - this.last_report_at > (long)SplitLogWorker.this.report_period) {
                    this.last_report_at = t;
                    if (!SplitLogWorker.this.attemptToOwnTask(false)) {
                        LOG.warn((Object)("Failed to heartbeat the task" + SplitLogWorker.this.currentTask));
                        return false;
                    }
                }
                return true;
            }
        });
        switch (status) {
            case DONE: {
                this.endTask(new SplitLogTask.Done(this.serverName), SplitLogCounters.tot_wkr_task_done);
                return;
            }
            case PREEMPTED: {
                SplitLogCounters.tot_wkr_preempt_task.incrementAndGet();
                LOG.warn((Object)("task execution prempted " + path));
                return;
            }
            case ERR: {
                if (!this.exitWorker) {
                    this.endTask(new SplitLogTask.Err(this.serverName), SplitLogCounters.tot_wkr_task_err);
                    return;
                }
            }
            case RESIGNED: {
                if (this.exitWorker) {
                    LOG.info((Object)("task execution interrupted because worker is exiting " + path));
                }
                this.endTask(new SplitLogTask.Resigned(this.serverName), SplitLogCounters.tot_wkr_task_resigned);
                return;
            }
        }
        return;
        finally {
            if (t > 0L) {
                LOG.info((Object)("worker " + this.serverName + " done with task " + path + " in " + (System.currentTimeMillis() - t) + "ms"));
            }
            object = this.grabTaskLock;
            synchronized (object) {
                this.workerInGrabTask = false;
                Thread.interrupted();
            }
        }
    }

    private boolean attemptToOwnTask(boolean isFirstTime) {
        try {
            SplitLogTask.Owned slt = new SplitLogTask.Owned(this.serverName);
            Stat stat = this.watcher.getRecoverableZooKeeper().setData(this.currentTask, slt.toByteArray(), this.currentVersion);
            if (stat == null) {
                LOG.warn((Object)("zk.setData() returned null for path " + this.currentTask));
                SplitLogCounters.tot_wkr_task_heartbeat_failed.incrementAndGet();
                return false;
            }
            this.currentVersion = stat.getVersion();
            SplitLogCounters.tot_wkr_task_heartbeat.incrementAndGet();
            return true;
        }
        catch (KeeperException e) {
            if (!isFirstTime) {
                if (e.code().equals((Object)KeeperException.Code.NONODE)) {
                    LOG.warn((Object)("NONODE failed to assert ownership for " + this.currentTask), (Throwable)e);
                } else if (e.code().equals((Object)KeeperException.Code.BADVERSION)) {
                    LOG.warn((Object)("BADVERSION failed to assert ownership for " + this.currentTask), (Throwable)e);
                } else {
                    LOG.warn((Object)("failed to assert ownership for " + this.currentTask), (Throwable)e);
                }
            }
        }
        catch (InterruptedException e1) {
            LOG.warn((Object)("Interrupted while trying to assert ownership of " + this.currentTask + " " + StringUtils.stringifyException((Throwable)e1)));
            Thread.currentThread().interrupt();
        }
        SplitLogCounters.tot_wkr_task_heartbeat_failed.incrementAndGet();
        return false;
    }

    private void endTask(SplitLogTask slt, AtomicLong ctr) {
        String path = this.currentTask;
        this.currentTask = null;
        try {
            if (ZKUtil.setData((ZooKeeperWatcher)this.watcher, (String)path, (byte[])slt.toByteArray(), (int)this.currentVersion)) {
                LOG.info((Object)("successfully transitioned task " + path + " to final state " + slt));
                ctr.incrementAndGet();
                return;
            }
            LOG.warn((Object)("failed to transistion task " + path + " to end state " + slt + " because of version mismatch "));
        }
        catch (KeeperException.BadVersionException bve) {
            LOG.warn((Object)("transisition task " + path + " to " + slt + " failed because of version mismatch"), (Throwable)bve);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.fatal((Object)("logic error - end task " + path + " " + slt + " failed because task doesn't exist"), (Throwable)e);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("failed to end task, " + path + " " + slt), (Throwable)e);
        }
        SplitLogCounters.tot_wkr_final_transition_failed.incrementAndGet();
    }

    void getDataSetWatchAsync() {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(this.currentTask, (Watcher)this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), null);
        SplitLogCounters.tot_wkr_get_data_queued.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDataSetWatchSuccess(String path, byte[] data) {
        SplitLogTask slt;
        try {
            slt = SplitLogTask.parseFrom(data);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)"Failed parse", (Throwable)e);
            return;
        }
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path) && !slt.isOwned(this.serverName) && !slt.isDone(this.serverName) && !slt.isErr(this.serverName) && !slt.isResigned(this.serverName)) {
                LOG.info((Object)("task " + taskpath + " preempted from " + this.serverName + ", current task state and owner=" + slt.toString()));
                this.stopTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getDataSetWatchFailure(String path) {
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path)) {
                LOG.info((Object)("retrying data watch on " + path));
                SplitLogCounters.tot_wkr_get_data_retry.incrementAndGet();
                this.getDataSetWatchAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeDataChanged(String path) {
        Object object = this.grabTaskLock;
        synchronized (object) {
            String taskpath;
            if (this.workerInGrabTask && (taskpath = this.currentTask) != null && taskpath.equals(path)) {
                this.getDataSetWatchAsync();
            }
        }
    }

    private List<String> getTaskList() {
        List childrenPaths = null;
        long sleepTime = 1000L;
        while (!this.exitWorker) {
            try {
                childrenPaths = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)this.watcher.splitLogZNode);
                if (childrenPaths != null) {
                    return childrenPaths;
                }
            }
            catch (KeeperException e) {
                LOG.warn((Object)("Could not get children of znode " + this.watcher.splitLogZNode), (Throwable)e);
            }
            try {
                LOG.debug((Object)("Retry listChildren of znode " + this.watcher.splitLogZNode + " after sleep for " + sleepTime + "ms!"));
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e1) {
                LOG.warn((Object)"Interrupted while trying to get task list ...", (Throwable)e1);
                Thread.currentThread().interrupt();
            }
        }
        return childrenPaths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeChildrenChanged(String path) {
        if (path.equals(this.watcher.splitLogZNode)) {
            LOG.debug((Object)"tasks arrived or departed");
            Object object = this.taskReadyLock;
            synchronized (object) {
                ++this.taskReadySeq;
                this.taskReadyLock.notify();
            }
        }
    }

    void stopTask() {
        LOG.info((Object)"Sending interrupt to stop the worker thread");
        this.worker.interrupt();
    }

    public void start() {
        this.worker = new Thread(null, this, "SplitLogWorker-" + this.serverName);
        this.exitWorker = false;
        this.worker.start();
    }

    public void stop() {
        this.exitWorker = true;
        this.stopTask();
    }

    public static interface TaskExecutor {
        public Status exec(String var1, CancelableProgressable var2);

        public static enum Status {
            DONE,
            ERR,
            RESIGNED,
            PREEMPTED;

        }
    }

    class GetDataAsyncCallback
    implements AsyncCallback.DataCallback {
        private final Log LOG = LogFactory.getLog(GetDataAsyncCallback.class);

        GetDataAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            SplitLogCounters.tot_wkr_get_data_result.incrementAndGet();
            if (rc != 0) {
                this.LOG.warn((Object)("getdata rc = " + KeeperException.Code.get((int)rc) + " " + path));
                SplitLogWorker.this.getDataSetWatchFailure(path);
                return;
            }
            data = SplitLogWorker.this.watcher.getRecoverableZooKeeper().removeMetaData(data);
            SplitLogWorker.this.getDataSetWatchSuccess(path, data);
        }
    }
}

