/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.filter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class GZIPResponseStream
extends ServletOutputStream {
    private HttpServletResponse response;
    private GZIPOutputStream out;

    public GZIPResponseStream(HttpServletResponse response) throws IOException {
        this.response = response;
        this.out = new GZIPOutputStream((OutputStream)response.getOutputStream());
        response.addHeader("Content-Encoding", "gzip");
    }

    public void resetBuffer() {
        if (this.out != null && !this.response.isCommitted()) {
            this.response.setHeader("Content-Encoding", null);
        }
        this.out = null;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void finish() throws IOException {
        this.out.finish();
    }
}

