/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hadoop.hbase.util.ByteBloomFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompoundBloomFilterBase;
import org.apache.hadoop.hbase.util.Hash;

@InterfaceAudience.Private
public class CompoundBloomFilter
extends CompoundBloomFilterBase
implements BloomFilter {
    private HFile.Reader reader;
    private HFileBlockIndex.BlockIndexReader index;
    private int hashCount;
    private Hash hash;
    private long[] numQueriesPerChunk;
    private long[] numPositivesPerChunk;

    public CompoundBloomFilter(DataInput meta, HFile.Reader reader) throws IOException {
        this.reader = reader;
        this.totalByteSize = meta.readLong();
        this.hashCount = meta.readInt();
        this.hashType = meta.readInt();
        this.totalKeyCount = meta.readLong();
        this.totalMaxKeys = meta.readLong();
        this.numChunks = meta.readInt();
        this.comparator = FixedFileTrailer.createComparator(Bytes.toString((byte[])Bytes.readByteArray((DataInput)meta)));
        this.hash = Hash.getInstance((int)this.hashType);
        if (this.hash == null) {
            throw new IllegalArgumentException("Invalid hash type: " + this.hashType);
        }
        this.index = new HFileBlockIndex.BlockIndexReader(this.comparator, 1);
        this.index.readRootIndex(meta, this.numChunks);
    }

    @Override
    public boolean contains(byte[] key, int keyOffset, int keyLength, ByteBuffer bloom) {
        boolean result;
        int block = this.index.rootBlockContainingKey(key, keyOffset, keyLength);
        if (block < 0) {
            result = false;
        } else {
            HFileBlock bloomBlock;
            try {
                bloomBlock = this.reader.readBlock(this.index.getRootBlockOffset(block), this.index.getRootBlockDataSize(block), true, true, false, BlockType.BLOOM_CHUNK);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Failed to load Bloom block for key " + Bytes.toStringBinary((byte[])key, (int)keyOffset, (int)keyLength), ex);
            }
            ByteBuffer bloomBuf = bloomBlock.getBufferReadOnly();
            result = ByteBloomFilter.contains(key, keyOffset, keyLength, bloomBuf.array(), bloomBuf.arrayOffset() + bloomBlock.headerSize(), bloomBlock.getUncompressedSizeWithoutHeader(), this.hash, this.hashCount);
        }
        if (this.numQueriesPerChunk != null && block >= 0) {
            int n = block;
            this.numQueriesPerChunk[n] = this.numQueriesPerChunk[n] + 1L;
            if (result) {
                int n2 = block;
                this.numPositivesPerChunk[n2] = this.numPositivesPerChunk[n2] + 1L;
            }
        }
        return result;
    }

    @Override
    public boolean supportsAutoLoading() {
        return true;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    @Override
    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }

    public void enableTestingStats() {
        this.numQueriesPerChunk = new long[this.numChunks];
        this.numPositivesPerChunk = new long[this.numChunks];
    }

    public String formatTestingStats() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numChunks; ++i) {
            sb.append("chunk #");
            sb.append(i);
            sb.append(": queries=");
            sb.append(this.numQueriesPerChunk[i]);
            sb.append(", positives=");
            sb.append(this.numPositivesPerChunk[i]);
            sb.append(", positiveRatio=");
            sb.append((double)this.numPositivesPerChunk[i] * 1.0 / (double)this.numQueriesPerChunk[i]);
            sb.append(";\n");
        }
        return sb.toString();
    }

    public long getNumQueriesForTesting(int chunk) {
        return this.numQueriesPerChunk[chunk];
    }

    public long getNumPositivesForTesting(int chunk) {
        return this.numPositivesPerChunk[chunk];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(ByteBloomFilter.formatStats(this));
        sb.append("; Number of chunks: " + this.numChunks);
        sb.append("; Comparator: " + this.comparator.getClass().getSimpleName());
        return sb.toString();
    }
}

